/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.wa.starter.webauthn;

import com.fasterxml.jackson.core.type.TypeReference;
import com.yubico.data.CredentialRegistration;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.wa.WebAuthnAccount;
import org.apache.syncope.common.lib.wa.WebAuthnDeviceCredential;
import org.apache.syncope.common.rest.api.service.wa.WebAuthnRegistrationService;
import org.apache.syncope.wa.bootstrap.WARestClient;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.webauthn.WebAuthnUtils;
import org.apereo.cas.webauthn.storage.BaseWebAuthnCredentialRepository;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WAWebAuthnCredentialRepository
extends BaseWebAuthnCredentialRepository {
    protected static final Logger LOG = LoggerFactory.getLogger(WAWebAuthnCredentialRepository.class);
    protected final WARestClient waRestClient;

    public WAWebAuthnCredentialRepository(CasConfigurationProperties properties, WARestClient waRestClient) {
        super(properties, CipherExecutor.noOpOfStringToString());
        this.waRestClient = waRestClient;
    }

    protected WebAuthnRegistrationService service() {
        return (WebAuthnRegistrationService)this.waRestClient.getService(WebAuthnRegistrationService.class);
    }

    public boolean removeRegistrationByUsername(String username, CredentialRegistration credentialRegistration) {
        String id = credentialRegistration.getCredential().getCredentialId().getHex();
        this.service().delete(username, id);
        return true;
    }

    public boolean removeAllRegistrations(String username) {
        this.service().delete(username);
        return true;
    }

    public Stream<? extends CredentialRegistration> stream() {
        return this.service().list().stream().map(WebAuthnAccount::getCredentials).flatMap(Collection::stream).map(Unchecked.function(record -> {
            String json = (String)this.getCipherExecutor().decode((Object)record.getJson());
            return (CredentialRegistration)WebAuthnUtils.getObjectMapper().readValue(json, (TypeReference)new TypeReference<CredentialRegistration>(){});
        }));
    }

    protected void update(String username, Collection<CredentialRegistration> records) {
        try {
            List credentials = records.stream().map(Unchecked.function(record -> {
                String json = (String)this.getCipherExecutor().encode((Object)WebAuthnUtils.getObjectMapper().writeValueAsString(record));
                return new WebAuthnDeviceCredential.Builder().json(json).identifier(record.getCredential().getCredentialId().getHex()).build();
            })).collect(Collectors.toList());
            WebAuthnAccount account = this.service().read(username);
            if (account != null) {
                account.getCredentials().addAll(credentials);
                this.service().update(username, account);
            } else {
                account = new WebAuthnAccount.Builder().credentials(credentials).build();
                this.service().create(username, account);
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    public Collection<CredentialRegistration> getRegistrationsByUsername(String username) {
        try {
            return this.service().read(username).getCredentials().stream().map(Unchecked.function(record -> {
                String json = (String)this.getCipherExecutor().decode((Object)record.getJson());
                return (CredentialRegistration)WebAuthnUtils.getObjectMapper().readValue(json, (TypeReference)new TypeReference<CredentialRegistration>(){});
            })).collect(Collectors.toList());
        }
        catch (SyncopeClientException e) {
            if (e.getType() == ClientExceptionType.NotFound) {
                LOG.info("Could not locate account for {}", (Object)username);
            } else {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return List.of();
    }
}

