/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.cache.interceptor.flush;

import java.util.Iterator;
import java.util.Map;
import org.springframework.util.StringUtils;
import org.springmodules.cache.FatalCacheException;
import org.springmodules.cache.FlushingModel;
import org.springmodules.cache.interceptor.flush.AbstractModelSourceFlushingInterceptor;
import org.springmodules.cache.interceptor.flush.MethodMapFlushingModelSource;

public final class MethodMapFlushingInterceptor
extends AbstractModelSourceFlushingInterceptor {
    protected void onAfterPropertiesSet() throws FatalCacheException {
        Map flushingModels = this.getFlushingModels();
        if (flushingModels != null && !flushingModels.isEmpty() && this.getFlushingModelSource() == null) {
            MethodMapFlushingModelSource newSource = new MethodMapFlushingModelSource();
            String key = null;
            try {
                Iterator i = flushingModels.keySet().iterator();
                while (i.hasNext()) {
                    key = (String)i.next();
                    FlushingModel model = (FlushingModel)flushingModels.get(key);
                    newSource.addModel(model, key);
                }
            }
            catch (Exception exception) {
                throw new FatalCacheException("Unable to add model stored under the key " + StringUtils.quote((String)key), exception);
            }
            this.setFlushingModelSource(newSource);
        }
    }
}

