/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.extensions.markup.html.bootstrap.form.typeahead;

import de.agilecoders.wicket.jquery.AbstractConfig;
import de.agilecoders.wicket.jquery.IKey;
import de.agilecoders.wicket.jquery.util.Json;
import java.util.Locale;
import org.apache.wicket.util.lang.Args;

public class Remote
extends AbstractConfig {
    protected static final IKey<CharSequence> Url = Remote.newKey((String)"url", null);
    protected static final IKey<String> Wildcard = Remote.newKey((String)"wildcard", (Object)"%QUERY");
    protected static final IKey<String> RateLimit = Remote.newKey((String)"rateLimitFn", (Object)"debounce");
    protected static final IKey<Json.RawValue> Filter = Remote.newKey((String)"filter", null);
    protected static final IKey<Json.RawValue> BeforeSend = Remote.newKey((String)"beforeSend", null);
    protected static final IKey<Integer> MaxParallelRequests = Remote.newKey((String)"maxParallelRequests", (Object)6);
    protected static final IKey<Json.RawValue> Replace = Remote.newKey((String)"replace", null);

    public Remote withUrl(CharSequence url) {
        Args.notEmpty((CharSequence)url, (String)"url");
        this.put(Url, url + "&term=" + (String)this.get(Wildcard));
        return this;
    }

    public Remote withWildcard(String wildcard) {
        Args.notEmpty((CharSequence)wildcard, (String)"wildcard");
        this.put(Wildcard, wildcard);
        return this;
    }

    public Remote withRateLimit(RateLimit rateLimit) {
        Args.notNull((Object)((Object)rateLimit), (String)"rateLimit");
        this.put(RateLimit, rateLimit.name().toLowerCase(Locale.ENGLISH));
        return this;
    }

    public Remote withFilter(Json.RawValue filter) {
        Args.notNull((Object)filter, (String)"filter");
        this.put(Filter, filter);
        return this;
    }

    public Remote withBeforeSend(Json.RawValue beforeSend) {
        Args.notNull((Object)beforeSend, (String)"beforeSend");
        this.put(BeforeSend, beforeSend);
        return this;
    }

    public Remote withMaxParallelRequests(int maxParallelRequests) {
        this.put(MaxParallelRequests, maxParallelRequests);
        return this;
    }

    public Remote withReplace(Json.RawValue replace) {
        Args.notNull((Object)replace, (String)"replace");
        this.put(Replace, replace);
        return this;
    }

    public static enum RateLimit {
        THROTTLE,
        DEBOUNCE;

    }
}

