/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.common.logging.slf4j;

import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.logging.LogSpi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.spi.LocationAwareLogger;

public class SLF4JLog
implements LogSpi {
    private static final String CLASS = "Class: ";
    private static final String METHOD = "Method: ";
    private static final String MESSAGE = "Message: ";

    public void log(Class<?> clazz, String methodName, Log.Level level, String message, Throwable ex) {
        String clazzName = clazz.getName();
        Logger logger = LoggerFactory.getLogger((String)clazzName);
        if (logger instanceof LocationAwareLogger) {
            if (StringUtil.isBlank((String)methodName)) {
                ((LocationAwareLogger)logger).log(null, clazz.getName(), this.getLogLevel(level), message, null, ex);
            } else {
                StringBuilder sb = new StringBuilder(null == message ? "" : message).append('\t').append(METHOD).append(methodName);
                ((LocationAwareLogger)logger).log(null, clazz.getName(), this.getLogLevel(level), sb.toString(), null, ex);
            }
        } else {
            StringBuilder sb = new StringBuilder(CLASS).append(clazz).append('\t');
            if (StringUtil.isNotBlank((String)methodName)) {
                sb.append(methodName).append('\t');
            }
            sb.append(MESSAGE);
            if (null != message) {
                sb.append(message);
            }
            if (Log.Level.OK.equals((Object)level)) {
                if (ex == null) {
                    logger.debug(sb.toString());
                } else {
                    logger.debug(sb.toString(), ex);
                }
            } else if (Log.Level.INFO.equals((Object)level)) {
                if (ex == null) {
                    logger.info(sb.toString());
                } else {
                    logger.info(sb.toString(), ex);
                }
            } else if (Log.Level.WARN.equals((Object)level)) {
                if (ex == null) {
                    logger.warn(sb.toString());
                } else {
                    logger.warn(sb.toString(), ex);
                }
            } else if (Log.Level.ERROR.equals((Object)level)) {
                if (ex == null) {
                    logger.error(sb.toString());
                } else {
                    logger.error(sb.toString(), ex);
                }
            }
        }
    }

    public void log(Class<?> clazz, StackTraceElement method, Log.Level level, String message, Throwable ex) {
        this.log(clazz, null != method ? method.getMethodName() : null, level, message, ex);
    }

    public boolean isLoggable(Class<?> clazz, Log.Level level) {
        Logger logger = LoggerFactory.getLogger(clazz);
        boolean ret = true;
        if (Log.Level.OK.equals((Object)level)) {
            ret = logger.isDebugEnabled();
        } else if (Log.Level.INFO.equals((Object)level)) {
            ret = logger.isInfoEnabled();
        } else if (Log.Level.WARN.equals((Object)level)) {
            ret = logger.isWarnEnabled();
        } else if (Log.Level.ERROR.equals((Object)level)) {
            ret = logger.isErrorEnabled();
        }
        return ret;
    }

    public boolean needToInferCaller(Class<?> clazz, Log.Level level) {
        return LoggerFactory.getLogger(clazz).isDebugEnabled();
    }

    private int getLogLevel(Log.Level level) {
        int ret = 0;
        if (Log.Level.OK.equals((Object)level)) {
            ret = 10;
        } else if (Log.Level.INFO.equals((Object)level)) {
            ret = 20;
        } else if (Log.Level.WARN.equals((Object)level)) {
            ret = 30;
        } else if (Log.Level.ERROR.equals((Object)level)) {
            ret = 40;
        }
        return ret;
    }
}

