/*
 * Decompiled with CFR 0.152.
 */
package com.tc.bytes;

import com.tc.bytes.TCByteBuffer;
import com.tc.bytes.TCByteBufferFactory;
import com.tc.bytes.TCByteBufferImpl;
import com.tc.util.concurrent.SetOnceFlag;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.AbstractQueue;
import java.util.Collections;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;

public class TCDirectByteBufferCache
extends AbstractQueue<TCByteBuffer> {
    private final ReferenceQueue<TCByteBuffer> gcqueue = new ReferenceQueue();
    private final Set<Reference<? extends TCByteBuffer>> refs = ConcurrentHashMap.newKeySet();
    private final Queue<TCByteBuffer> parent;
    private final int size;
    private final Queue<TCByteBuffer> localpool;
    private final SetOnceFlag closed = new SetOnceFlag();

    public TCDirectByteBufferCache() {
        this(TCByteBufferFactory.getFixedBufferSize());
    }

    public TCDirectByteBufferCache(int size) {
        this(new NullQueue(), size, Integer.MAX_VALUE);
    }

    public TCDirectByteBufferCache(int size, int limit) {
        this(new NullQueue(), size, limit);
    }

    public TCDirectByteBufferCache(Queue<TCByteBuffer> parent) {
        this(parent, TCByteBufferFactory.getFixedBufferSize(), Integer.MAX_VALUE);
    }

    private TCDirectByteBufferCache(Queue<TCByteBuffer> parent, int size, int limit) {
        this.parent = parent;
        this.size = size;
        this.localpool = new LinkedBlockingQueue<TCByteBuffer>(limit);
    }

    private void processReferencePool() {
        Reference<TCByteBuffer> ref = this.gcqueue.poll();
        while (ref != null) {
            TCByteBuffer buf = ref.get();
            if (buf != null) {
                this.localpool.offer(buf.reInit());
            } else {
                this.refs.remove(ref);
            }
            ref = this.gcqueue.poll();
        }
    }

    @Override
    public Iterator<TCByteBuffer> iterator() {
        return this.localpool.iterator();
    }

    @Override
    public int size() {
        return this.localpool.size();
    }

    @Override
    public boolean offer(TCByteBuffer e) {
        if (e instanceof TCByteBufferImpl) {
            ((TCByteBufferImpl)e).verifyLocked();
        }
        return this.closed.isSet() || !this.localpool.offer(e) ? this.parent.offer(e) : true;
    }

    @Override
    public TCByteBuffer poll() {
        this.processReferencePool();
        if (this.closed.isSet()) {
            return null;
        }
        TCByteBuffer buffer = this.localpool.poll();
        if (buffer == null) {
            buffer = this.parent.poll();
            if (buffer == null) {
                buffer = new TCByteBufferImpl(this.size, true);
                this.refs.add(new SoftReference<TCByteBuffer>(buffer, this.gcqueue));
            }
        } else {
            buffer.unlock();
        }
        return buffer;
    }

    public int referenced() {
        return this.refs.size();
    }

    @Override
    public TCByteBuffer peek() {
        return this.localpool.peek();
    }

    @Override
    public void clear() {
        this.localpool.clear();
    }

    public void close() {
        if (this.closed.attemptSet()) {
            while (!this.localpool.isEmpty()) {
                this.parent.offer(this.localpool.remove());
            }
        }
    }

    private static class NullQueue
    extends AbstractQueue<TCByteBuffer> {
        private NullQueue() {
        }

        @Override
        public Iterator<TCByteBuffer> iterator() {
            return Collections.emptyIterator();
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean offer(TCByteBuffer e) {
            return false;
        }

        @Override
        public TCByteBuffer poll() {
            return null;
        }

        @Override
        public TCByteBuffer peek() {
            return null;
        }
    }
}

