/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.api.model;

import java.util.Objects;
import org.terracotta.dynamic_config.api.model.Setting;

public class FailoverPriority {
    static final String ERR_MSG = (Object)((Object)Setting.FAILOVER_PRIORITY) + " should be either 'availability', 'consistency', or 'consistency:N' (where 'N' is the voter count expressed as a non-negative integer)";
    private final Type type;
    private final int voters;

    protected FailoverPriority(Type type, Integer voters) {
        this.type = type;
        this.voters = voters;
    }

    public Type getType() {
        return this.type;
    }

    public int getVoters() {
        return this.voters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FailoverPriority)) {
            return false;
        }
        FailoverPriority that = (FailoverPriority)o;
        return this.getVoters() == that.getVoters() && this.getType() == that.getType();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getType(), this.getVoters()});
    }

    public String toString() {
        return this.type == Type.AVAILABILITY ? Type.AVAILABILITY.name().toLowerCase() : (this.voters == 0 ? Type.CONSISTENCY.name().toLowerCase() : Type.CONSISTENCY.name().toLowerCase() + ":" + this.voters);
    }

    public static FailoverPriority availability() {
        return new FailoverPriority(Type.AVAILABILITY, 0);
    }

    public static FailoverPriority consistency() {
        return new FailoverPriority(Type.CONSISTENCY, 0);
    }

    public static FailoverPriority consistency(int voters) {
        if (voters < 0) {
            throw new IllegalArgumentException(ERR_MSG);
        }
        return new FailoverPriority(Type.CONSISTENCY, voters);
    }

    public static FailoverPriority valueOf(String str) {
        Objects.requireNonNull(str);
        if ("availability".equals(str)) {
            return FailoverPriority.availability();
        }
        if ("consistency".equals(str)) {
            return FailoverPriority.consistency();
        }
        if (str.startsWith("consistency:")) {
            try {
                return FailoverPriority.consistency(Integer.parseInt(str.substring(12)));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(ERR_MSG);
            }
        }
        throw new IllegalArgumentException(ERR_MSG);
    }

    public static enum Type {
        AVAILABILITY,
        CONSISTENCY;

    }
}

