/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.bucket4j.consumer;

import io.github.bucket4j.AbstractBucket;
import io.github.bucket4j.BlockingStrategy;
import io.github.bucket4j.ConsumptionProbe;
import java.util.LinkedHashMap;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apereo.cas.bucket4j.consumer.BucketConsumer;
import org.apereo.cas.bucket4j.consumer.BucketConsumptionResult;
import org.apereo.cas.bucket4j.producer.BucketStore;
import org.apereo.cas.configuration.model.support.bucket4j.BaseBucket4jProperties;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBucketConsumer
implements BucketConsumer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultBucketConsumer.class);
    @Generated
    private final Object $lock = new Object[0];
    private final BucketStore bucketStore;
    private final BaseBucket4jProperties properties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BucketConsumptionResult consume(String key) {
        Object object = this.$lock;
        synchronized (object) {
            AbstractBucket bucket = this.bucketStore.obtainBucket(key);
            if (bucket == null) {
                LOGGER.warn("Unable to obtain a bucket for [{}]", (Object)key);
                return ((BucketConsumptionResult.BucketConsumptionResultBuilder)BucketConsumptionResult.builder().consumed(false)).build();
            }
            Boolean canProceed = (Boolean)FunctionUtils.doAndHandle(() -> {
                if (this.properties.isBlocking()) {
                    LOGGER.trace("Attempting to consume a token for the authentication attempt");
                    return bucket.tryConsume(1L, MAX_WAIT_NANOS, BlockingStrategy.PARKING);
                }
                return bucket.tryConsume(1L);
            }, e -> {
                LoggingUtils.error((Logger)LOGGER, (Throwable)e);
                Thread.currentThread().interrupt();
                return false;
            }).get();
            LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
            long availableTokens = bucket.getAvailableTokens();
            if (!canProceed.booleanValue()) {
                ConsumptionProbe probe = bucket.tryConsumeAndReturnRemaining(1L);
                long seconds = TimeUnit.NANOSECONDS.toSeconds(probe.getNanosToWaitForRefill());
                headers.put("X-Rate-Limit-Retry-After-Seconds", Long.toString(seconds));
                LOGGER.warn("The request is throttled as capacity is entirely consumed. Available tokens are [{}]", (Object)availableTokens);
                return ((BucketConsumptionResult.BucketConsumptionResultBuilder)((BucketConsumptionResult.BucketConsumptionResultBuilder)BucketConsumptionResult.builder().consumed(false)).headers(headers)).build();
            }
            headers.put("X-Rate-Limit-Remaining", Long.toString(availableTokens));
            return ((BucketConsumptionResult.BucketConsumptionResultBuilder)((BucketConsumptionResult.BucketConsumptionResultBuilder)BucketConsumptionResult.builder().consumed(true)).headers(headers)).build();
        }
    }

    @Generated
    public DefaultBucketConsumer(BucketStore bucketStore, BaseBucket4jProperties properties) {
        this.bucketStore = bucketStore;
        this.properties = properties;
    }
}

