/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.cxf.service;

import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.command.CommandOutput;
import org.apache.syncope.common.lib.command.CommandTO;
import org.apache.syncope.common.lib.to.PagedResult;
import org.apache.syncope.common.rest.api.beans.CommandQuery;
import org.apache.syncope.common.rest.api.service.CommandService;
import org.apache.syncope.core.logic.CommandLogic;
import org.apache.syncope.core.rest.cxf.service.AbstractService;
import org.springframework.stereotype.Service;

@Service
public class CommandServiceImpl
extends AbstractService
implements CommandService {
    protected final CommandLogic logic;

    public CommandServiceImpl(CommandLogic logic) {
        this.logic = logic;
    }

    public PagedResult<CommandTO> search(CommandQuery query) {
        String keyword = query.getKeyword() == null ? null : query.getKeyword().replace('*', '%');
        Pair result = this.logic.search(query.getPage().intValue(), query.getSize().intValue(), keyword);
        return this.buildPagedResult((List)result.getRight(), query.getPage(), query.getSize(), (Integer)result.getLeft());
    }

    public CommandTO read(String key) {
        return this.logic.read(key);
    }

    public CommandOutput run(CommandTO command) {
        return new CommandOutput.Builder(command).output(this.logic.run(command)).build();
    }
}

