/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.rest;

import java.net.URI;
import java.util.Optional;
import javax.ws.rs.core.MediaType;
import org.apache.cxf.jaxrs.client.Client;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.lib.SyncopeClient;
import org.apache.syncope.client.ui.commons.rest.RestClient;
import org.apache.syncope.common.lib.search.OrderByClauseBuilder;
import org.apache.syncope.common.lib.types.ExecStatus;
import org.apache.syncope.common.rest.api.service.JAXRSService;
import org.apache.syncope.common.rest.api.service.SyncopeService;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseRestClient
implements RestClient {
    private static final long serialVersionUID = 1523999867826481989L;
    protected static final Logger LOG = LoggerFactory.getLogger(BaseRestClient.class);

    public static String toOrderBy(SortParam<String> sort) {
        OrderByClauseBuilder builder = SyncopeClient.getOrderByClauseBuilder();
        String property = (String)sort.getProperty();
        if (property.indexOf(35) != -1) {
            property = property.substring(property.indexOf(35) + 1);
        }
        if (sort.isAscending()) {
            builder.asc(property);
        } else {
            builder.desc(property);
        }
        return builder.build();
    }

    public SyncopeService getSyncopeService() {
        return this.getService(SyncopeService.class);
    }

    protected <T> T getService(Class<T> serviceClass) {
        return SyncopeConsoleSession.get().getService(serviceClass);
    }

    protected <T> T getService(String etag, Class<T> serviceClass) {
        return SyncopeConsoleSession.get().getService(etag, serviceClass);
    }

    protected <T> void resetClient(Class<T> serviceClass) {
        SyncopeConsoleSession.get().resetClient(serviceClass);
    }

    protected <E extends JAXRSService, T> T getObject(E service, URI location, Class<T> resultClass) {
        WebClient webClient = WebClient.fromClient((Client)WebClient.client(service));
        webClient.accept(new MediaType[]{SyncopeConsoleSession.get().getMediaType()}).to(location.toASCIIString(), false);
        return (T)webClient.header("X-Syncope-Domain", new Object[]{SyncopeConsoleSession.get().getDomain()}).header("Authorization", new Object[]{"Bearer " + SyncopeConsoleSession.get().getJWT()}).get(resultClass);
    }

    protected String getStatus(int httpStatus) {
        ExecStatus execStatus = ExecStatus.fromHttpStatus((int)httpStatus);
        return Optional.ofNullable(execStatus).map(Enum::name).orElse("UNKNOWN");
    }
}

