/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.trusted.config;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Expiry;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.time.Duration;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import lombok.Generated;
import org.apereo.cas.audit.AuditTrailRecordResolutionPlanConfigurer;
import org.apereo.cas.authentication.PseudoPlatformTransactionManager;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.core.util.EncryptionJwtSigningJwtCryptographyProperties;
import org.apereo.cas.configuration.model.support.mfa.trusteddevice.TrustedDevicesMultifactorCoreProperties;
import org.apereo.cas.configuration.model.support.mfa.trusteddevice.TrustedDevicesMultifactorProperties;
import org.apereo.cas.trusted.authentication.MultifactorAuthenticationTrustCipherExecutor;
import org.apereo.cas.trusted.authentication.MultifactorAuthenticationTrustedDeviceNamingStrategy;
import org.apereo.cas.trusted.authentication.api.MultifactorAuthenticationTrustRecord;
import org.apereo.cas.trusted.authentication.api.MultifactorAuthenticationTrustRecordKeyGenerator;
import org.apereo.cas.trusted.authentication.api.MultifactorAuthenticationTrustStorage;
import org.apereo.cas.trusted.authentication.keys.DefaultMultifactorAuthenticationTrustRecordKeyGenerator;
import org.apereo.cas.trusted.authentication.keys.LegacyMultifactorAuthenticationTrustRecordKeyGenerator;
import org.apereo.cas.trusted.authentication.storage.InMemoryMultifactorAuthenticationTrustStorage;
import org.apereo.cas.trusted.authentication.storage.JsonMultifactorAuthenticationTrustStorage;
import org.apereo.cas.trusted.authentication.storage.MultifactorAuthenticationTrustStorageCleaner;
import org.apereo.cas.trusted.web.MultifactorAuthenticationTrustReportEndpoint;
import org.apereo.cas.util.DateTimeUtils;
import org.apereo.cas.util.cipher.CipherExecutorUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.util.spring.boot.ConditionalOnMatchingHostname;
import org.apereo.inspektr.audit.spi.AuditActionResolver;
import org.apereo.inspektr.audit.spi.AuditResourceResolver;
import org.apereo.inspektr.common.Cleanable;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.PropertyResolver;
import org.springframework.transaction.PlatformTransactionManager;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature=CasFeatureModule.FeatureCatalog.MultifactorAuthenticationTrustedDevices)
@AutoConfiguration
public class MultifactorAuthnTrustConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(MultifactorAuthnTrustConfiguration.class);
    private static final int INITIAL_CACHE_SIZE = 50;
    private static final long MAX_CACHE_SIZE = 1000000L;

    private static class MultifactorAuthenticationTrustRecordExpiry
    implements Expiry<String, MultifactorAuthenticationTrustRecord> {
        @Generated
        private static final Logger LOGGER = LoggerFactory.getLogger(MultifactorAuthenticationTrustRecordExpiry.class);

        private MultifactorAuthenticationTrustRecordExpiry() {
        }

        public long expireAfterCreate(@NonNull String key, @NonNull MultifactorAuthenticationTrustRecord value, long currentTime) {
            if (value.getExpirationDate() == null) {
                LOGGER.trace("Multifactor trust record [{}] will never expire", (Object)value);
                return Long.MAX_VALUE;
            }
            if (value.isExpired()) {
                LOGGER.trace("Multifactor trust record [{}] is expired", (Object)value);
                return 0L;
            }
            try {
                ZonedDateTime now = ZonedDateTime.now(ZoneOffset.UTC).truncatedTo(ChronoUnit.SECONDS);
                ZonedDateTime zonedExp = DateTimeUtils.zonedDateTimeOf((Date)value.getExpirationDate()).truncatedTo(ChronoUnit.SECONDS);
                long nanos = Duration.between(now, zonedExp).toNanos();
                LOGGER.trace("Multifactor trust record [{}] expires in [{}] nanoseconds", (Object)value, (Object)nanos);
                return nanos;
            }
            catch (Exception e) {
                LOGGER.trace(e.getMessage(), (Throwable)e);
                LOGGER.debug("Multifactor trust record [{}] will never expire", (Object)value);
                return Long.MAX_VALUE;
            }
        }

        public long expireAfterUpdate(@NonNull String key, @NonNull MultifactorAuthenticationTrustRecord value, long currentTime, @NonNegative long currentDuration) {
            return this.expireAfterCreate(key, value, currentTime);
        }

        public long expireAfterRead(@NonNull String key, @NonNull MultifactorAuthenticationTrustRecord value, long currentTime, @NonNegative long currentDuration) {
            return this.expireAfterCreate(key, value, currentTime);
        }
    }

    @Configuration(value="MultifactorAuthnTrustWebConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class MultifactorAuthnTrustWebConfiguration {
        @Bean
        @ConditionalOnAvailableEndpoint
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public MultifactorAuthenticationTrustReportEndpoint mfaTrustedDevicesReportEndpoint(CasConfigurationProperties casProperties, @Qualifier(value="mfaTrustEngine") ObjectProvider<MultifactorAuthenticationTrustStorage> mfaTrustEngine) {
            return new MultifactorAuthenticationTrustReportEndpoint(casProperties, mfaTrustEngine);
        }
    }

    @Configuration(value="MultifactorAuthnTrustAuditConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class MultifactorAuthnTrustAuditConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditTrailRecordResolutionPlanConfigurer casMfaTrustAuditTrailRecordResolutionPlanConfigurer(@Qualifier(value="ticketCreationActionResolver") AuditActionResolver ticketCreationActionResolver, @Qualifier(value="returnValueResourceResolver") AuditResourceResolver returnValueResourceResolver) {
            return plan -> {
                plan.registerAuditResourceResolver("TRUSTED_AUTHENTICATION_RESOURCE_RESOLVER", returnValueResourceResolver);
                plan.registerAuditActionResolver("TRUSTED_AUTHENTICATION_ACTION_RESOLVER", ticketCreationActionResolver);
            };
        }
    }

    @Configuration(value="MultifactorAuthnTrustSchedulerConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class MultifactorAuthnTrustSchedulerConfiguration {
        @ConditionalOnMatchingHostname(name="cas.authn.mfa.trusted.cleaner.schedule.enabled-on-host")
        @ConditionalOnMissingBean(name={"mfaTrustStorageCleaner"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Cleanable mfaTrustStorageCleaner(ConfigurableApplicationContext applicationContext, @Qualifier(value="mfaTrustEngine") MultifactorAuthenticationTrustStorage mfaTrustEngine) {
            return (Cleanable)BeanSupplier.of(Cleanable.class).when(BeanCondition.on((String)"cas.authn.mfa.trusted.cleaner.schedule.enabled").isTrue().evenIfMissing().given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> new MultifactorAuthenticationTrustStorageCleaner(mfaTrustEngine)).otherwiseProxy().get();
        }
    }

    @Configuration(value="MultifactorAuthnTrustCryptoConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class MultifactorAuthnTrustCryptoConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"mfaTrustCipherExecutor"})
        public CipherExecutor mfaTrustCipherExecutor(CasConfigurationProperties casProperties) {
            EncryptionJwtSigningJwtCryptographyProperties crypto = casProperties.getAuthn().getMfa().getTrusted().getCrypto();
            if (crypto.isEnabled()) {
                return CipherExecutorUtils.newStringCipherExecutor((EncryptionJwtSigningJwtCryptographyProperties)crypto, MultifactorAuthenticationTrustCipherExecutor.class);
            }
            LOGGER.info("Multifactor trusted authentication record encryption/signing is turned off and MAY NOT be safe in a production environment. Consider using other choices to handle encryption, signing and verification of trusted authentication records for MFA");
            return CipherExecutor.noOp();
        }
    }

    @Configuration(value="MultifactorAuthnTrustCoreConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class MultifactorAuthnTrustCoreConfiguration {
        @ConditionalOnMissingBean(name={"mfaTrustDeviceNamingStrategy"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public MultifactorAuthenticationTrustedDeviceNamingStrategy mfaTrustDeviceNamingStrategy() {
            return MultifactorAuthenticationTrustedDeviceNamingStrategy.random();
        }

        @ConditionalOnMissingBean(name={"mfaTrustEngine"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public MultifactorAuthenticationTrustStorage mfaTrustEngine(CasConfigurationProperties casProperties, @Qualifier(value="mfaTrustCipherExecutor") CipherExecutor mfaTrustCipherExecutor, @Qualifier(value="mfaTrustRecordKeyGenerator") MultifactorAuthenticationTrustRecordKeyGenerator mfaTrustRecordKeyGenerator) {
            TrustedDevicesMultifactorProperties trusted = casProperties.getAuthn().getMfa().getTrusted();
            LoadingCache storage = Caffeine.newBuilder().initialCapacity(50).maximumSize(1000000L).expireAfter((Expiry)new MultifactorAuthenticationTrustRecordExpiry()).build(s -> {
                LOGGER.error("Load operation of the cache is not supported.");
                return null;
            });
            return (MultifactorAuthenticationTrustStorage)FunctionUtils.doIf((trusted.getJson().getLocation() != null ? 1 : 0) != 0, () -> {
                LOGGER.debug("Storing trusted device records inside the JSON resource [{}]", (Object)trusted.getJson().getLocation());
                return new JsonMultifactorAuthenticationTrustStorage(casProperties.getAuthn().getMfa().getTrusted(), mfaTrustCipherExecutor, trusted.getJson().getLocation(), mfaTrustRecordKeyGenerator);
            }, () -> {
                LOGGER.warn("Storing trusted device records in runtime memory. Changes and records will be lost upon CAS restarts");
                return new InMemoryMultifactorAuthenticationTrustStorage(casProperties.getAuthn().getMfa().getTrusted(), mfaTrustCipherExecutor, storage, mfaTrustRecordKeyGenerator);
            }).get();
        }

        @ConditionalOnMissingBean(name={"transactionManagerMfaAuthnTrust"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public PlatformTransactionManager transactionManagerMfaAuthnTrust() {
            return new PseudoPlatformTransactionManager();
        }
    }

    @Configuration(value="MultifactorAuthnTrustGeneratorConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class MultifactorAuthnTrustGeneratorConfiguration {
        @ConditionalOnMissingBean(name={"mfaTrustRecordKeyGenerator"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public MultifactorAuthenticationTrustRecordKeyGenerator mfaTrustRecordKeyGenerator(CasConfigurationProperties casProperties) {
            TrustedDevicesMultifactorCoreProperties.TrustedDevicesKeyGeneratorTypes type = casProperties.getAuthn().getMfa().getTrusted().getCore().getKeyGeneratorType();
            if (type == TrustedDevicesMultifactorCoreProperties.TrustedDevicesKeyGeneratorTypes.DEFAULT) {
                return new DefaultMultifactorAuthenticationTrustRecordKeyGenerator();
            }
            return new LegacyMultifactorAuthenticationTrustRecordKeyGenerator();
        }
    }
}

