/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.spring;

import org.flowable.common.engine.impl.cfg.TransactionContext;
import org.flowable.common.engine.impl.cfg.TransactionListener;
import org.flowable.common.engine.impl.cfg.TransactionState;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.springframework.core.Ordered;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class SpringTransactionContext
implements TransactionContext {
    protected PlatformTransactionManager transactionManager;
    protected CommandContext commandContext;
    protected Integer transactionSynchronizationAdapterOrder;

    public SpringTransactionContext(PlatformTransactionManager transactionManager, CommandContext commandContext) {
        this(transactionManager, commandContext, null);
    }

    public SpringTransactionContext(PlatformTransactionManager transactionManager, CommandContext commandContext, Integer transactionSynchronizationAdapterOrder) {
        this.transactionManager = transactionManager;
        this.commandContext = commandContext;
        this.transactionSynchronizationAdapterOrder = transactionSynchronizationAdapterOrder != null ? transactionSynchronizationAdapterOrder : Integer.valueOf(Integer.MAX_VALUE);
    }

    public void commit() {
    }

    public void rollback() {
        this.transactionManager.getTransaction(null).setRollbackOnly();
    }

    public void addTransactionListener(TransactionState transactionState, final TransactionListener transactionListener) {
        if (transactionState == TransactionState.COMMITTING) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

                @Override
                public void beforeCommit(boolean readOnly) {
                    transactionListener.execute(SpringTransactionContext.this.commandContext);
                }
            });
        } else if (transactionState == TransactionState.COMMITTED) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

                @Override
                public void afterCommit() {
                    transactionListener.execute(SpringTransactionContext.this.commandContext);
                }
            });
        } else if (transactionState == TransactionState.ROLLINGBACK) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

                @Override
                public void beforeCompletion() {
                    transactionListener.execute(SpringTransactionContext.this.commandContext);
                }
            });
        } else if (transactionState == TransactionState.ROLLED_BACK) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

                @Override
                public void afterCompletion(int status) {
                    if (1 == status) {
                        transactionListener.execute(SpringTransactionContext.this.commandContext);
                    }
                }
            });
        }
    }

    protected abstract class TransactionSynchronizationAdapter
    implements TransactionSynchronization,
    Ordered {
        protected TransactionSynchronizationAdapter() {
        }

        public void suspend() {
        }

        public void resume() {
        }

        public void flush() {
        }

        public void beforeCommit(boolean readOnly) {
        }

        public void beforeCompletion() {
        }

        public void afterCommit() {
        }

        public void afterCompletion(int status) {
        }

        public int getOrder() {
            return SpringTransactionContext.this.transactionSynchronizationAdapterOrder;
        }
    }
}

