/*
 * Decompiled with CFR 0.152.
 */
package com.github.difflib.unifieddiff;

import com.github.difflib.patch.AbstractDelta;
import com.github.difflib.unifieddiff.UnifiedDiff;
import com.github.difflib.unifieddiff.UnifiedDiffFile;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UnifiedDiffWriter {
    private static final Logger LOG = Logger.getLogger(UnifiedDiffWriter.class.getName());

    public static void write(UnifiedDiff diff, Function<String, List<String>> originalLinesProvider, Writer writer, int contextSize) throws IOException {
        Objects.requireNonNull(originalLinesProvider, "original lines provider needs to be specified");
        UnifiedDiffWriter.write(diff, originalLinesProvider, (String line) -> {
            try {
                writer.append((CharSequence)line).append("\n");
            }
            catch (IOException ex) {
                LOG.log(Level.SEVERE, null, ex);
            }
        }, contextSize);
    }

    public static void write(UnifiedDiff diff, Function<String, List<String>> originalLinesProvider, Consumer<String> writer, int contextSize) throws IOException {
        if (diff.getHeader() != null) {
            writer.accept(diff.getHeader());
        }
        for (UnifiedDiffFile file : diff.getFiles()) {
            ArrayList<AbstractDelta<String>> patchDeltas = new ArrayList<AbstractDelta<String>>(file.getPatch().getDeltas());
            if (patchDeltas.isEmpty()) continue;
            UnifiedDiffWriter.writeOrNothing(writer, file.getDiffCommand());
            if (file.getIndex() != null) {
                writer.accept("index " + file.getIndex());
            }
            writer.accept("--- " + (file.getFromFile() == null ? "/dev/null" : file.getFromFile()));
            if (file.getToFile() != null) {
                writer.accept("+++ " + file.getToFile());
            }
            List<String> originalLines = originalLinesProvider.apply(file.getFromFile());
            ArrayList<AbstractDelta<String>> deltas = new ArrayList<AbstractDelta<String>>();
            AbstractDelta delta = (AbstractDelta)patchDeltas.get(0);
            deltas.add(delta);
            if (patchDeltas.size() > 1) {
                for (int i2 = 1; i2 < patchDeltas.size(); ++i2) {
                    int position = delta.getSource().getPosition();
                    AbstractDelta nextDelta = (AbstractDelta)patchDeltas.get(i2);
                    if (position + delta.getSource().size() + contextSize >= nextDelta.getSource().getPosition() - contextSize) {
                        deltas.add(nextDelta);
                    } else {
                        UnifiedDiffWriter.processDeltas(writer, originalLines, deltas, contextSize, false);
                        deltas.clear();
                        deltas.add(nextDelta);
                    }
                    delta = nextDelta;
                }
            }
            UnifiedDiffWriter.processDeltas(writer, originalLines, deltas, contextSize, patchDeltas.size() == 1 && file.getFromFile() == null);
        }
        if (diff.getTail() != null) {
            writer.accept("--");
            writer.accept(diff.getTail());
        }
    }

    private static void processDeltas(Consumer<String> writer, List<String> origLines, List<AbstractDelta<String>> deltas, int contextSize, boolean newFile) {
        int line;
        int contextStart;
        int origStart;
        ArrayList<String> buffer = new ArrayList<String>();
        int origTotal = 0;
        int revTotal = 0;
        AbstractDelta<String> curDelta = deltas.get(0);
        if (newFile) {
            origStart = 0;
        } else {
            origStart = curDelta.getSource().getPosition() + 1 - contextSize;
            if (origStart < 1) {
                origStart = 1;
            }
        }
        int revStart = curDelta.getTarget().getPosition() + 1 - contextSize;
        if (revStart < 1) {
            revStart = 1;
        }
        if ((contextStart = curDelta.getSource().getPosition() - contextSize) < 0) {
            contextStart = 0;
        }
        for (line = contextStart; line < curDelta.getSource().getPosition() && line < origLines.size(); ++line) {
            buffer.add(" " + origLines.get(line));
            ++origTotal;
            ++revTotal;
        }
        UnifiedDiffWriter.getDeltaText(txt -> buffer.add((String)txt), curDelta);
        origTotal += curDelta.getSource().getLines().size();
        revTotal += curDelta.getTarget().getLines().size();
        for (int deltaIndex = 1; deltaIndex < deltas.size(); ++deltaIndex) {
            int intermediateStart;
            AbstractDelta<String> nextDelta = deltas.get(deltaIndex);
            for (line = intermediateStart = curDelta.getSource().getPosition() + curDelta.getSource().getLines().size(); line < nextDelta.getSource().getPosition() && line < origLines.size(); ++line) {
                buffer.add(" " + origLines.get(line));
                ++origTotal;
                ++revTotal;
            }
            UnifiedDiffWriter.getDeltaText(txt -> buffer.add((String)txt), nextDelta);
            origTotal += nextDelta.getSource().getLines().size();
            revTotal += nextDelta.getTarget().getLines().size();
            curDelta = nextDelta;
        }
        for (line = contextStart = curDelta.getSource().getPosition() + curDelta.getSource().getLines().size(); line < contextStart + contextSize && line < origLines.size(); ++line) {
            buffer.add(" " + origLines.get(line));
            ++origTotal;
            ++revTotal;
        }
        writer.accept("@@ -" + origStart + "," + origTotal + " +" + revStart + "," + revTotal + " @@");
        buffer.forEach(txt -> writer.accept((String)txt));
    }

    private static void getDeltaText(Consumer<String> writer, AbstractDelta<String> delta) {
        for (String line : delta.getSource().getLines()) {
            writer.accept("-" + line);
        }
        for (String line : delta.getTarget().getLines()) {
            writer.accept("+" + line);
        }
    }

    private static void writeOrNothing(Consumer<String> writer, String str) throws IOException {
        if (str != null) {
            writer.accept(str);
        }
    }
}

