/*
 * Decompiled with CFR 0.152.
 */
package org.grails.web.mapping;

import grails.config.Config;
import grails.core.GrailsApplication;
import grails.core.GrailsClass;
import grails.core.GrailsControllerClass;
import grails.core.GrailsUrlMappingsClass;
import grails.core.events.ArtefactAdditionEvent;
import grails.core.support.GrailsApplicationAware;
import grails.web.UrlConverter;
import grails.web.mapping.UrlMapping;
import grails.web.mapping.UrlMappings;
import groovy.lang.Script;
import java.util.ArrayList;
import java.util.List;
import org.grails.web.mapping.DefaultUrlMappingEvaluator;
import org.grails.web.mapping.DefaultUrlMappings;
import org.grails.web.mapping.DefaultUrlMappingsHolder;
import org.grails.web.mapping.mvc.GrailsControllerUrlMappings;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class UrlMappingsHolderFactoryBean
implements FactoryBean<UrlMappings>,
InitializingBean,
ApplicationContextAware,
GrailsApplicationAware {
    private static final String URL_MAPPING_CACHE_MAX_SIZE = "grails.urlmapping.cache.maxsize";
    private static final String URL_CREATOR_CACHE_MAX_SIZE = "grails.urlcreator.cache.maxsize";
    private GrailsApplication grailsApplication;
    private UrlMappings urlMappingsHolder;
    private ApplicationContext applicationContext;

    @Override
    public UrlMappings getObject() throws Exception {
        return this.urlMappingsHolder;
    }

    @Override
    public Class<UrlMappings> getObjectType() {
        return UrlMappings.class;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        Integer urlCreatorCacheSize;
        Assert.state(this.applicationContext != null, "Property [applicationContext] must be set!");
        Assert.state(this.grailsApplication != null, "Property [grailsApplication] must be set!");
        ArrayList<UrlMapping> urlMappings2 = new ArrayList<UrlMapping>();
        ArrayList excludePatterns = new ArrayList();
        GrailsClass[] mappings = this.grailsApplication.getArtefacts("UrlMappings");
        DefaultUrlMappingEvaluator mappingEvaluator = new DefaultUrlMappingEvaluator(this.applicationContext);
        if (mappings.length == 0) {
            urlMappings2.addAll(mappingEvaluator.evaluateMappings(DefaultUrlMappings.getMappings()));
        } else {
            for (int i2 = 0; i2 < mappings.length; ++i2) {
                GrailsClass mapping = mappings[i2];
                GrailsUrlMappingsClass mappingClass = (GrailsUrlMappingsClass)mapping;
                List<UrlMapping> grailsClassMappings = Script.class.isAssignableFrom(mappingClass.getClazz()) ? mappingEvaluator.evaluateMappings(mappingClass.getClazz()) : mappingEvaluator.evaluateMappings(mappingClass.getMappingsClosure());
                if (StringUtils.hasLength(mapping.getPluginName())) {
                    for (UrlMapping grailsClassMapping : grailsClassMappings) {
                        grailsClassMapping.setPluginIndex(i2);
                    }
                }
                urlMappings2.addAll(grailsClassMappings);
                if (mappingClass.getExcludePatterns() == null) continue;
                excludePatterns.addAll(mappingClass.getExcludePatterns());
            }
        }
        DefaultUrlMappingsHolder defaultUrlMappingsHolder = new DefaultUrlMappingsHolder(urlMappings2, excludePatterns, true);
        Config config = this.grailsApplication.getConfig();
        Integer cacheSize = config.getProperty(URL_MAPPING_CACHE_MAX_SIZE, Integer.class, null);
        if (cacheSize != null) {
            defaultUrlMappingsHolder.setMaxWeightedCacheCapacity(cacheSize);
        }
        if ((urlCreatorCacheSize = (Integer)config.getProperty(URL_CREATOR_CACHE_MAX_SIZE, Integer.class, null)) != null) {
            defaultUrlMappingsHolder.setUrlCreatorMaxWeightedCacheCapacity(urlCreatorCacheSize);
        }
        defaultUrlMappingsHolder.initialize();
        UrlConverter urlConverter = this.applicationContext.containsBean("grailsUrlConverter") ? this.applicationContext.getBean("grailsUrlConverter", UrlConverter.class) : null;
        final GrailsControllerUrlMappings grailsControllerUrlMappings = new GrailsControllerUrlMappings(this.grailsApplication, defaultUrlMappingsHolder, urlConverter);
        ((ConfigurableApplicationContext)this.applicationContext).addApplicationListener(new ApplicationListener<ArtefactAdditionEvent>(){

            @Override
            public void onApplicationEvent(ArtefactAdditionEvent event) {
                GrailsClass artefact = event.getArtefact();
                if (artefact instanceof GrailsControllerClass) {
                    grailsControllerUrlMappings.registerController((GrailsControllerClass)artefact);
                }
            }
        });
        this.urlMappingsHolder = grailsControllerUrlMappings;
    }

    @Override
    public void setGrailsApplication(GrailsApplication grailsApplication) {
        this.grailsApplication = grailsApplication;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        this.setGrailsApplication(applicationContext.getBean("grailsApplication", GrailsApplication.class));
    }
}

