/*
 * Decompiled with CFR 0.152.
 */
package grails.plugins;

import grails.core.GrailsApplication;
import grails.core.support.ParentApplicationContextAware;
import grails.plugins.GrailsPlugin;
import grails.plugins.GrailsVersionUtils;
import grails.plugins.PluginFilter;
import grails.plugins.VersionComparator;
import grails.plugins.exceptions.PluginException;
import grails.util.Environment;
import grails.util.GrailsClassUtils;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClassRegistry;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.IOGroovyMethods;
import org.grails.core.exceptions.GrailsConfigurationException;
import org.grails.core.io.CachingPathMatchingResourcePatternResolver;
import org.grails.io.support.GrailsResourceUtils;
import org.grails.plugins.AbstractGrailsPluginManager;
import org.grails.plugins.BinaryGrailsPlugin;
import org.grails.plugins.BinaryGrailsPluginDescriptor;
import org.grails.plugins.CorePluginFinder;
import org.grails.plugins.DefaultGrailsPlugin;
import org.grails.plugins.IdentityPluginFilter;
import org.grails.plugins.PluginFilterRetriever;
import org.grails.spring.DefaultRuntimeSpringConfiguration;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.Assert;

public class DefaultGrailsPluginManager
extends AbstractGrailsPluginManager {
    protected static final Class<?>[] COMMON_CLASSES = new Class[]{Boolean.class, Byte.class, Character.class, Class.class, Double.class, Float.class, Integer.class, Long.class, Number.class, Short.class, String.class, BigInteger.class, BigDecimal.class, URL.class, URI.class};
    private static final Log LOG = LogFactory.getLog(DefaultGrailsPluginManager.class);
    private static final String GRAILS_VERSION = "grailsVersion";
    private static final String GRAILS_PLUGIN_SUFFIX = "GrailsPlugin";
    private List<GrailsPlugin> delayedLoadPlugins = new LinkedList<GrailsPlugin>();
    private ApplicationContext parentCtx;
    private PathMatchingResourcePatternResolver resolver;
    private Map<GrailsPlugin, String[]> delayedEvictions = new HashMap<GrailsPlugin, String[]>();
    private Map<String, Set<GrailsPlugin>> pluginToObserverMap = new HashMap<String, Set<GrailsPlugin>>();
    private PluginFilter pluginFilter;
    private List<GrailsPlugin> userPlugins = new ArrayList<GrailsPlugin>();

    public DefaultGrailsPluginManager(String resourcePath, GrailsApplication application2) {
        super(application2);
        Assert.notNull((Object)application2, "Argument [application] cannot be null!");
        this.resolver = CachingPathMatchingResourcePatternResolver.INSTANCE;
        try {
            this.pluginResources = this.resolver.getResources(resourcePath);
        }
        catch (IOException ioe) {
            LOG.debug("Unable to load plugins for resource path " + resourcePath, ioe);
        }
        this.application = application2;
        this.setPluginFilter();
    }

    public DefaultGrailsPluginManager(String[] pluginResources, GrailsApplication application2) {
        super(application2);
        this.resolver = CachingPathMatchingResourcePatternResolver.INSTANCE;
        ArrayList<Resource> resourceList = new ArrayList<Resource>();
        for (String resourcePath : pluginResources) {
            try {
                resourceList.addAll(Arrays.asList(this.resolver.getResources(resourcePath)));
            }
            catch (IOException ioe) {
                LOG.debug("Unable to load plugins for resource path " + resourcePath, ioe);
            }
        }
        this.pluginResources = resourceList.toArray(new Resource[resourceList.size()]);
        this.application = application2;
        this.setPluginFilter();
    }

    public DefaultGrailsPluginManager(Class<?>[] plugins, GrailsApplication application2) {
        super(application2);
        this.pluginClasses = plugins;
        this.resolver = CachingPathMatchingResourcePatternResolver.INSTANCE;
        this.application = application2;
        this.setPluginFilter();
    }

    public DefaultGrailsPluginManager(Resource[] pluginFiles, GrailsApplication application2) {
        super(application2);
        this.resolver = CachingPathMatchingResourcePatternResolver.INSTANCE;
        this.pluginResources = pluginFiles;
        this.application = application2;
        this.setPluginFilter();
    }

    public DefaultGrailsPluginManager(GrailsApplication application2) {
        super(application2);
    }

    @Override
    public GrailsPlugin[] getUserPlugins() {
        return this.userPlugins.toArray(new GrailsPlugin[this.userPlugins.size()]);
    }

    private void setPluginFilter() {
        this.pluginFilter = new PluginFilterRetriever().getPluginFilter(this.application.getConfig());
    }

    @Override
    public void refreshPlugin(String name) {
        if (this.hasGrailsPlugin(name)) {
            this.getGrailsPlugin(name).refresh();
        }
    }

    @Override
    public Collection<GrailsPlugin> getPluginObservers(GrailsPlugin plugin2) {
        Assert.notNull((Object)plugin2, "Argument [plugin] cannot be null");
        Collection c = this.pluginToObserverMap.get(plugin2.getName());
        Collection wildcardObservers = this.pluginToObserverMap.get("*");
        if (wildcardObservers != null) {
            if (c != null) {
                c.addAll(wildcardObservers);
            } else {
                c = wildcardObservers;
            }
        }
        if (c != null) {
            c.remove(plugin2);
            return c;
        }
        return Collections.emptySet();
    }

    @Override
    public void informObservers(String pluginName, Map event) {
        GrailsPlugin plugin2 = this.getGrailsPlugin(pluginName);
        if (plugin2 == null) {
            return;
        }
        if (!plugin2.isEnabled(this.applicationContext.getEnvironment().getActiveProfiles())) {
            return;
        }
        for (GrailsPlugin observingPlugin : this.getPluginObservers(plugin2)) {
            if (!observingPlugin.isEnabled(this.applicationContext.getEnvironment().getActiveProfiles())) continue;
            observingPlugin.notifyOfEvent(event);
        }
    }

    @Override
    public void loadPlugins() throws PluginException {
        if (this.initialised) {
            return;
        }
        ClassLoader gcl = this.application.getClassLoader();
        this.attemptLoadPlugins(gcl);
        if (!this.delayedLoadPlugins.isEmpty()) {
            this.loadDelayedPlugins();
        }
        if (!this.delayedEvictions.isEmpty()) {
            this.processDelayedEvictions();
        }
        this.pluginList = this.sortPlugins(this.pluginList);
        this.initializePlugins();
        this.initialised = true;
    }

    protected List<GrailsPlugin> sortPlugins(List<GrailsPlugin> toSort) {
        ArrayList<GrailsPlugin> sortedPlugins = new ArrayList<GrailsPlugin>(toSort.size());
        HashSet<GrailsPlugin> visitedPlugins = new HashSet<GrailsPlugin>();
        Map<GrailsPlugin, List<GrailsPlugin>> loadOrderDependencies = this.resolveLoadDependencies(toSort);
        for (GrailsPlugin plugin2 : toSort) {
            this.visitTopologicalSort(plugin2, sortedPlugins, visitedPlugins, loadOrderDependencies);
        }
        return sortedPlugins;
    }

    protected Map<GrailsPlugin, List<GrailsPlugin>> resolveLoadDependencies(List<GrailsPlugin> plugins) {
        HashMap<GrailsPlugin, List<GrailsPlugin>> loadOrderDependencies = new HashMap<GrailsPlugin, List<GrailsPlugin>>();
        for (GrailsPlugin plugin2 : plugins) {
            if (plugin2.getLoadAfterNames() != null) {
                ArrayList<GrailsPlugin> loadDepsForPlugin = (ArrayList<GrailsPlugin>)loadOrderDependencies.get(plugin2);
                if (loadDepsForPlugin == null) {
                    loadDepsForPlugin = new ArrayList<GrailsPlugin>();
                    loadOrderDependencies.put(plugin2, loadDepsForPlugin);
                }
                String[] stringArray = plugin2.getLoadAfterNames();
                int n = stringArray.length;
                for (int j = 0; j < n; ++j) {
                    String pluginName = stringArray[j];
                    GrailsPlugin loadAfterPlugin = this.getGrailsPlugin(pluginName);
                    if (loadAfterPlugin == null) continue;
                    loadDepsForPlugin.add(loadAfterPlugin);
                }
            }
            for (String loadBefore : plugin2.getLoadBeforeNames()) {
                GrailsPlugin loadBeforePlugin = this.getGrailsPlugin(loadBefore);
                if (loadBeforePlugin == null) continue;
                ArrayList<GrailsPlugin> loadDepsForPlugin = (ArrayList<GrailsPlugin>)loadOrderDependencies.get(loadBeforePlugin);
                if (loadDepsForPlugin == null) {
                    loadDepsForPlugin = new ArrayList<GrailsPlugin>();
                    loadOrderDependencies.put(loadBeforePlugin, loadDepsForPlugin);
                }
                loadDepsForPlugin.add(plugin2);
            }
        }
        return loadOrderDependencies;
    }

    private void visitTopologicalSort(GrailsPlugin plugin2, List<GrailsPlugin> sortedPlugins, Set<GrailsPlugin> visitedPlugins, Map<GrailsPlugin, List<GrailsPlugin>> loadOrderDependencies) {
        if (plugin2 != null && !visitedPlugins.contains(plugin2)) {
            visitedPlugins.add(plugin2);
            List<GrailsPlugin> loadDepsForPlugin = loadOrderDependencies.get(plugin2);
            if (loadDepsForPlugin != null) {
                for (GrailsPlugin dependentPlugin : loadDepsForPlugin) {
                    this.visitTopologicalSort(dependentPlugin, sortedPlugins, visitedPlugins, loadOrderDependencies);
                }
            }
            sortedPlugins.add(plugin2);
        }
    }

    private void attemptLoadPlugins(ClassLoader gcl) {
        ArrayList grailsCorePlugins = this.loadCorePlugins ? this.findCorePlugins() : new ArrayList();
        List<GrailsPlugin> grailsUserPlugins = this.findUserPlugins(gcl);
        this.userPlugins = grailsUserPlugins;
        ArrayList<GrailsPlugin> allPlugins = new ArrayList<GrailsPlugin>(grailsCorePlugins);
        allPlugins.addAll(grailsUserPlugins);
        List<GrailsPlugin> filteredPlugins = this.getPluginFilter().filterPluginList(allPlugins);
        ArrayList<GrailsPlugin> orderedCorePlugins = new ArrayList<GrailsPlugin>();
        ArrayList<GrailsPlugin> orderedUserPlugins = new ArrayList<GrailsPlugin>();
        for (GrailsPlugin plugin2 : filteredPlugins) {
            if (grailsCorePlugins == null) continue;
            if (grailsCorePlugins.contains(plugin2)) {
                orderedCorePlugins.add(plugin2);
                continue;
            }
            orderedUserPlugins.add(plugin2);
        }
        ArrayList<GrailsPlugin> orderedPlugins = new ArrayList<GrailsPlugin>();
        orderedPlugins.addAll(orderedCorePlugins);
        orderedPlugins.addAll(orderedUserPlugins);
        for (GrailsPlugin plugin3 : orderedPlugins) {
            this.attemptPluginLoad(plugin3);
        }
    }

    private List<GrailsPlugin> findCorePlugins() {
        Class<?>[] corePluginClasses;
        CorePluginFinder finder = new CorePluginFinder(this.application);
        finder.setParentApplicationContext(this.parentCtx);
        ArrayList<GrailsPlugin> grailsCorePlugins = new ArrayList<GrailsPlugin>();
        for (Class<?> pluginClass : corePluginClasses = finder.getPluginClasses()) {
            if (pluginClass == null || Modifier.isAbstract(pluginClass.getModifiers()) || pluginClass == DefaultGrailsPlugin.class) continue;
            BinaryGrailsPluginDescriptor binaryDescriptor = finder.getBinaryDescriptor(pluginClass);
            GrailsPlugin plugin2 = binaryDescriptor != null ? this.createBinaryGrailsPlugin(pluginClass, binaryDescriptor) : this.createGrailsPlugin(pluginClass);
            plugin2.setApplicationContext(this.applicationContext);
            this.isCompatiblePlugin(plugin2);
            grailsCorePlugins.add(plugin2);
        }
        return grailsCorePlugins;
    }

    private String getPluginGrailsVersion(GrailsPlugin plugin2) {
        Object grailsVersionValue = GrailsClassUtils.getPropertyOrStaticPropertyOrFieldValue(plugin2.getInstance(), GRAILS_VERSION);
        return grailsVersionValue != null ? grailsVersionValue.toString() : null;
    }

    private boolean isCompatiblePlugin(GrailsPlugin plugin2) {
        String pluginGrailsVersion = this.getPluginGrailsVersion(plugin2);
        if (pluginGrailsVersion == null || pluginGrailsVersion.contains("@")) {
            LOG.debug("Plugin grails version is null or containing '@'. Compatibility check skipped.");
            return true;
        }
        String appGrailsVersion = this.application.getMetadata().getGrailsVersion();
        String pluginMinGrailsVersion = GrailsVersionUtils.getLowerVersion(pluginGrailsVersion);
        String pluginMaxGrailsVersion = GrailsVersionUtils.getUpperVersion(pluginGrailsVersion);
        if (appGrailsVersion == null) {
            return true;
        }
        if (pluginMinGrailsVersion == "*") {
            LOG.error("grailsVersion not formatted as expected, unable to determine compatibility.");
            return false;
        }
        VersionComparator comparator = new VersionComparator();
        if (pluginMinGrailsVersion.equals(pluginMaxGrailsVersion) && !appGrailsVersion.equals(pluginMinGrailsVersion)) {
            LOG.warn("Plugin [" + plugin2.getName() + ":" + plugin2.getVersion() + "] may not be compatible with this application as the application Grails version is not equal to the one that plugin requires. Plugin is compatible with Grails version " + pluginGrailsVersion + " but app is " + appGrailsVersion);
            return false;
        }
        if (!pluginMaxGrailsVersion.equals("*")) {
            if (comparator.compare(pluginMinGrailsVersion, appGrailsVersion) > 0) {
                LOG.warn("Plugin [" + plugin2.getName() + ":" + plugin2.getVersion() + "] may not be compatible with this application as the application Grails version is less than the plugin requires. Plugin is compatible with Grails version " + pluginGrailsVersion + " but app is " + appGrailsVersion);
                return false;
            }
        } else {
            if (comparator.compare(pluginMinGrailsVersion, appGrailsVersion) > 0) {
                LOG.warn("Plugin [" + plugin2.getName() + ":" + plugin2.getVersion() + "] may not be compatible with this application as the application Grails version is less than the plugin requires. Plugin is compatible with Grails version " + pluginGrailsVersion + " but app is " + appGrailsVersion);
                return false;
            }
            if (comparator.compare(pluginMaxGrailsVersion, appGrailsVersion) < 0) {
                LOG.warn("Plugin [" + plugin2.getName() + ":" + plugin2.getVersion() + "] may not be compatible with this application as the application Grails version is greater than the plugins max specified. Plugin is compatible with Grails versions " + pluginGrailsVersion + " but app is " + appGrailsVersion);
                return false;
            }
        }
        return true;
    }

    private GrailsPlugin createBinaryGrailsPlugin(Class<?> pluginClass, BinaryGrailsPluginDescriptor binaryDescriptor) {
        return new BinaryGrailsPlugin(pluginClass, binaryDescriptor, this.application);
    }

    protected GrailsPlugin createGrailsPlugin(Class<?> pluginClass) {
        return new DefaultGrailsPlugin(pluginClass, this.application);
    }

    protected GrailsPlugin createGrailsPlugin(Class<?> pluginClass, Resource resource) {
        return new DefaultGrailsPlugin(pluginClass, resource, this.application);
    }

    private List<GrailsPlugin> findUserPlugins(ClassLoader gcl) {
        ArrayList<GrailsPlugin> grailsUserPlugins = new ArrayList<GrailsPlugin>();
        LOG.info("Attempting to load [" + this.pluginResources.length + "] user defined plugins");
        for (Resource r : this.pluginResources) {
            Class<?> pluginClass = this.loadPluginClass(gcl, r);
            if (this.isGrailsPlugin(pluginClass)) {
                GrailsPlugin plugin2 = this.createGrailsPlugin(pluginClass, r);
                this.isCompatiblePlugin(plugin2);
                grailsUserPlugins.add(plugin2);
                continue;
            }
            LOG.warn("Class [" + String.valueOf(pluginClass) + "] not loaded as plug-in. Grails plug-ins must end with the convention 'GrailsPlugin'!");
        }
        for (Class pluginClass : this.pluginClasses) {
            if (this.isGrailsPlugin(pluginClass)) {
                GrailsPlugin plugin3 = this.createGrailsPlugin(pluginClass);
                this.isCompatiblePlugin(plugin3);
                grailsUserPlugins.add(plugin3);
                continue;
            }
            LOG.warn("Class [" + String.valueOf(pluginClass) + "] not loaded as plug-in. Grails plug-ins must end with the convention 'GrailsPlugin'!");
        }
        return grailsUserPlugins;
    }

    private boolean isGrailsPlugin(Class<?> pluginClass) {
        return pluginClass != null && pluginClass.getName().endsWith(GRAILS_PLUGIN_SUFFIX);
    }

    private void processDelayedEvictions() {
        for (Map.Entry<GrailsPlugin, String[]> entry : this.delayedEvictions.entrySet()) {
            GrailsPlugin plugin2 = entry.getKey();
            for (String pluginName : entry.getValue()) {
                this.evictPlugin(plugin2, pluginName);
            }
        }
    }

    private void initializePlugins() {
        for (Object plugin2 : this.plugins.values()) {
            if (!(plugin2 instanceof ApplicationContextAware)) continue;
            ((ApplicationContextAware)plugin2).setApplicationContext(this.applicationContext);
        }
    }

    private void loadDelayedPlugins() {
        while (!this.delayedLoadPlugins.isEmpty()) {
            GrailsPlugin plugin2 = this.delayedLoadPlugins.remove(0);
            if (this.areDependenciesResolved(plugin2)) {
                if (!this.hasValidPluginsToLoadBefore(plugin2)) {
                    this.registerPlugin(plugin2);
                    continue;
                }
                this.delayedLoadPlugins.add(plugin2);
                continue;
            }
            boolean foundInDelayed = false;
            for (GrailsPlugin remainingPlugin : this.delayedLoadPlugins) {
                if (!this.isDependentOn(plugin2, remainingPlugin)) continue;
                foundInDelayed = true;
                break;
            }
            if (foundInDelayed) {
                this.delayedLoadPlugins.add(plugin2);
                continue;
            }
            this.failedPlugins.put(plugin2.getName(), plugin2);
            LOG.error("ERROR: Plugin [" + plugin2.getName() + "] cannot be loaded because its dependencies [" + DefaultGroovyMethods.inspect(plugin2.getDependencyNames()) + "] cannot be resolved");
        }
    }

    private boolean hasValidPluginsToLoadBefore(GrailsPlugin plugin2) {
        String[] loadAfterNames = plugin2.getLoadAfterNames();
        Iterator<GrailsPlugin> iterator = this.delayedLoadPlugins.iterator();
        while (iterator.hasNext()) {
            GrailsPlugin delayedLoadPlugin;
            GrailsPlugin other = delayedLoadPlugin = iterator.next();
            for (String name : loadAfterNames) {
                if (!other.getName().equals(name)) continue;
                return this.hasDelayedDependencies(other) || this.areDependenciesResolved(other);
            }
        }
        return false;
    }

    private boolean hasDelayedDependencies(GrailsPlugin other) {
        String[] dependencyNames;
        for (String dependencyName : dependencyNames = other.getDependencyNames()) {
            for (GrailsPlugin grailsPlugin : this.delayedLoadPlugins) {
                if (!grailsPlugin.getName().equals(dependencyName)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isDependentOn(GrailsPlugin plugin2, GrailsPlugin dependency) {
        for (String name : plugin2.getDependencyNames()) {
            String requiredVersion = plugin2.getDependentVersion(name);
            if (!name.equals(dependency.getName()) || !GrailsVersionUtils.isValidVersion(dependency.getVersion(), requiredVersion)) continue;
            return true;
        }
        return false;
    }

    private boolean areDependenciesResolved(GrailsPlugin plugin2) {
        for (String name : plugin2.getDependencyNames()) {
            if (this.hasGrailsPlugin(name, plugin2.getDependentVersion(name))) continue;
            return false;
        }
        return true;
    }

    private boolean areNoneToLoadBefore(GrailsPlugin plugin2) {
        for (String name : plugin2.getLoadAfterNames()) {
            if (this.getGrailsPlugin(name) != null) continue;
            return false;
        }
        return true;
    }

    private Class<?> loadPluginClass(ClassLoader cl, Resource r) {
        Class<?> pluginClass;
        if (cl instanceof GroovyClassLoader) {
            try {
                if (LOG.isInfoEnabled()) {
                    LOG.info("Parsing & compiling " + r.getFilename());
                }
                pluginClass = ((GroovyClassLoader)cl).parseClass(IOGroovyMethods.getText(r.getInputStream(), "UTF-8"));
            }
            catch (CompilationFailedException e) {
                throw new PluginException("Error compiling plugin [" + r.getFilename() + "] " + e.getMessage(), e);
            }
            catch (IOException e) {
                throw new PluginException("Error reading plugin [" + r.getFilename() + "] " + e.getMessage(), e);
            }
        }
        String className = null;
        try {
            className = GrailsResourceUtils.getClassName(r.getFile().getAbsolutePath());
        }
        catch (IOException e) {
            throw new PluginException("Cannot find plugin class [" + className + "] resource: [" + r.getFilename() + "]", e);
        }
        try {
            pluginClass = Class.forName(className, true, cl);
        }
        catch (ClassNotFoundException e) {
            throw new PluginException("Cannot find plugin class [" + className + "] resource: [" + r.getFilename() + "]", e);
        }
        return pluginClass;
    }

    private void attemptPluginLoad(GrailsPlugin plugin2) {
        if (this.areDependenciesResolved(plugin2) && this.areNoneToLoadBefore(plugin2)) {
            this.registerPlugin(plugin2);
        } else {
            this.delayedLoadPlugins.add(plugin2);
        }
    }

    private void registerPlugin(GrailsPlugin plugin2) {
        String[] observedPlugins;
        if (!this.canRegisterPlugin(plugin2)) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Grails plugin " + String.valueOf(plugin2) + " is disabled and was not loaded");
            }
            return;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("Grails plug-in [" + plugin2.getName() + "] with version [" + plugin2.getVersion() + "] loaded successfully");
        }
        if (plugin2 instanceof ParentApplicationContextAware) {
            ((ParentApplicationContextAware)((Object)plugin2)).setParentApplicationContext(this.parentCtx);
        }
        plugin2.setManager(this);
        String[] evictionNames = plugin2.getEvictionNames();
        if (evictionNames.length > 0) {
            this.delayedEvictions.put(plugin2, evictionNames);
        }
        for (String observedPlugin : observedPlugins = plugin2.getObservedPluginNames()) {
            Set<GrailsPlugin> observers = this.pluginToObserverMap.get(observedPlugin);
            if (observers == null) {
                observers = new HashSet<GrailsPlugin>();
                this.pluginToObserverMap.put(observedPlugin, observers);
            }
            observers.add(plugin2);
        }
        this.pluginList.add(plugin2);
        this.plugins.put(plugin2.getName(), plugin2);
        this.classNameToPluginMap.put(plugin2.getPluginClass().getName(), plugin2);
    }

    protected boolean canRegisterPlugin(GrailsPlugin plugin2) {
        Environment environment2 = Environment.getCurrent();
        return plugin2.isEnabled() && plugin2.supportsEnvironment(environment2);
    }

    protected void evictPlugin(GrailsPlugin evictor, String evicteeName) {
        GrailsPlugin pluginToEvict = (GrailsPlugin)this.plugins.get(evicteeName);
        if (pluginToEvict != null) {
            this.pluginList.remove(pluginToEvict);
            this.plugins.remove(pluginToEvict.getName());
            if (LOG.isInfoEnabled()) {
                LOG.info("Grails plug-in " + String.valueOf(pluginToEvict) + " was evicted by " + String.valueOf(evictor));
            }
        }
    }

    private boolean hasGrailsPlugin(String name, String version) {
        return this.getGrailsPlugin(name, version) != null;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        for (GrailsPlugin plugin2 : this.pluginList) {
            plugin2.setApplicationContext(applicationContext);
        }
    }

    public void setParentApplicationContext(ApplicationContext parent) {
        this.parentCtx = parent;
    }

    public void reloadPlugin(GrailsPlugin plugin2) {
        plugin2.doArtefactConfiguration();
        DefaultRuntimeSpringConfiguration springConfig = new DefaultRuntimeSpringConfiguration(this.parentCtx);
        this.doRuntimeConfiguration(plugin2.getName(), springConfig);
        springConfig.registerBeansWithContext((GenericApplicationContext)this.applicationContext);
        plugin2.doWithApplicationContext(this.applicationContext);
        plugin2.doWithDynamicMethods(this.applicationContext);
    }

    @Override
    public void setApplication(GrailsApplication application2) {
        Assert.notNull((Object)application2, "Argument [application] cannot be null");
        this.application = application2;
        for (GrailsPlugin plugin2 : this.pluginList) {
            plugin2.setApplication(application2);
        }
    }

    @Override
    public void doDynamicMethods() {
        this.checkInitialised();
        MetaClassRegistry registry = GroovySystem.getMetaClassRegistry();
        for (Class<?> COMMON_CLASS : COMMON_CLASSES) {
            registry.removeMetaClass(COMMON_CLASS);
        }
        for (GrailsPlugin plugin2 : this.pluginList) {
            if (!plugin2.supportsCurrentScopeAndEnvironment()) continue;
            try {
                plugin2.doWithDynamicMethods(this.applicationContext);
            }
            catch (Throwable t) {
                throw new GrailsConfigurationException("Error configuring dynamic methods for plugin " + String.valueOf(plugin2) + ": " + t.getMessage(), t);
            }
        }
    }

    private PluginFilter getPluginFilter() {
        if (this.pluginFilter == null) {
            this.pluginFilter = new IdentityPluginFilter();
        }
        return this.pluginFilter;
    }

    @Override
    public void setPluginFilter(PluginFilter pluginFilter) {
        this.pluginFilter = pluginFilter;
    }

    List<GrailsPlugin> getPluginList() {
        return Collections.unmodifiableList(this.pluginList);
    }
}

