/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.qualifiers;

import io.micronaut.context.Qualifier;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.reflect.GenericTypeUtils;
import io.micronaut.core.type.TypeInformation;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.BeanType;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;

@Internal
public class TypeArgumentQualifier<T>
implements Qualifier<T> {
    private static final Logger LOG = ClassUtils.getLogger(TypeArgumentQualifier.class);
    private final Class[] typeArguments;

    TypeArgumentQualifier(Class ... typeArguments) {
        this.typeArguments = typeArguments;
    }

    @Override
    public <BT extends BeanType<T>> Stream<BT> reduce(Class<T> beanType, Stream<BT> candidates) {
        return candidates.filter(candidate -> beanType.isAssignableFrom(candidate.getBeanType())).filter(candidate -> {
            List<Class> typeArguments = this.getTypeArguments(beanType, candidate);
            boolean result = this.areTypesCompatible(typeArguments);
            if (LOG.isTraceEnabled() && !result) {
                LOG.trace("Bean type {} is not compatible with candidate generic types [{}] of candidate {}", beanType, CollectionUtils.toString(typeArguments), candidate);
            }
            return result;
        });
    }

    public Class[] getTypeArguments() {
        return this.typeArguments;
    }

    protected boolean areTypesCompatible(List<Class> classes) {
        Class[] typeArguments = this.typeArguments;
        return TypeArgumentQualifier.areTypesCompatible(typeArguments, classes);
    }

    protected <BT extends BeanType<T>> List<Class> getTypeArguments(Class<T> beanType, BT candidate) {
        if (candidate instanceof BeanDefinition) {
            BeanDefinition definition = (BeanDefinition)candidate;
            return definition.getTypeArguments(beanType).stream().map(TypeInformation::getType).collect(Collectors.toList());
        }
        if (beanType.isInterface()) {
            return Arrays.asList(GenericTypeUtils.resolveInterfaceTypeArguments(candidate.getBeanType(), beanType));
        }
        return Arrays.asList(GenericTypeUtils.resolveSuperTypeGenericArguments(candidate.getBeanType(), beanType));
    }

    public static boolean areTypesCompatible(Class[] typeArguments, List<Class> classes) {
        if (classes.isEmpty()) {
            return true;
        }
        if (classes.size() != typeArguments.length) {
            return false;
        }
        for (int i2 = 0; i2 < classes.size(); ++i2) {
            Class left = classes.get(i2);
            Class right = typeArguments[i2];
            if (right == Object.class || left == right || left.isAssignableFrom(right)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeArgumentQualifier that = (TypeArgumentQualifier)o;
        return Arrays.equals(this.typeArguments, that.typeArguments);
    }

    public int hashCode() {
        return Arrays.hashCode(this.typeArguments);
    }

    public String toString() {
        return "<" + Arrays.stream(this.typeArguments).map(Class::getSimpleName).collect(Collectors.joining(",")) + ">";
    }
}

