/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.checkdbconnection;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.annotations.ActionTransformType;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IEnumHasCodeAndDescription;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.resource.IResourceHolder;
import org.apache.hop.resource.ResourceEntry;
import org.apache.hop.resource.ResourceReference;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;

@Action(id="CHECK_DB_CONNECTIONS", name="i18n::ActionCheckDbConnections.Name", description="i18n::ActionCheckDbConnections.Description", image="CheckDbConnection.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.Conditions", keywords={"i18n::ActionCheckDbConnections.keyword"}, documentationUrl="/workflow/actions/checkdbconnection.html", actionTransformTypes={ActionTransformType.ENV_CHECK, ActionTransformType.RDBMS})
public class ActionCheckDbConnections
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = ActionCheckDbConnections.class;
    @HopMetadataProperty(groupKey="connections", key="connection")
    private List<CDConnection> connections;

    public ActionCheckDbConnections(String name) {
        super(name, "");
        this.connections = new ArrayList<CDConnection>();
    }

    public ActionCheckDbConnections() {
        this("");
    }

    public ActionCheckDbConnections(ActionCheckDbConnections other) {
        super(other.getName(), other.getDescription(), other.getPluginId());
        this.connections = other.getConnections();
    }

    public Object clone() {
        return new ActionCheckDbConnections(this);
    }

    public Result execute(Result result, int nr) {
        result.setResult(true);
        int nrErrors = 0;
        int nrSuccess = 0;
        if (this.connections != null) {
            for (CDConnection connection : this.connections) {
                if (this.parentWorkflow.isStopped()) break;
                String databaseName = this.resolve(connection.getName());
                DatabaseMeta databaseMeta = this.loadDatabaseMeta(databaseName);
                if (databaseMeta == null) {
                    this.logError(BaseMessages.getString(PKG, (String)"ActionCheckDbConnections.DatabaseConnectionCouldNotBeLoaded.Message", (String[])new String[]{databaseName}));
                    ++nrErrors;
                    continue;
                }
                try (Database db = new Database((ILoggingObject)this, (IVariables)this, databaseMeta);){
                    long iMaximumTimeout;
                    db.connect();
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"ActionCheckDbConnections.Connected", (String[])new String[]{databaseMeta.getDatabaseName(), databaseMeta.getName()}));
                    }
                    if ((iMaximumTimeout = Const.toLong((String)this.resolve(connection.getWaitTime()), (long)0L)) > 0L) {
                        WaitTimeUnit timeUnit = connection.getWaitTimeUnit();
                        long multiple = timeUnit.getFactor();
                        String waitTimeMessage = connection.getWaitTimeUnit().getDescription();
                        if (this.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"ActionCheckDbConnections.Wait", (String[])new String[]{"" + iMaximumTimeout, waitTimeMessage}));
                        }
                        long timeStart = System.currentTimeMillis();
                        boolean continueLoop = true;
                        while (continueLoop && !this.parentWorkflow.isStopped()) {
                            long now = System.currentTimeMillis();
                            if (now >= timeStart + iMaximumTimeout * multiple) {
                                if (this.isDetailed()) {
                                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionCheckDbConnections.WaitTimeIsElapsed.Label", (String[])new String[]{databaseMeta.getDatabaseName(), databaseMeta.getName()}));
                                }
                                continueLoop = false;
                                continue;
                            }
                            try {
                                Thread.sleep(100L);
                            }
                            catch (Exception exception) {}
                        }
                    }
                    ++nrSuccess;
                    if (!this.isDetailed()) continue;
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionCheckDbConnections.ConnectionOK", (String[])new String[]{databaseMeta.getDatabaseName(), databaseMeta.getName()}));
                }
                catch (HopDatabaseException e) {
                    ++nrErrors;
                    this.logError(BaseMessages.getString(PKG, (String)"ActionCheckDbConnections.Exception", (String[])new String[]{databaseMeta.getDatabaseName(), databaseMeta.getName(), e.toString()}));
                }
            }
        }
        if (nrErrors > 0) {
            result.setNrErrors((long)nrErrors);
            result.setResult(false);
        }
        if (this.isDetailed()) {
            this.logDetailed("=======================================");
            this.logDetailed(BaseMessages.getString(PKG, (String)"ActionCheckDbConnections.Log.Info.ConnectionsInError", (String[])new String[]{"" + nrErrors}));
            this.logDetailed(BaseMessages.getString(PKG, (String)"ActionCheckDbConnections.Log.Info.ConnectionsInSuccess", (String[])new String[]{"" + nrSuccess}));
            this.logDetailed("=======================================");
        }
        return result;
    }

    private DatabaseMeta loadDatabaseMeta(String databaseName) {
        try {
            IHopMetadataSerializer serializer = this.getMetadataProvider().getSerializer(DatabaseMeta.class);
            return (DatabaseMeta)serializer.load(databaseName);
        }
        catch (HopException e) {
            this.logError("Error loading database metadata for connection '" + databaseName + "'", e);
            return null;
        }
    }

    public boolean isEvaluation() {
        return true;
    }

    public List<ResourceReference> getResourceDependencies(IVariables variables, WorkflowMeta workflowMeta) {
        List references = super.getResourceDependencies(variables, workflowMeta);
        for (CDConnection connection : this.connections) {
            DatabaseMeta databaseMeta = this.loadDatabaseMeta(this.resolve(connection.getName()));
            if (databaseMeta == null) continue;
            ResourceReference reference = new ResourceReference((IResourceHolder)this);
            reference.getEntries().add(new ResourceEntry(databaseMeta.getHostname(), ResourceEntry.ResourceType.SERVER));
            reference.getEntries().add(new ResourceEntry(databaseMeta.getDatabaseName(), ResourceEntry.ResourceType.DATABASENAME));
            references.add(reference);
        }
        return references;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        if (this.connections == null || this.connections.isEmpty()) {
            String message = BaseMessages.getString(PKG, (String)"ActionCheckDbConnections.CheckResult.NothingToCheck", (String[])new String[0]);
            remarks.add((ICheckResult)new CheckResult(3, message, (ICheckResultSource)this));
        } else {
            for (CDConnection connection : this.connections) {
                String message;
                if (Utils.isEmpty((CharSequence)connection.getName())) {
                    message = BaseMessages.getString(PKG, (String)"ActionCheckDbConnections.CheckResult.MissingConnectionName", (String[])new String[0]);
                    remarks.add((ICheckResult)new CheckResult(4, message, (ICheckResultSource)this));
                }
                if (!Utils.isEmpty((CharSequence)connection.getWaitTime())) continue;
                message = BaseMessages.getString(PKG, (String)"ActionCheckDbConnections.CheckResult.MissingWaitTime", (String[])new String[0]);
                remarks.add((ICheckResult)new CheckResult(4, message, (ICheckResultSource)this));
            }
        }
    }

    public List<CDConnection> getConnections() {
        return this.connections;
    }

    public void setConnections(List<CDConnection> connections) {
        this.connections = connections;
    }

    public static final class CDConnection {
        @HopMetadataProperty(key="name")
        private String name;
        @HopMetadataProperty(key="waitfor")
        private String waitTime = "200";
        @HopMetadataProperty(key="waittime", storeWithCode=true)
        private WaitTimeUnit waitTimeUnit = WaitTimeUnit.MILLISECOND;

        public CDConnection() {
        }

        public CDConnection(CDConnection c) {
            this();
            this.name = c.name;
            this.waitTime = c.waitTime;
            this.waitTimeUnit = c.waitTimeUnit;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getWaitTime() {
            return this.waitTime;
        }

        @Generated
        public WaitTimeUnit getWaitTimeUnit() {
            return this.waitTimeUnit;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setWaitTime(String waitTime) {
            this.waitTime = waitTime;
        }

        @Generated
        public void setWaitTimeUnit(WaitTimeUnit waitTimeUnit) {
            this.waitTimeUnit = waitTimeUnit;
        }
    }

    public static enum WaitTimeUnit implements IEnumHasCodeAndDescription
    {
        MILLISECOND("millisecond", BaseMessages.getString(PKG, (String)"ActionCheckDbConnections.UnitTimeMilliSecond.Label", (String[])new String[0]), 1L),
        SECOND("second", BaseMessages.getString(PKG, (String)"ActionCheckDbConnections.UnitTimeSecond.Label", (String[])new String[0]), 1000L),
        MINUTE("minute", BaseMessages.getString(PKG, (String)"ActionCheckDbConnections.UnitTimeMinute.Label", (String[])new String[0]), 60000L),
        HOUR("hour", BaseMessages.getString(PKG, (String)"ActionCheckDbConnections.UnitTimeHour.Label", (String[])new String[0]), 3600000L);

        private final String code;
        private final String description;
        private final long factor;

        private WaitTimeUnit(String code, String description, long factor) {
            this.code = code;
            this.description = description;
            this.factor = factor;
        }

        public static String[] getDescriptions() {
            return IEnumHasCodeAndDescription.getDescriptions(WaitTimeUnit.class);
        }

        public static WaitTimeUnit lookupDescription(String description) {
            return (WaitTimeUnit)IEnumHasCodeAndDescription.lookupDescription(WaitTimeUnit.class, (String)description, (IEnumHasCodeAndDescription)MILLISECOND);
        }

        @Generated
        public String getCode() {
            return this.code;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public long getFactor() {
            return this.factor;
        }
    }
}

