/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.salesforce;

import com.google.common.primitives.Ints;
import java.util.Calendar;
import java.util.TimeZone;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.salesforce.SalesforceConnection;
import org.apache.hop.pipeline.transforms.salesforce.SalesforceTransformData;
import org.apache.hop.pipeline.transforms.salesforce.SalesforceTransformMeta;

public abstract class SalesforceTransform<Meta extends SalesforceTransformMeta, Data extends SalesforceTransformData>
extends BaseTransform<Meta, Data> {
    public static Class<?> PKG = SalesforceTransform.class;

    public SalesforceTransform(TransformMeta transformMeta, Meta meta, Data data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, meta, data, copyNr, pipelineMeta, pipeline);
    }

    public boolean init() {
        if (!super.init()) {
            return false;
        }
        String realModule = this.resolve(((SalesforceTransformMeta)this.meta).getModule());
        if (Utils.isEmpty((CharSequence)realModule)) {
            this.logError(BaseMessages.getString(PKG, (String)"SalesForceTransform.ModuleMissing.DialogMessage", (String[])new String[0]));
            return false;
        }
        try {
            String connectionName = this.resolve(((SalesforceTransformMeta)this.meta).getSalesforceConnection());
            if (!Utils.isEmpty((CharSequence)connectionName)) {
                try {
                    IHopMetadataSerializer serializer = this.metadataProvider.getSerializer(org.apache.hop.metadata.salesforce.SalesforceConnection.class);
                    org.apache.hop.metadata.salesforce.SalesforceConnection sfConnection = (org.apache.hop.metadata.salesforce.SalesforceConnection)serializer.load(connectionName);
                    if (sfConnection == null) {
                        this.logError("Salesforce Connection '" + connectionName + "' not found in metadata");
                        return false;
                    }
                    ((SalesforceTransformData)this.data).connection = sfConnection.createConnection((IVariables)this, this.getLogChannel());
                }
                catch (HopException e) {
                    this.logError("Error loading Salesforce Connection '" + connectionName + "': " + e.getMessage());
                    return false;
                }
            } else {
                String realUrl = this.resolve(((SalesforceTransformMeta)this.meta).getTargetUrl());
                String realUsername = this.resolve(((SalesforceTransformMeta)this.meta).getUsername());
                String realPassword = this.resolve(((SalesforceTransformMeta)this.meta).getPassword());
                if (Utils.isEmpty((CharSequence)realUrl)) {
                    this.logError(BaseMessages.getString(PKG, (String)"SalesforceConnection.TargetURLMissing.Error", (String[])new String[0]));
                    return false;
                }
                if (Utils.isEmpty((CharSequence)realUsername)) {
                    this.logError(BaseMessages.getString(PKG, (String)"SalesforceConnection.UsernameMissing.Error", (String[])new String[0]));
                    return false;
                }
                if (Utils.isEmpty((CharSequence)realPassword)) {
                    this.logError(BaseMessages.getString(PKG, (String)"SalesforceConnection.PasswordMissing.Error", (String[])new String[0]));
                    return false;
                }
                ((SalesforceTransformData)this.data).connection = new SalesforceConnection(this.getLogChannel(), realUrl, realUsername, realPassword);
            }
            ((SalesforceTransformData)this.data).connection.setModule(realModule);
            ((SalesforceTransformData)this.data).connection.setTimeOut(Const.toInt((String)this.resolve(((SalesforceTransformMeta)this.meta).getTimeout()), (int)0));
            ((SalesforceTransformData)this.data).connection.setUsingCompression(((SalesforceTransformMeta)this.meta).isCompression());
        }
        catch (HopException ke) {
            this.logError(BaseMessages.getString(PKG, (String)"SalesforceTransform.Log.ErrorOccurredDuringTransformInitialize", (String[])new String[0]) + ke.getMessage());
            return false;
        }
        return true;
    }

    public void dispose() {
        if (((SalesforceTransformData)this.data).connection != null) {
            try {
                ((SalesforceTransformData)this.data).connection.close();
            }
            catch (HopException hopException) {
                // empty catch block
            }
            ((SalesforceTransformData)this.data).connection = null;
        }
        super.dispose();
    }

    public Object normalizeValue(IValueMeta valueMeta, Object value) throws HopValueException {
        if (valueMeta.isDate()) {
            Calendar cal = Calendar.getInstance(valueMeta.getDateFormatTimeZone());
            cal.setTime(valueMeta.getDate(value));
            Calendar utc = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            utc.clear();
            utc.set(cal.get(1), cal.get(2), cal.get(5), cal.get(11), cal.get(12), cal.get(13));
            value = utc;
        } else if (valueMeta.isStorageBinaryString()) {
            value = valueMeta.convertToNormalStorageType(value);
        }
        if (5 == valueMeta.getType()) {
            value = Ints.checkedCast((long)((Long)value));
        }
        return value;
    }
}

