/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.nullif;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.nullif.NullIf;
import org.apache.hop.pipeline.transforms.nullif.NullIfData;
import org.apache.hop.pipeline.transforms.nullif.NullIfField;

@Transform(id="NullIf", image="nullif.svg", name="i18n::NullIf.Name", description="i18n::NullIf.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Transform", keywords={"i18n::NullIfMeta.keyword"}, documentationUrl="/pipeline/transforms/nullif.html")
public class NullIfMeta
extends BaseTransformMeta<NullIf, NullIfData> {
    private static final Class<?> PKG = NullIfMeta.class;
    @HopMetadataProperty(groupKey="fields", key="field", injectionGroupKey="FIELDS", injectionGroupDescription="NullIf.Injection.FIELDS")
    private List<NullIfField> fields = new ArrayList<NullIfField>();

    public NullIfMeta() {
    }

    public NullIfMeta(NullIfMeta meta) {
        this();
        for (NullIfField field : meta.fields) {
            this.fields.add(new NullIfField(field.getName(), field.getValue()));
        }
    }

    public List<NullIfField> getFields() {
        return this.fields;
    }

    public void setFields(List<NullIfField> fields) {
        this.fields = fields;
    }

    public Object clone() {
        return new NullIfMeta(this);
    }

    public void getFields(IRowMeta r, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) {
        if (r == null) {
            r = new RowMeta();
        }
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (prev == null || prev.isEmpty()) {
            cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"NullIfMeta.CheckResult.NoReceivingFieldsError", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"NullIfMeta.CheckResult.TransformReceivingFieldsOK", (String[])new String[]{"" + prev.size()}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"NullIfMeta.CheckResult.TransformRecevingInfoFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"NullIfMeta.CheckResult.NoInputReceivedError", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }
}

