/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kms.model.KmsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteImportedKeyMaterialResponse
extends KmsResponse
implements ToCopyableBuilder<Builder, DeleteImportedKeyMaterialResponse> {
    private static final SdkField<String> KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyId").getter(DeleteImportedKeyMaterialResponse.getter(DeleteImportedKeyMaterialResponse::keyId)).setter(DeleteImportedKeyMaterialResponse.setter(Builder::keyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyId").build()}).build();
    private static final SdkField<String> KEY_MATERIAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyMaterialId").getter(DeleteImportedKeyMaterialResponse.getter(DeleteImportedKeyMaterialResponse::keyMaterialId)).setter(DeleteImportedKeyMaterialResponse.setter(Builder::keyMaterialId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyMaterialId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_ID_FIELD, KEY_MATERIAL_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteImportedKeyMaterialResponse.memberNameToFieldInitializer();
    private final String keyId;
    private final String keyMaterialId;

    private DeleteImportedKeyMaterialResponse(BuilderImpl builder) {
        super(builder);
        this.keyId = builder.keyId;
        this.keyMaterialId = builder.keyMaterialId;
    }

    public final String keyId() {
        return this.keyId;
    }

    public final String keyMaterialId() {
        return this.keyMaterialId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.keyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyMaterialId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteImportedKeyMaterialResponse)) {
            return false;
        }
        DeleteImportedKeyMaterialResponse other = (DeleteImportedKeyMaterialResponse)((Object)obj);
        return Objects.equals(this.keyId(), other.keyId()) && Objects.equals(this.keyMaterialId(), other.keyMaterialId());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteImportedKeyMaterialResponse").add("KeyId", (Object)this.keyId()).add("KeyMaterialId", (Object)this.keyMaterialId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyId": {
                return Optional.ofNullable(clazz.cast(this.keyId()));
            }
            case "KeyMaterialId": {
                return Optional.ofNullable(clazz.cast(this.keyMaterialId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("KeyId", KEY_ID_FIELD);
        map.put("KeyMaterialId", KEY_MATERIAL_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteImportedKeyMaterialResponse, T> g) {
        return obj -> g.apply((DeleteImportedKeyMaterialResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KmsResponse.BuilderImpl
    implements Builder {
        private String keyId;
        private String keyMaterialId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteImportedKeyMaterialResponse model) {
            super(model);
            this.keyId(model.keyId);
            this.keyMaterialId(model.keyMaterialId);
        }

        public final String getKeyId() {
            return this.keyId;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final String getKeyMaterialId() {
            return this.keyMaterialId;
        }

        public final void setKeyMaterialId(String keyMaterialId) {
            this.keyMaterialId = keyMaterialId;
        }

        @Override
        public final Builder keyMaterialId(String keyMaterialId) {
            this.keyMaterialId = keyMaterialId;
            return this;
        }

        @Override
        public DeleteImportedKeyMaterialResponse build() {
            return new DeleteImportedKeyMaterialResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends KmsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteImportedKeyMaterialResponse> {
        public Builder keyId(String var1);

        public Builder keyMaterialId(String var1);
    }
}

