/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.util;

import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.measure.Range;
import org.apache.sis.metadata.iso.extent.Extents;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicBoundingBox;

public final class ExtentSelector<T> {
    private GeographicBoundingBox areaOfInterest;
    private Instant minTOI;
    private Instant maxTOI;
    private long granularity;
    public boolean alternateOrdering;
    private T best;
    private double largestArea;
    private Duration longestTime;
    private double outsideArea;
    private Duration overtime;
    private double pseudoDistance;
    private double temporalDistance;
    private static final int OVERTIME = 0;
    private static final int TEMPORAL_DISTANCE = 1;
    private static final int OUTSIDE_AREA = 2;
    private static final int PSEUDO_DISTANCE = 3;
    private static final int NONE = 4;

    public ExtentSelector(GeographicBoundingBox aoi, Instant[] toi) {
        int n;
        this.areaOfInterest = aoi;
        if (toi != null && (n = toi.length) != 0) {
            this.minTOI = toi[0];
            this.maxTOI = toi[n - 1];
        }
    }

    public ExtentSelector(Extent domain) {
        if (!this.setExtentOfInterest(domain, null, null)) {
            throw new IllegalArgumentException();
        }
    }

    public final boolean setExtentOfInterest(Extent domain, GeographicBoundingBox aoi, Instant[] toi) {
        Comparable<Date> t;
        this.areaOfInterest = Extents.intersection(aoi, Extents.getGeographicBoundingBox(domain));
        this.maxTOI = null;
        this.minTOI = null;
        Range<Date> tr = Extents.getTimeRange(domain);
        if (tr != null) {
            t = tr.getMinValue();
            if (t != null) {
                this.minTOI = ((Date)t).toInstant();
            }
            if ((t = tr.getMaxValue()) != null) {
                this.maxTOI = ((Date)t).toInstant();
            }
        }
        if (toi != null && toi.length != 0) {
            t = toi[0];
            if (this.minTOI == null || t != null && ((Instant)t).isAfter(this.minTOI)) {
                this.minTOI = t;
            }
            if (toi.length >= 2) {
                t = toi[1];
            }
            if (this.maxTOI == null || t != null && ((Instant)t).isBefore(this.maxTOI)) {
                this.maxTOI = t;
            }
        }
        return (this.minTOI == null || this.maxTOI == null || !this.minTOI.isAfter(this.maxTOI)) && (this.areaOfInterest == null || this.areaOfInterest.getNorthBoundLatitude() >= this.areaOfInterest.getSouthBoundLatitude() && Double.isFinite(this.areaOfInterest.getWestBoundLongitude()) && Double.isFinite(this.areaOfInterest.getEastBoundLongitude()) && !Boolean.FALSE.equals(this.areaOfInterest.getInclusion()));
    }

    public final GeographicBoundingBox getAreaOfInterest() {
        return this.areaOfInterest;
    }

    public final Instant[] getTimeOfInterest() {
        Instant[] instantArray;
        if (this.minTOI == null && this.maxTOI == null) {
            instantArray = null;
        } else {
            Instant[] instantArray2 = new Instant[2];
            instantArray2[0] = this.minTOI;
            instantArray = instantArray2;
            instantArray2[1] = this.maxTOI;
        }
        return instantArray;
    }

    public final void setTimeGranularity(Duration resolution) {
        if (resolution == null) {
            this.granularity = 0L;
        } else {
            if (resolution.isZero() || resolution.isNegative()) {
                throw new IllegalArgumentException(Errors.format((short)45, "resolution", resolution));
            }
            this.granularity = resolution.getSeconds();
        }
    }

    private Duration round(Duration duration) {
        if (duration != null && !duration.isZero() && this.granularity != 0L) {
            long t = duration.getSeconds();
            long n = t / this.granularity;
            long r = t % this.granularity;
            if (r != 0L) {
                if ((t -= r) == 0L || r >= this.granularity >> 1) {
                    t += this.granularity;
                }
                duration = Duration.ofSeconds(t);
            }
        }
        return duration;
    }

    private double pseudoDistance(GeographicBoundingBox area) {
        if (this.areaOfInterest == null || area == null) {
            return Double.NaN;
        }
        double c\u03c6 = this.areaOfInterest.getNorthBoundLatitude() + this.areaOfInterest.getSouthBoundLatitude();
        double d\u03c6 = area.getNorthBoundLatitude() + area.getSouthBoundLatitude() - c\u03c6;
        double d\u03bb = (area.getEastBoundLongitude() - this.areaOfInterest.getEastBoundLongitude() + (area.getWestBoundLongitude() - this.areaOfInterest.getWestBoundLongitude())) * Math.cos(c\u03c6 * (Math.PI / 360));
        return d\u03c6 * d\u03c6 + d\u03bb * d\u03bb;
    }

    private double temporalDistance(Instant startTime, Instant endTime) {
        return Math.abs(ExtentSelector.median(startTime, endTime) - ExtentSelector.median(this.minTOI, this.maxTOI));
    }

    private static double median(Instant startTime, Instant endTime) {
        if (startTime != null) {
            long t = startTime.toEpochMilli();
            return endTime != null ? MathFunctions.average(t, endTime.toEpochMilli()) : (double)t;
        }
        return endTime != null ? (double)endTime.toEpochMilli() : Double.NaN;
    }

    private Duration overtime(Instant startTime, Instant endTime, Duration intersection) {
        return startTime != null && endTime != null && intersection != null ? this.round(Duration.between(startTime, endTime).minus(intersection)) : null;
    }

    public void evaluate(Extent domain, T object) {
        Date t;
        Range<Date> tr = Extents.getTimeRange(domain);
        this.evaluate(Extents.getGeographicBoundingBox(domain), tr != null && (t = tr.getMinValue()) != null ? t.toInstant() : null, tr != null && (t = tr.getMaxValue()) != null ? t.toInstant() : null, object);
    }

    public void evaluate(GeographicBoundingBox bbox, Instant startTime, Instant endTime, T object) {
        int comparison;
        double area;
        Duration duration;
        Instant tmin = startTime;
        Instant tmax = endTime;
        if (tmin != null && this.minTOI != null && tmin.isBefore(this.minTOI)) {
            tmin = this.minTOI;
        }
        if (tmax != null && this.maxTOI != null && tmax.isAfter(this.maxTOI)) {
            tmax = this.maxTOI;
        }
        if (tmin != null && tmax != null) {
            duration = Duration.between(tmin, tmax);
            if (duration.isNegative()) {
                return;
            }
        } else {
            duration = null;
        }
        if (Double.isNaN(area = Extents.area(Extents.intersection(bbox, this.areaOfInterest))) && bbox != null) {
            return;
        }
        Duration durationRounded = this.round(duration);
        int remainingFieldsToCompute = 0;
        if (this.best != null && (comparison = ExtentSelector.compare(durationRounded, this.longestTime, -1)) <= 0) {
            if (comparison != 0) {
                return;
            }
            remainingFieldsToCompute = 1;
            Duration et = this.overtime(startTime, endTime, duration);
            comparison = ExtentSelector.compare(et, this.overtime, 1);
            if (comparison >= 0) {
                if (comparison != 0) {
                    return;
                }
                remainingFieldsToCompute = 2;
                double td = this.temporalDistance(startTime, endTime);
                if (this.alternateOrdering || (comparison = ExtentSelector.compare(td, this.temporalDistance, 1)) >= 0) {
                    if (comparison != 0) {
                        return;
                    }
                    comparison = ExtentSelector.compare(area, this.largestArea, -1);
                    if (comparison <= 0) {
                        if (comparison != 0) {
                            return;
                        }
                        remainingFieldsToCompute = 3;
                        double out = Extents.area(bbox) - area;
                        comparison = ExtentSelector.compare(out, this.outsideArea, 1);
                        if (comparison >= 0) {
                            if (comparison != 0) {
                                return;
                            }
                            remainingFieldsToCompute = 4;
                            double pd = this.pseudoDistance(bbox);
                            if (!(ExtentSelector.compare(pd, this.pseudoDistance, 1) < 0 || comparison == 0 && this.alternateOrdering)) {
                                return;
                            }
                            if (this.alternateOrdering && ExtentSelector.compare(td, this.temporalDistance, 1) >= 0) {
                                return;
                            }
                            this.pseudoDistance = pd;
                        }
                        this.outsideArea = out;
                    }
                }
                this.temporalDistance = td;
            }
            this.overtime = et;
        }
        this.longestTime = durationRounded;
        this.largestArea = area;
        switch (remainingFieldsToCompute) {
            case 0: {
                this.overtime = this.overtime(startTime, endTime, duration);
            }
            case 1: {
                this.temporalDistance = this.temporalDistance(startTime, endTime);
            }
            case 2: {
                this.outsideArea = Extents.area(bbox) - area;
            }
            case 3: {
                this.pseudoDistance = this.pseudoDistance(bbox);
            }
        }
        this.best = object;
    }

    private static int compare(Duration a, Duration b, int missing) {
        if (a != null) {
            return b != null ? a.compareTo(b) : -missing;
        }
        return b != null ? missing : 0;
    }

    private static int compare(double a, double b, int missing) {
        if (a < b) {
            return -1;
        }
        if (a > b) {
            return 1;
        }
        boolean n = Double.isNaN(b);
        if (Double.isNaN(a) == n) {
            return 0;
        }
        if (n) {
            missing = -missing;
        }
        return missing;
    }

    public T best() {
        return this.best;
    }
}

