/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.cm.impl;

import java.util.Arrays;
import org.apache.felix.cm.PersistenceManager;
import org.apache.felix.cm.impl.ConfigurationAdminStarter;
import org.apache.felix.cm.impl.Log;
import org.apache.felix.cm.impl.RequiredConfigurationPluginTracker;
import org.apache.felix.cm.impl.persistence.ExtPersistenceManager;
import org.apache.felix.cm.impl.persistence.PersistenceManagerTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceFactory;

public class DependencyTracker {
    private final PersistenceManagerTracker persistenceManagerTracker;
    private final RequiredConfigurationPluginTracker configurationPluginTracker;
    private final ConfigurationAdminStarter starter;

    public DependencyTracker(BundleContext bundleContext, ServiceFactory<PersistenceManager> defaultFactory, String pmName, String[] pluginNames) throws BundleException, InvalidSyntaxException {
        boolean hasPlugins;
        this.starter = new ConfigurationAdminStarter(bundleContext);
        boolean bl = hasPlugins = pmName != null || pluginNames != null;
        if (pluginNames != null) {
            Log.logger.log(4, "Requiring configuration plugins {0}", new Object[]{Arrays.toString(pluginNames)});
            this.configurationPluginTracker = new RequiredConfigurationPluginTracker(bundleContext, this.starter, pluginNames);
        } else {
            this.configurationPluginTracker = null;
            if (hasPlugins) {
                this.starter.updatePluginsSet(true);
            }
        }
        if (pmName != null) {
            Log.logger.log(4, "Using persistence manager {0}", new Object[]{pmName});
            this.persistenceManagerTracker = new PersistenceManagerTracker(bundleContext, this.starter, pmName);
        } else {
            this.persistenceManagerTracker = null;
            Log.logger.log(4, "Using default persistence manager", (Object[])null);
            PersistenceManager defaultPM = null;
            try {
                defaultPM = (PersistenceManager)defaultFactory.getService(null, null);
            }
            catch (IllegalArgumentException iae) {
                Log.logger.log(1, "Cannot create the FilePersistenceManager", iae);
            }
            if (defaultPM == null) {
                throw new BundleException("Unable to register default persistence manager.");
            }
            ExtPersistenceManager epm = PersistenceManagerTracker.createPersistenceManagerProxy(defaultPM);
            if (hasPlugins) {
                this.starter.setPersistenceManager(epm);
            } else {
                this.starter.activate(epm);
            }
        }
    }

    public void stop() {
        this.starter.deactivate();
        if (this.persistenceManagerTracker != null) {
            this.persistenceManagerTracker.stop();
        }
        if (this.configurationPluginTracker != null) {
            this.configurationPluginTracker.stop();
        }
    }
}

