/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.unmodifiable;

import aQute.bnd.unmodifiable.ImmutableIterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

final class ImmutableListIterator<E>
extends ImmutableIterator<E>
implements ListIterator<E> {
    ImmutableListIterator(E[] elements) {
        super(elements);
    }

    ImmutableListIterator(E[] elements, int index) {
        super(elements);
        this.index = index;
        if (index < 0 || index > elements.length) {
            throw new IndexOutOfBoundsException("size " + elements.length + ", index " + index);
        }
    }

    @Override
    public boolean hasPrevious() {
        return this.index > 0;
    }

    @Override
    public E previous() {
        if (this.hasPrevious()) {
            return (E)this.elements[--this.index];
        }
        throw new NoSuchElementException();
    }

    @Override
    public int nextIndex() {
        return this.index;
    }

    @Override
    public int previousIndex() {
        return this.index - 1;
    }

    @Override
    public void set(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(E e) {
        throw new UnsupportedOperationException();
    }
}

