/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.api.console;

import java.util.HashMap;
import java.util.Map;

public enum Signal {
    HUP(1),
    INT(2),
    QUIT(3),
    ILL(4),
    TRAP(5),
    IOT(6),
    BUS(7),
    FPE(8),
    KILL(9),
    USR1(10),
    SEGV(11),
    USR2(12),
    PIPE(13),
    ALRM(14),
    TERM(15),
    STKFLT(16),
    CHLD(17),
    CONT(18),
    STOP(19),
    TSTP(20),
    TTIN(21),
    TTOU(22),
    URG(23),
    XCPU(24),
    XFSZ(25),
    VTALRM(26),
    PROF(27),
    WINCH(28),
    IO(29),
    PWR(30);

    private static final Map<String, Signal> lookupTable;
    private final int numeric;

    public static Signal get(String name) {
        return lookupTable.get(name);
    }

    private Signal(int numeric) {
        this.numeric = numeric;
    }

    public int getNumeric() {
        return this.numeric;
    }

    static {
        lookupTable = new HashMap<String, Signal>(40);
        for (Signal s : Signal.values()) {
            lookupTable.put(s.name(), s);
        }
    }
}

