/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.localengine;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.protobuf.Struct;
import com.google.protobuf.Value;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tags;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import lombok.NonNull;
import org.apache.bifromq.basekv.localengine.IKVEngine;
import org.apache.bifromq.basekv.localengine.IKVSpace;
import org.apache.bifromq.basekv.localengine.metrics.KVSpaceOpMeters;
import org.apache.bifromq.logger.MDCLogger;
import org.slf4j.Logger;

public abstract class AbstractKVEngine<T extends IKVSpace>
implements IKVEngine<T> {
    protected final String overrideIdentity;
    protected final Struct engineConf;
    private final AtomicReference<State> state = new AtomicReference<State>(State.INIT);
    private final Map<String, T> kvSpaceMap = new ConcurrentHashMap<String, T>();
    protected Logger log;
    protected String[] metricTags;
    private Gauge gauge;

    public AbstractKVEngine(String overrideIdentity, @NonNull Struct conf) {
        if (conf == null) {
            throw new NullPointerException("conf is marked non-null but is null");
        }
        this.validateConf(conf);
        this.overrideIdentity = overrideIdentity;
        this.engineConf = conf;
    }

    @Override
    public final void start(String ... tags) {
        if (this.state.compareAndSet(State.INIT, State.STARTING)) {
            try {
                this.log = MDCLogger.getLogger(this.getClass(), (String[])tags);
                this.metricTags = tags;
                this.doStart(tags);
                this.state.set(State.STARTED);
                this.gauge = Gauge.builder((String)"basekv.le.ranges", this.spaces()::size).tags(tags).register((MeterRegistry)Metrics.globalRegistry);
                this.afterStart();
            }
            catch (Throwable e) {
                this.state.set(State.FATAL_FAILURE);
                throw e;
            }
        }
    }

    protected abstract void doStart(String ... var1);

    protected void afterStart() {
    }

    @Override
    public final void stop() {
        this.assertStarted();
        if (this.state.compareAndSet(State.STARTED, State.STOPPING)) {
            try {
                this.doStop();
                Metrics.globalRegistry.remove((Meter)this.gauge);
            }
            finally {
                this.state.set(State.STOPPED);
            }
        }
    }

    protected void doStop() {
        this.kvSpaceMap.values().forEach(IKVSpace::close);
    }

    protected void assertStarted() {
        assert (this.state.get() == State.STARTED) : "Not started";
    }

    @Override
    public final Map<String, T> spaces() {
        this.assertStarted();
        return Collections.unmodifiableMap(this.kvSpaceMap);
    }

    @Override
    public final T createIfMissing(String spaceId) {
        this.assertStarted();
        return (T)this.kvSpaceMap.computeIfAbsent(spaceId, k -> {
            T space = this.buildKVSpace(spaceId, this.engineConf, () -> this.kvSpaceMap.remove(spaceId), this.metricTags);
            space.open();
            return space;
        });
    }

    protected final void load(String spaceId) {
        T space = this.buildKVSpace(spaceId, this.engineConf, () -> this.kvSpaceMap.remove(spaceId), this.metricTags);
        space.open();
        IKVSpace prev = (IKVSpace)this.kvSpaceMap.put(spaceId, space);
        assert (prev == null);
    }

    private T buildKVSpace(String spaceId, Struct conf, Runnable onDestroy, String ... tags) {
        String[] tagList = (String[])Lists.newArrayList((Iterable)Iterables.concat(List.of(tags), List.of("spaceId", spaceId))).toArray(String[]::new);
        KVSpaceOpMeters opMeters = new KVSpaceOpMeters(spaceId, Tags.of((String[])tagList));
        Logger logger = MDCLogger.getLogger((String)"space.logger", (String[])tagList);
        return this.doBuildKVSpace(spaceId, conf, onDestroy, opMeters, logger, tagList);
    }

    protected abstract T doBuildKVSpace(String var1, Struct var2, Runnable var3, KVSpaceOpMeters var4, Logger var5, String ... var6);

    protected final void validateConf(Struct conf) {
        if (conf == null) {
            throw new IllegalArgumentException("Engine configuration must not be null");
        }
        Struct defaults = this.defaultConf();
        for (Map.Entry e : defaults.getFieldsMap().entrySet()) {
            String key = (String)e.getKey();
            if (!conf.getFieldsMap().containsKey(key)) {
                throw new IllegalArgumentException("Missing required config key: " + key);
            }
            Value v = (Value)conf.getFieldsMap().get(key);
            if (v.getKindCase() != Value.KindCase.KIND_NOT_SET && !v.hasNullValue()) continue;
            throw new IllegalArgumentException("Config key has null value: " + key);
        }
        this.validateSemantics(conf);
    }

    protected abstract Struct defaultConf();

    protected void validateSemantics(Struct conf) {
    }

    private static enum State {
        INIT,
        STARTING,
        STARTED,
        FATAL_FAILURE,
        STOPPING,
        STOPPED;

    }
}

