/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.metaservice;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.hash.Funnel;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Struct;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.subjects.BehaviorSubject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.bifromq.base.util.RendezvousHash;
import org.apache.bifromq.basecrdt.core.api.CausalCRDTType;
import org.apache.bifromq.basecrdt.core.api.ICRDTOperation;
import org.apache.bifromq.basecrdt.core.api.IMVReg;
import org.apache.bifromq.basecrdt.core.api.IORMap;
import org.apache.bifromq.basecrdt.core.api.MVRegOperation;
import org.apache.bifromq.basecrdt.core.api.ORMapOperation;
import org.apache.bifromq.basecrdt.proto.Replica;
import org.apache.bifromq.basecrdt.service.ICRDTService;
import org.apache.bifromq.basehlc.HLC;
import org.apache.bifromq.basekv.metaservice.CRDTUtil;
import org.apache.bifromq.basekv.metaservice.IBaseKVMetaService;
import org.apache.bifromq.basekv.metaservice.IBaseKVStoreBalancerStatesCRDT;
import org.apache.bifromq.basekv.proto.BalancerStateSnapshot;
import org.apache.bifromq.basekv.proto.StoreKey;
import org.apache.bifromq.logger.MDCLogger;
import org.slf4j.Logger;

class BaseKVStoreBalancerStatesCRDT
implements IBaseKVStoreBalancerStatesCRDT {
    private final String clusterId;
    private final Logger log;
    private final ICRDTService crdtService;
    private final IORMap balancerStatesByStoreORMap;
    private final BehaviorSubject<Map<StoreKey, Map<String, BalancerStateSnapshot>>> balancerStatesSubject = BehaviorSubject.createDefault(Collections.emptyMap());
    private final CompositeDisposable disposable = new CompositeDisposable();

    BaseKVStoreBalancerStatesCRDT(String clusterId, ICRDTService crdtService) {
        this.clusterId = clusterId;
        this.log = MDCLogger.getLogger(BaseKVStoreBalancerStatesCRDT.class, (String[])new String[]{"clusterId", clusterId});
        this.crdtService = crdtService;
        this.balancerStatesByStoreORMap = (IORMap)crdtService.host(CRDTUtil.toBalancerStateURI(clusterId));
        this.disposable.add(this.balancerStatesByStoreORMap.inflation().observeOn(IBaseKVMetaService.SHARED_SCHEDULER).map(this::buildBalancerStateSnapshots).subscribe(arg_0 -> this.balancerStatesSubject.onNext(arg_0)));
        this.disposable.add(Observable.combineLatest(this.currentBalancerStates(), this.aliveReplicas(), StateSnapshotsAndReplicas::new).observeOn(IBaseKVMetaService.SHARED_SCHEDULER).subscribe(this::houseKeep));
    }

    @Override
    public String clusterId() {
        return this.clusterId;
    }

    @Override
    public Observable<Long> refuteSignal() {
        return this.crdtService.refreshSignal();
    }

    @Override
    public Observable<Set<ByteString>> aliveReplicas() {
        return this.crdtService.aliveReplicas(this.balancerStatesByStoreORMap.id().getUri()).map(replicas -> replicas.stream().map(Replica::getId).collect(Collectors.toSet()));
    }

    @Override
    public Observable<Map<StoreKey, Map<String, BalancerStateSnapshot>>> currentBalancerStates() {
        return this.balancerStatesSubject.distinctUntilChanged();
    }

    @Override
    public Map<String, BalancerStateSnapshot> getStoreBalancerStates(String storeId) {
        return ((Map)this.balancerStatesSubject.getValue()).getOrDefault(this.toDescriptorKey(storeId), Collections.emptyMap());
    }

    @Override
    public CompletableFuture<Void> setStoreBalancerState(String storeId, String balancerClassFQN, boolean disable, Struct loadRules) {
        BalancerStateSnapshot existing;
        StoreKey storeKey = this.toDescriptorKey(storeId);
        Map snapshotMap = ((Map)this.balancerStatesSubject.getValue()).getOrDefault(storeKey, Collections.emptyMap());
        if (snapshotMap.containsKey(balancerClassFQN) && (existing = snapshotMap.getOrDefault(balancerClassFQN, BalancerStateSnapshot.getDefaultInstance())).getDisable() == disable && existing.getLoadRules().equals((Object)loadRules)) {
            return CompletableFuture.completedFuture(null);
        }
        IORMap balancerStatesORMap = this.balancerStatesByStoreORMap.getORMap(new ByteString[]{storeKey.toByteString()});
        return balancerStatesORMap.execute((ICRDTOperation)ORMapOperation.update((ByteString[])new ByteString[]{ByteString.copyFromUtf8((String)balancerClassFQN)}).with(MVRegOperation.write((ByteString)BalancerStateSnapshot.newBuilder().setDisable(disable).setLoadRules(loadRules).setHlc(HLC.INST.get()).build().toByteString())));
    }

    @Override
    public CompletableFuture<Void> removeStore(String storeId) {
        return this.removeStore(this.toDescriptorKey(storeId));
    }

    @Override
    public CompletableFuture<Void> removeStore(StoreKey storeKey) {
        return this.balancerStatesByStoreORMap.execute((ICRDTOperation)ORMapOperation.remove((ByteString[])new ByteString[]{storeKey.toByteString()}).of(CausalCRDTType.ormap));
    }

    @Override
    public StoreKey toDescriptorKey(String storeId) {
        return StoreKey.newBuilder().setStoreId(storeId).setReplicaId(this.balancerStatesByStoreORMap.id().getId()).build();
    }

    @Override
    public void stop() {
        this.disposable.dispose();
        this.crdtService.stopHosting(this.balancerStatesByStoreORMap.id().getUri()).join();
    }

    private Optional<BalancerStateSnapshot> buildBalancerStateSnapshot(IMVReg mvReg) {
        ArrayList l = Lists.newArrayList((Iterator)Iterators.filter((Iterator)Iterators.transform((Iterator)mvReg.read(), b -> {
            try {
                return BalancerStateSnapshot.parseFrom(b);
            }
            catch (InvalidProtocolBufferException e) {
                this.log.error("Unable to parse BalancerState", (Throwable)e);
                return null;
            }
        }), Objects::nonNull));
        l.sort((a, b) -> Long.compareUnsigned(b.getHlc(), a.getHlc()));
        return Optional.ofNullable(l.isEmpty() ? null : (BalancerStateSnapshot)l.get(0));
    }

    private Map<StoreKey, Map<String, BalancerStateSnapshot>> buildBalancerStateSnapshots(long ts) {
        HashMap<StoreKey, Map<String, BalancerStateSnapshot>> currentBalancerStates = new HashMap<StoreKey, Map<String, BalancerStateSnapshot>>();
        this.balancerStatesByStoreORMap.keys().forEachRemaining(storeIdKey -> this.balancerStatesByStoreORMap.getORMap(new ByteString[]{storeIdKey.key()}).keys().forEachRemaining(balancerClassKey -> {
            String balancerClassFQN = balancerClassKey.key().toStringUtf8();
            IMVReg mvReg = this.balancerStatesByStoreORMap.getORMap(new ByteString[]{storeIdKey.key()}).getMVReg(new ByteString[]{balancerClassKey.key()});
            Optional<BalancerStateSnapshot> snapshotOpt = this.buildBalancerStateSnapshot(mvReg);
            snapshotOpt.ifPresent(state -> currentBalancerStates.computeIfAbsent(CRDTUtil.parseDescriptorKey(storeIdKey.key()), k -> new HashMap()).put(balancerClassFQN, state));
        }));
        return currentBalancerStates;
    }

    private void houseKeep(StateSnapshotsAndReplicas stateSnapshotsAndReplicas) {
        Map<StoreKey, Map<String, BalancerStateSnapshot>> observed = stateSnapshotsAndReplicas.observed;
        Set<ByteString> aliveReplicas = stateSnapshotsAndReplicas.replicaIds;
        for (StoreKey storeKey : observed.keySet()) {
            if (aliveReplicas.contains(storeKey.getReplicaId()) || !this.shouldClean(aliveReplicas, storeKey.getReplicaId())) continue;
            this.log.debug("store[{}] is not alive, remove its balancer states", (Object)storeKey.getStoreId());
            this.removeStore(storeKey);
        }
    }

    private boolean shouldClean(Set<ByteString> aliveReplicas, ByteString failedReplicas) {
        RendezvousHash hash = RendezvousHash.builder().keyFunnel((Funnel & Serializable)(from, into) -> into.putBytes(from.asReadOnlyByteBuffer())).nodeFunnel((Funnel & Serializable)(from, into) -> into.putBytes(from.asReadOnlyByteBuffer())).nodes(aliveReplicas).build();
        ByteString cleaner = (ByteString)hash.get((Object)failedReplicas);
        return cleaner != null && cleaner.equals((Object)this.balancerStatesByStoreORMap.id().getId());
    }

    private record StateSnapshotsAndReplicas(Map<StoreKey, Map<String, BalancerStateSnapshot>> observed, Set<ByteString> replicaIds) {
    }
}

