/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.store.range;

import com.google.protobuf.ByteString;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.subjects.BehaviorSubject;
import java.util.Map;
import org.apache.bifromq.basekv.localengine.ICPableKVSpace;
import org.apache.bifromq.basekv.localengine.IKVSpaceCheckpoint;
import org.apache.bifromq.basekv.proto.Boundary;
import org.apache.bifromq.basekv.proto.KVRangeId;
import org.apache.bifromq.basekv.proto.KVRangeSnapshot;
import org.apache.bifromq.basekv.proto.State;
import org.apache.bifromq.basekv.raft.proto.ClusterConfig;
import org.apache.bifromq.basekv.store.api.IKVRangeReader;
import org.apache.bifromq.basekv.store.api.IKVRangeRefreshableReader;
import org.apache.bifromq.basekv.store.range.IKVLoadRecorder;
import org.apache.bifromq.basekv.store.range.IKVRange;
import org.apache.bifromq.basekv.store.range.IKVRangeRestoreSession;
import org.apache.bifromq.basekv.store.range.IKVRangeWriter;
import org.apache.bifromq.basekv.store.range.KVRangeKeys;
import org.apache.bifromq.basekv.store.range.KVRangeReader;
import org.apache.bifromq.basekv.store.range.KVRangeRefreshableReader;
import org.apache.bifromq.basekv.store.range.KVRangeRestoreSession;
import org.apache.bifromq.basekv.store.range.KVRangeWriter;
import org.apache.bifromq.basekv.store.range.LoadRecordableKVRangeWriter;
import org.apache.bifromq.basekv.store.util.KVUtil;
import org.apache.bifromq.basekv.utils.BoundaryUtil;
import org.apache.bifromq.logger.MDCLogger;
import org.slf4j.Logger;

class KVRange
implements IKVRange {
    private final KVRangeId id;
    private final ICPableKVSpace kvSpace;
    private final Logger logger;
    private final BehaviorSubject<Long> versionSubject;
    private final BehaviorSubject<State> stateSubject;
    private final BehaviorSubject<ClusterConfig> clusterConfigSubject;
    private final BehaviorSubject<Boundary> boundarySubject;
    private final BehaviorSubject<Long> lastAppliedIndexSubject;
    private final Disposable disposable;

    KVRange(KVRangeId id, ICPableKVSpace kvSpace, String ... tags) {
        this.id = id;
        this.kvSpace = kvSpace;
        this.logger = MDCLogger.getLogger(KVRange.class, (String[])tags);
        this.versionSubject = BehaviorSubject.createDefault((Object)-1L);
        this.stateSubject = BehaviorSubject.createDefault((Object)State.newBuilder().setType(State.StateType.NoUse).build());
        this.clusterConfigSubject = BehaviorSubject.createDefault((Object)ClusterConfig.getDefaultInstance());
        this.boundarySubject = BehaviorSubject.createDefault((Object)BoundaryUtil.NULL_BOUNDARY);
        this.lastAppliedIndexSubject = BehaviorSubject.createDefault((Object)-1L);
        this.disposable = kvSpace.metadata().subscribe(this::onMetadataChanged);
    }

    public KVRange(KVRangeId id, ICPableKVSpace kvSpace, KVRangeSnapshot snapshot, String ... tags) {
        this(id, kvSpace, tags);
        this.startRestore(snapshot, IKVRangeRestoreSession.IKVRestoreProgressListener.NOOP).done();
    }

    @Override
    public KVRangeId id() {
        return this.id;
    }

    @Override
    public Observable<Long> ver() {
        return this.versionSubject.distinctUntilChanged();
    }

    @Override
    public long currentVer() {
        return (Long)this.versionSubject.blockingFirst();
    }

    @Override
    public Observable<State> state() {
        return this.stateSubject.distinctUntilChanged();
    }

    @Override
    public State currentState() {
        return (State)this.stateSubject.blockingFirst();
    }

    @Override
    public Observable<ClusterConfig> clusterConfig() {
        return this.clusterConfigSubject.distinctUntilChanged();
    }

    @Override
    public ClusterConfig currentClusterConfig() {
        return (ClusterConfig)this.clusterConfigSubject.blockingFirst();
    }

    @Override
    public Observable<Boundary> boundary() {
        return this.boundarySubject.distinctUntilChanged();
    }

    @Override
    public Boundary currentBoundary() {
        return (Boundary)this.boundarySubject.blockingFirst();
    }

    @Override
    public Observable<Long> lastAppliedIndex() {
        return this.lastAppliedIndexSubject.distinctUntilChanged();
    }

    @Override
    public long currentLastAppliedIndex() {
        return (Long)this.lastAppliedIndexSubject.blockingFirst();
    }

    @Override
    public KVRangeSnapshot checkpoint() {
        String checkpointId = this.kvSpace.checkpoint();
        try (KVRangeReader checkpointReader = new KVRangeReader(((IKVSpaceCheckpoint)this.kvSpace.openCheckpoint(checkpointId).get()).newReader());){
            KVRangeSnapshot.Builder builder = KVRangeSnapshot.newBuilder().setVer(checkpointReader.version()).setId(this.id).setCheckpointId(checkpointId).setLastAppliedIndex(checkpointReader.lastAppliedIndex()).setState(checkpointReader.state()).setBoundary(checkpointReader.boundary()).setClusterConfig(checkpointReader.clusterConfig());
            KVRangeSnapshot kVRangeSnapshot = builder.build();
            return kVRangeSnapshot;
        }
    }

    @Override
    public boolean hasCheckpoint(KVRangeSnapshot checkpoint) {
        assert (checkpoint.getId().equals((Object)this.id));
        return checkpoint.hasCheckpointId() && this.kvSpace.openCheckpoint(checkpoint.getCheckpointId()).isPresent();
    }

    @Override
    public IKVRangeReader open(KVRangeSnapshot checkpoint) {
        return new KVRangeReader(((IKVSpaceCheckpoint)this.kvSpace.openCheckpoint(checkpoint.getCheckpointId()).get()).newReader());
    }

    @Override
    public IKVRangeRefreshableReader newReader() {
        return new KVRangeRefreshableReader(this.kvSpace.reader());
    }

    @Override
    public IKVRangeWriter<?> toWriter() {
        return new KVRangeWriter(this.id, this.kvSpace);
    }

    @Override
    public IKVRangeWriter<?> toWriter(IKVLoadRecorder recorder) {
        return new LoadRecordableKVRangeWriter(this.id, this.kvSpace, recorder);
    }

    @Override
    public IKVRangeRestoreSession startRestore(KVRangeSnapshot snapshot, IKVRangeRestoreSession.IKVRestoreProgressListener progressListener) {
        return new KVRangeRestoreSession(this.kvSpace.startRestore(progressListener::onProgress)).ver(snapshot.getVer()).lastAppliedIndex(snapshot.getLastAppliedIndex()).state(snapshot.getState()).boundary(snapshot.getBoundary()).clusterConfig(snapshot.getClusterConfig());
    }

    @Override
    public long size() {
        return this.kvSpace.size();
    }

    @Override
    public void close() {
        this.disposable.dispose();
        this.versionSubject.onComplete();
        this.stateSubject.onComplete();
        this.clusterConfigSubject.onComplete();
        this.boundarySubject.onComplete();
        this.lastAppliedIndexSubject.onComplete();
        this.kvSpace.close();
    }

    @Override
    public void destroy() {
        this.kvSpace.destroy();
    }

    private void onMetadataChanged(Map<ByteString, ByteString> metadata) {
        this.updateVersion(metadata.get(KVRangeKeys.METADATA_VER_BYTES));
        this.updateState(metadata.get(KVRangeKeys.METADATA_STATE_BYTES));
        this.updateClusterConfig(metadata.get(KVRangeKeys.METADATA_CLUSTER_CONFIG_BYTES));
        this.updateBoundary(metadata.get(KVRangeKeys.METADATA_RANGE_BOUND_BYTES));
        this.updateLastAppliedIndex(metadata.get(KVRangeKeys.METADATA_LAST_APPLIED_INDEX_BYTES));
    }

    private void updateVersion(ByteString versionBytes) {
        if (versionBytes != null) {
            this.versionSubject.onNext((Object)KVUtil.toLongNativeOrder(versionBytes));
        }
    }

    private void updateState(ByteString stateBytes) {
        if (stateBytes != null) {
            try {
                this.stateSubject.onNext((Object)State.parseFrom((ByteString)stateBytes));
            }
            catch (Throwable e) {
                this.logger.warn("Failed to parse state from bytes", e);
            }
        }
    }

    private void updateClusterConfig(ByteString clusterConfigBytes) {
        if (clusterConfigBytes != null) {
            try {
                this.clusterConfigSubject.onNext((Object)ClusterConfig.parseFrom((ByteString)clusterConfigBytes));
            }
            catch (Throwable e) {
                this.logger.warn("Failed to parse cluster config from bytes", e);
            }
        }
    }

    private void updateBoundary(ByteString boundaryBytes) {
        if (boundaryBytes != null) {
            try {
                this.boundarySubject.onNext((Object)Boundary.parseFrom((ByteString)boundaryBytes));
            }
            catch (Throwable e) {
                this.logger.warn("Failed to parse boundary from bytes", e);
            }
        }
    }

    private void updateLastAppliedIndex(ByteString lastAppliedIndexBytes) {
        if (lastAppliedIndexBytes != null) {
            this.lastAppliedIndexSubject.onNext((Object)KVUtil.toLong(lastAppliedIndexBytes));
        }
    }
}

