/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class AggregateConfiguration
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=948");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=949");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=950");
    private final Boolean useServerCapabilitiesDefaults;
    private final Boolean treatUncertainAsBad;
    private final UByte percentDataBad;
    private final UByte percentDataGood;
    private final Boolean useSlopedExtrapolation;

    public AggregateConfiguration(Boolean useServerCapabilitiesDefaults, Boolean treatUncertainAsBad, UByte percentDataBad, UByte percentDataGood, Boolean useSlopedExtrapolation) {
        this.useServerCapabilitiesDefaults = useServerCapabilitiesDefaults;
        this.treatUncertainAsBad = treatUncertainAsBad;
        this.percentDataBad = percentDataBad;
        this.percentDataGood = percentDataGood;
        this.useSlopedExtrapolation = useSlopedExtrapolation;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    public Boolean getUseServerCapabilitiesDefaults() {
        return this.useServerCapabilitiesDefaults;
    }

    public Boolean getTreatUncertainAsBad() {
        return this.treatUncertainAsBad;
    }

    public UByte getPercentDataBad() {
        return this.percentDataBad;
    }

    public UByte getPercentDataGood() {
        return this.percentDataGood;
    }

    public Boolean getUseSlopedExtrapolation() {
        return this.useSlopedExtrapolation;
    }

    protected AggregateConfiguration(AggregateConfigurationBuilder<?, ?> b) {
        super(b);
        this.useServerCapabilitiesDefaults = ((AggregateConfigurationBuilder)b).useServerCapabilitiesDefaults;
        this.treatUncertainAsBad = ((AggregateConfigurationBuilder)b).treatUncertainAsBad;
        this.percentDataBad = ((AggregateConfigurationBuilder)b).percentDataBad;
        this.percentDataGood = ((AggregateConfigurationBuilder)b).percentDataGood;
        this.useSlopedExtrapolation = ((AggregateConfigurationBuilder)b).useSlopedExtrapolation;
    }

    public static AggregateConfigurationBuilder<?, ?> builder() {
        return new AggregateConfigurationBuilderImpl();
    }

    public AggregateConfigurationBuilder<?, ?> toBuilder() {
        return new AggregateConfigurationBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AggregateConfiguration)) {
            return false;
        }
        AggregateConfiguration other = (AggregateConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$useServerCapabilitiesDefaults = this.getUseServerCapabilitiesDefaults();
        Boolean other$useServerCapabilitiesDefaults = other.getUseServerCapabilitiesDefaults();
        if (this$useServerCapabilitiesDefaults == null ? other$useServerCapabilitiesDefaults != null : !((Object)this$useServerCapabilitiesDefaults).equals(other$useServerCapabilitiesDefaults)) {
            return false;
        }
        Boolean this$treatUncertainAsBad = this.getTreatUncertainAsBad();
        Boolean other$treatUncertainAsBad = other.getTreatUncertainAsBad();
        if (this$treatUncertainAsBad == null ? other$treatUncertainAsBad != null : !((Object)this$treatUncertainAsBad).equals(other$treatUncertainAsBad)) {
            return false;
        }
        Boolean this$useSlopedExtrapolation = this.getUseSlopedExtrapolation();
        Boolean other$useSlopedExtrapolation = other.getUseSlopedExtrapolation();
        if (this$useSlopedExtrapolation == null ? other$useSlopedExtrapolation != null : !((Object)this$useSlopedExtrapolation).equals(other$useSlopedExtrapolation)) {
            return false;
        }
        UByte this$percentDataBad = this.getPercentDataBad();
        UByte other$percentDataBad = other.getPercentDataBad();
        if (this$percentDataBad == null ? other$percentDataBad != null : !((Object)this$percentDataBad).equals(other$percentDataBad)) {
            return false;
        }
        UByte this$percentDataGood = this.getPercentDataGood();
        UByte other$percentDataGood = other.getPercentDataGood();
        return !(this$percentDataGood == null ? other$percentDataGood != null : !((Object)this$percentDataGood).equals(other$percentDataGood));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AggregateConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $useServerCapabilitiesDefaults = this.getUseServerCapabilitiesDefaults();
        result = result * 59 + ($useServerCapabilitiesDefaults == null ? 43 : ((Object)$useServerCapabilitiesDefaults).hashCode());
        Boolean $treatUncertainAsBad = this.getTreatUncertainAsBad();
        result = result * 59 + ($treatUncertainAsBad == null ? 43 : ((Object)$treatUncertainAsBad).hashCode());
        Boolean $useSlopedExtrapolation = this.getUseSlopedExtrapolation();
        result = result * 59 + ($useSlopedExtrapolation == null ? 43 : ((Object)$useSlopedExtrapolation).hashCode());
        UByte $percentDataBad = this.getPercentDataBad();
        result = result * 59 + ($percentDataBad == null ? 43 : ((Object)$percentDataBad).hashCode());
        UByte $percentDataGood = this.getPercentDataGood();
        result = result * 59 + ($percentDataGood == null ? 43 : ((Object)$percentDataGood).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "AggregateConfiguration(useServerCapabilitiesDefaults=" + this.getUseServerCapabilitiesDefaults() + ", treatUncertainAsBad=" + this.getTreatUncertainAsBad() + ", percentDataBad=" + this.getPercentDataBad() + ", percentDataGood=" + this.getPercentDataGood() + ", useSlopedExtrapolation=" + this.getUseSlopedExtrapolation() + ")";
    }

    private static final class AggregateConfigurationBuilderImpl
    extends AggregateConfigurationBuilder<AggregateConfiguration, AggregateConfigurationBuilderImpl> {
        private AggregateConfigurationBuilderImpl() {
        }

        @Override
        protected AggregateConfigurationBuilderImpl self() {
            return this;
        }

        @Override
        public AggregateConfiguration build() {
            return new AggregateConfiguration(this);
        }
    }

    public static abstract class AggregateConfigurationBuilder<C extends AggregateConfiguration, B extends AggregateConfigurationBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private Boolean useServerCapabilitiesDefaults;
        private Boolean treatUncertainAsBad;
        private UByte percentDataBad;
        private UByte percentDataGood;
        private Boolean useSlopedExtrapolation;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            AggregateConfigurationBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(AggregateConfiguration instance, AggregateConfigurationBuilder<?, ?> b) {
            b.useServerCapabilitiesDefaults(instance.useServerCapabilitiesDefaults);
            b.treatUncertainAsBad(instance.treatUncertainAsBad);
            b.percentDataBad(instance.percentDataBad);
            b.percentDataGood(instance.percentDataGood);
            b.useSlopedExtrapolation(instance.useSlopedExtrapolation);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B useServerCapabilitiesDefaults(Boolean useServerCapabilitiesDefaults) {
            this.useServerCapabilitiesDefaults = useServerCapabilitiesDefaults;
            return (B)this.self();
        }

        public B treatUncertainAsBad(Boolean treatUncertainAsBad) {
            this.treatUncertainAsBad = treatUncertainAsBad;
            return (B)this.self();
        }

        public B percentDataBad(UByte percentDataBad) {
            this.percentDataBad = percentDataBad;
            return (B)this.self();
        }

        public B percentDataGood(UByte percentDataGood) {
            this.percentDataGood = percentDataGood;
            return (B)this.self();
        }

        public B useSlopedExtrapolation(Boolean useSlopedExtrapolation) {
            this.useSlopedExtrapolation = useSlopedExtrapolation;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "AggregateConfiguration.AggregateConfigurationBuilder(super=" + super.toString() + ", useServerCapabilitiesDefaults=" + this.useServerCapabilitiesDefaults + ", treatUncertainAsBad=" + this.treatUncertainAsBad + ", percentDataBad=" + this.percentDataBad + ", percentDataGood=" + this.percentDataGood + ", useSlopedExtrapolation=" + this.useSlopedExtrapolation + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<AggregateConfiguration> {
        @Override
        public Class<AggregateConfiguration> getType() {
            return AggregateConfiguration.class;
        }

        @Override
        public AggregateConfiguration decode(SerializationContext context, UaDecoder decoder) {
            Boolean useServerCapabilitiesDefaults = decoder.readBoolean("UseServerCapabilitiesDefaults");
            Boolean treatUncertainAsBad = decoder.readBoolean("TreatUncertainAsBad");
            UByte percentDataBad = decoder.readByte("PercentDataBad");
            UByte percentDataGood = decoder.readByte("PercentDataGood");
            Boolean useSlopedExtrapolation = decoder.readBoolean("UseSlopedExtrapolation");
            return new AggregateConfiguration(useServerCapabilitiesDefaults, treatUncertainAsBad, percentDataBad, percentDataGood, useSlopedExtrapolation);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, AggregateConfiguration value) {
            encoder.writeBoolean("UseServerCapabilitiesDefaults", value.getUseServerCapabilitiesDefaults());
            encoder.writeBoolean("TreatUncertainAsBad", value.getTreatUncertainAsBad());
            encoder.writeByte("PercentDataBad", value.getPercentDataBad());
            encoder.writeByte("PercentDataGood", value.getPercentDataGood());
            encoder.writeBoolean("UseSlopedExtrapolation", value.getUseSlopedExtrapolation());
        }
    }
}

