/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.gdal;

import java.lang.foreign.AddressLayout;
import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.text.ParseException;
import java.util.Locale;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.internal.shared.AxisDirections;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.gdal.GDAL;
import org.apache.sis.storage.gdal.GDALStore;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.operation.Matrix;

final class SpatialRef {
    static final int BIDIMENSIONAL = 2;
    private final GDALStore owner;
    private final GDAL gdal;
    private final MemorySegment handle;
    private int[] dataAxisToCRSAxis;

    private SpatialRef(GDALStore owner, GDAL gdal, MemorySegment handle) {
        this.owner = owner;
        this.gdal = gdal;
        this.handle = handle;
    }

    static SpatialRef create(GDALStore owner, GDAL gdal, MemorySegment dataset) throws DataStoreException {
        MemorySegment handle;
        try {
            handle = gdal.getSpatialRef.invokeExact(dataset);
            if (GDAL.isNull(handle) && GDAL.isNull(handle = gdal.getGCPSpatialRef.invokeExact(owner.handle()))) {
                return null;
            }
        }
        catch (Throwable e) {
            throw GDAL.propagate(e);
        }
        return new SpatialRef(owner, gdal, handle);
    }

    static CoordinateReferenceSystem parseCRS(GDALStore owner, GDAL gdal, MemorySegment handle) throws Throwable {
        AxisDirection[] directions;
        if (GDAL.isNull(handle)) {
            return null;
        }
        SpatialRef ref = new SpatialRef(owner, gdal, handle);
        CoordinateReferenceSystem crs = ref.parseCRS("components");
        if (crs != null && (directions = ref.getDataAxisDirections(crs.getCoordinateSystem())) != null) {
            AbstractCRS sc = AbstractCRS.castOrCopy((CoordinateReferenceSystem)crs);
            for (AxesConvention c : AxesConvention.valuesForOrder()) {
                AbstractCRS candidate = sc.forConvention(c);
                if (!AxisDirections.hasPrefix((CoordinateSystem)candidate.getCoordinateSystem(), (AxisDirection[])directions)) continue;
                return candidate;
            }
        }
        return crs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final CoordinateReferenceSystem parseCRS(String caller) throws DataStoreException {
        String wkt;
        int err;
        block15: {
            try (Arena arena = Arena.ofConfined();){
                AddressLayout layout = ValueLayout.ADDRESS;
                MemorySegment ptr = arena.allocate(layout).fill((byte)0);
                MemorySegment opt = GDAL.toNullTerminatedStrings(arena, "FORMAT=WKT2_2015");
                err = this.gdal.exportToWkt.invokeExact(this.handle, ptr, opt);
                MemorySegment result = ptr.get(layout, 0L);
                if (GDAL.isNull(result)) {
                    wkt = null;
                    break block15;
                }
                try {
                    wkt = GDAL.toString(result);
                }
                finally {
                    this.gdal.free.invokeExact(result);
                }
            }
            catch (Throwable e) {
                throw GDAL.propagate(e);
            }
        }
        if (err == 0 && wkt != null && !wkt.isBlank()) {
            try {
                return (CoordinateReferenceSystem)this.owner.wktFormat().parseObject(wkt);
            }
            catch (ClassCastException | ParseException e) {
                this.owner.warning(caller, Errors.forLocale((Locale)this.owner.getLocale()).getString((short)155, (Object)this.owner.getDisplayName()), e);
            }
        }
        return null;
    }

    private int[] getDataAxisToCRSAxis(int dimension) {
        if (this.dataAxisToCRSAxis == null) {
            this.dataAxisToCRSAxis = ArraysExt.EMPTY_INT;
            try (Arena arena = Arena.ofConfined();){
                int[] indices;
                ValueLayout.OfInt layout = ValueLayout.JAVA_INT;
                MemorySegment count = arena.allocate(layout);
                MemorySegment vector = this.gdal.getDataAxisToCRSAxis.invokeExact(this.handle, count);
                if (!GDAL.isNull(vector) && (dimension = Math.min(count.get(layout, 0L), dimension)) > 0 && !ArraysExt.isRange((int)1, (int[])(indices = vector.reinterpret(layout.byteSize() * (long)dimension).toArray(layout)))) {
                    this.dataAxisToCRSAxis = indices;
                }
            }
            catch (Throwable e) {
                throw GDAL.propagate(e);
            }
        }
        return this.dataAxisToCRSAxis;
    }

    private AxisDirection[] getDataAxisDirections(CoordinateSystem cs) {
        int[] indices = this.getDataAxisToCRSAxis(cs.getDimension());
        int length = indices.length;
        if (length == 0) {
            return null;
        }
        AxisDirection[] directions = new AxisDirection[length];
        for (int i = 0; i < length; ++i) {
            AxisDirection dir = cs.getAxis(i).getDirection();
            int t = indices[i];
            if (t < 0) {
                dir = AxisDirections.opposite((AxisDirection)dir);
            }
            directions[Math.abs((int)t) - 1] = dir;
        }
        return directions;
    }

    final Matrix getDataToCRS(int dimension) {
        int[] indices = this.getDataAxisToCRSAxis(dimension);
        int length = indices.length;
        if (length == 0) {
            return null;
        }
        MatrixSIS swap = Matrices.createZero((int)(length + 1), (int)3);
        swap.setElement(length, 2, 1.0);
        for (int i = 0; i < length; ++i) {
            int p = indices[i];
            if (p == 0) continue;
            swap.setElement(i, Math.abs(p) - 1, (double)Integer.signum(p));
        }
        return swap;
    }
}

