/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.cli;

import com.siemens.ct.exi.core.EXIFactory;
import com.siemens.ct.exi.core.exceptions.EXIException;
import com.siemens.ct.exi.main.api.sax.EXIResult;
import com.siemens.ct.exi.main.api.sax.EXISource;
import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Scanner;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.daffodil.api.CodeGenerator;
import org.apache.daffodil.api.Daffodil;
import org.apache.daffodil.api.DataProcessor;
import org.apache.daffodil.api.UnparseResult;
import org.apache.daffodil.api.WithDiagnostics;
import org.apache.daffodil.api.debugger.DaffodilDebuggerRunner;
import org.apache.daffodil.api.debugger.Debugger;
import org.apache.daffodil.api.exceptions.InvalidParserException;
import org.apache.daffodil.cli.CLIConf;
import org.apache.daffodil.cli.CLIConf$exi$;
import org.apache.daffodil.cli.CLIConf$generate$c$;
import org.apache.daffodil.cli.CLIConf$parse$;
import org.apache.daffodil.cli.CLIConf$performance$;
import org.apache.daffodil.cli.CLIConf$save$;
import org.apache.daffodil.cli.CLIConf$test$;
import org.apache.daffodil.cli.CLIConf$unparse$;
import org.apache.daffodil.cli.EXIErrorHandler;
import org.apache.daffodil.cli.EXIInfosetHandler$;
import org.apache.daffodil.cli.InfosetHandler;
import org.apache.daffodil.cli.InfosetParseResult;
import org.apache.daffodil.cli.InfosetType$;
import org.apache.daffodil.cli.Main$;
import org.apache.daffodil.cli.Main$ExitCode$;
import org.apache.daffodil.cli.debugger.CLIDebuggerRunner;
import org.apache.daffodil.core.compiler.Compiler;
import org.apache.daffodil.core.compiler.Compiler$;
import org.apache.daffodil.core.compiler.ProcessorFactory;
import org.apache.daffodil.io.DataDumper;
import org.apache.daffodil.io.FormatInfo;
import org.apache.daffodil.io.InputSourceDataInputStream;
import org.apache.daffodil.io.InputSourceDataInputStream$;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.exceptions.NotYetImplementedException;
import org.apache.daffodil.lib.exceptions.UnsuppressableException;
import org.apache.daffodil.lib.externalvars.Binding;
import org.apache.daffodil.lib.iapi.DaffodilConfig;
import org.apache.daffodil.lib.iapi.DaffodilConfig$;
import org.apache.daffodil.lib.iapi.DaffodilSchemaSource;
import org.apache.daffodil.lib.iapi.DaffodilTunables;
import org.apache.daffodil.lib.iapi.DaffodilTunables$;
import org.apache.daffodil.lib.iapi.URISchemaSource;
import org.apache.daffodil.lib.schema.annotation.props.gen.BitOrder;
import org.apache.daffodil.lib.util.Logger$;
import org.apache.daffodil.lib.util.MaybeULong$;
import org.apache.daffodil.lib.util.Misc$;
import org.apache.daffodil.lib.util.Timer$;
import org.apache.daffodil.lib.xml.NS;
import org.apache.daffodil.lib.xml.RefQName;
import org.apache.daffodil.lib.xml.RefQName$;
import org.apache.daffodil.runtime1.externalvars.ExternalVariablesLoader$;
import org.apache.daffodil.runtime1.iapi.DFDL;
import org.apache.daffodil.runtime1.processors.DataLoc;
import org.apache.daffodil.slf4j.DaffodilLogger;
import org.apache.daffodil.tdml.Runner;
import org.apache.daffodil.tdml.Runner$;
import org.apache.daffodil.tdml.TDMLTestNotCompatibleException;
import org.apache.daffodil.tdml.TestCase;
import org.rogach.scallop.ScallopConfBase;
import org.rogach.scallop.ScallopOption;
import org.slf4j.event.Level;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Queue;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;
import scala.util.Using;
import scala.util.Using$;
import scala.util.control.ControlThrowable;
import scala.util.matching.Regex;

public class Main {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(Main.class.getDeclaredField("daffodilLogger$lzy1"));
    private final InputStream STDIN;
    private final PrintStream STDOUT;
    private final PrintStream STDERR;
    private final scala.collection.immutable.Seq traceCommands;
    private volatile Object daffodilLogger$lzy1;

    public static Path blobDir() {
        return Main$.MODULE$.blobDir();
    }

    public static String blobSuffix() {
        return Main$.MODULE$.blobSuffix();
    }

    public static void main(String[] stringArray) {
        Main$.MODULE$.main(stringArray);
    }

    public static InputStream $lessinit$greater$default$1() {
        return Main$.MODULE$.$lessinit$greater$default$1();
    }

    public static PrintStream $lessinit$greater$default$2() {
        return Main$.MODULE$.$lessinit$greater$default$2();
    }

    public static PrintStream $lessinit$greater$default$3() {
        return Main$.MODULE$.$lessinit$greater$default$3();
    }

    public Main(InputStream STDIN, PrintStream STDOUT, PrintStream STDERR) {
        this.STDIN = STDIN;
        this.STDOUT = STDOUT;
        this.STDERR = STDERR;
        this.traceCommands = (scala.collection.immutable.Seq)((SeqOps)new .colon.colon((Object)"display info parser", (List)new .colon.colon((Object)"display info data", (List)new .colon.colon((Object)"display info infoset", (List)new .colon.colon((Object)"display info diff", (List)new .colon.colon((Object)"trace", (List)Nil$.MODULE$))))));
    }

    public scala.collection.immutable.Seq<String> traceCommands() {
        return this.traceCommands;
    }

    public String indent(String str, int pad) {
        Object[] lines = str.split("\n");
        String prefix = StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), pad);
        Object object = Predef$.MODULE$.refArrayOps(lines);
        Object[] indented = (String[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$2 -> prefix + _$2, ClassTag$.MODULE$.apply(String.class));
        return Predef$.MODULE$.wrapRefArray(indented).mkString("\n");
    }

    public scala.collection.immutable.Seq<Binding> overrideBindings(scala.collection.immutable.Seq<Binding> bindings, scala.collection.immutable.Seq<Binding> bindingsToOverride) {
        scala.collection.immutable.Seq inBoth = (scala.collection.immutable.Seq)((SeqOps)bindings.intersect(bindingsToOverride)).distinct();
        scala.collection.immutable.Seq bindingsMinusBoth = (scala.collection.immutable.Seq)bindings.diff((Seq)inBoth);
        scala.collection.immutable.Seq bindingsToOverrideMinusBoth = (scala.collection.immutable.Seq)bindingsToOverride.diff((Seq)inBoth);
        scala.collection.immutable.Seq bindingsWithCorrectValues = (scala.collection.immutable.Seq)bindings.filter((Function1 & Serializable)b -> inBoth.exists((Function1 & Serializable)p -> b.hashCode() == p.hashCode()));
        scala.collection.immutable.Seq bindingsMinusUpdates = (scala.collection.immutable.Seq)bindingsToOverrideMinusBoth.$plus$plus$colon((IterableOnce)bindingsMinusBoth);
        scala.collection.immutable.Seq bindingsWithUpdates = (scala.collection.immutable.Seq)bindingsWithCorrectValues.$plus$plus$colon((IterableOnce)bindingsMinusUpdates);
        return bindingsWithUpdates;
    }

    public void displayDiagnostics(WithDiagnostics pr) {
        pr.getDiagnostics().forEach(d -> {
            if (d.isError()) {
                Logger LoggerImpl_this = Logger$.MODULE$.log();
                if (LoggerImpl_this.underlying().isErrorEnabled()) {
                    LoggerImpl_this.underlying().error(d.toString());
                    return;
                }
                return;
            }
            Logger LoggerImpl_this = Logger$.MODULE$.log();
            if (LoggerImpl_this.underlying().isWarnEnabled()) {
                LoggerImpl_this.underlying().warn(d.toString());
                return;
            }
        });
    }

    public scala.collection.immutable.Seq<Binding> combineExternalVariables(Map<String, String> vars, Option<DaffodilConfig> optDafConfig) {
        scala.collection.immutable.Seq configFileVars = (scala.collection.immutable.Seq)optDafConfig.map((Function1 & Serializable)_$3 -> _$3.externalVariableBindings()).getOrElse(Main::$anonfun$4);
        Queue individualVars = ExternalVariablesLoader$.MODULE$.mapToBindings(CollectionConverters$.MODULE$.MapHasAsJava(vars).asJava());
        scala.collection.immutable.Seq<Binding> bindings = this.overrideBindings((scala.collection.immutable.Seq<Binding>)individualVars, (scala.collection.immutable.Seq<Binding>)configFileVars);
        return bindings;
    }

    public Option<DataProcessor> createProcessorFromParser(File savedParser, Option<String> path, Tuple2<String, Option<URI>> validate) {
        None$ none$;
        block8: {
            try {
                Compiler compiler = Compiler$.MODULE$.apply(Compiler$.MODULE$.apply$default$1());
                DataProcessor processor = (DataProcessor)Timer$.MODULE$.getResult("reloading", () -> Main.$anonfun$5(compiler, savedParser));
                if (!processor.isError()) {
                    Tuple2<String, Option<URI>> tuple2;
                    Logger LoggerImpl_this = Logger$.MODULE$.log();
                    if (LoggerImpl_this.underlying().isDebugEnabled()) {
                        Logger LoggerImpl_this2;
                        org.apache.daffodil.runtime1.processors.DataProcessor processorImpl = (org.apache.daffodil.runtime1.processors.DataProcessor)processor;
                        Logger LoggerImpl_this3 = Logger$.MODULE$.log();
                        if (LoggerImpl_this3.underlying().isDebugEnabled()) {
                            LoggerImpl_this3.underlying().debug("Parser = {}", (Object)processorImpl.ssrd().parser().toString());
                        }
                        if ((LoggerImpl_this2 = Logger$.MODULE$.log()).underlying().isDebugEnabled()) {
                            LoggerImpl_this2.underlying().debug("Unparser = {}", (Object)processorImpl.ssrd().unparser().toString());
                        }
                    }
                    if ((tuple2 = validate) == null) {
                        throw new MatchError(tuple2);
                    }
                    String validationKind = (String)tuple2._1();
                    Option validationConfig = (Option)tuple2._2();
                    Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)validationKind, (Object)validationConfig);
                    String validationKind2 = (String)tuple22._1();
                    Option validationConfig2 = (Option)tuple22._2();
                    none$ = Some$.MODULE$.apply((Object)processor.withValidation(validationKind2, (URL)validationConfig2.map((Function1 & Serializable)_$4 -> _$4.toURL()).getOrElse(Main::createProcessorFromParser$$anonfun$2)));
                    break block8;
                }
                none$ = None$.MODULE$;
            }
            catch (InvalidParserException e) {
                Logger LoggerImpl_this = Logger$.MODULE$.log();
                if (LoggerImpl_this.underlying().isErrorEnabled()) {
                    LoggerImpl_this.underlying().error(e.getMessage());
                }
                none$ = None$.MODULE$;
            }
        }
        return none$;
    }

    public DataProcessor withDebugOrTrace(DataProcessor proc, ScallopOption<Object> traceArg, ScallopOption<Option<String>> debugArg) {
        boolean bl;
        boolean bl2 = bl = BoxesRunTime.unboxToBoolean((Object)traceArg.apply()) || debugArg.isDefined();
        if (bl) {
            Debugger id = this.getTraceOrCLIDebugger(traceArg, debugArg);
            return proc.withDebugger(id);
        }
        if (!bl) {
            return proc;
        }
        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
    }

    private Debugger getTraceOrCLIDebugger(ScallopOption<Object> trace, ScallopOption<Option<String>> debug) {
        Option option;
        Logger LoggerImpl_this;
        if (BoxesRunTime.unboxToBoolean((Object)trace.apply())) {
            return Daffodil.newTraceDebugger((PrintStream)this.STDOUT);
        }
        if (System.console() == null && (LoggerImpl_this = Logger$.MODULE$.log()).underlying().isWarnEnabled()) {
            LoggerImpl_this.underlying().warn("Using --debug on a non-interactive console may result in display issues");
        }
        if ((option = (Option)debug.apply()) instanceof Some) {
            String f = (String)((Some)option).value();
            return Daffodil.newDaffodilDebugger((DaffodilDebuggerRunner)new CLIDebuggerRunner(new File(f), this.STDIN, this.STDOUT));
        }
        if (None$.MODULE$.equals(option)) {
            return Daffodil.newDaffodilDebugger((DaffodilDebuggerRunner)new CLIDebuggerRunner(this.STDIN, this.STDOUT));
        }
        throw new MatchError((Object)option);
    }

    public Option<DataProcessor> createProcessorFromSchema(URISchemaSource schemaSource, Option<RefQName> rootNS, Option<String> path, Map<String, String> tunablesMap, Tuple2<String, Option<URI>> validate) {
        RefQName refQName;
        Compiler compiler;
        Compiler c = Compiler$.MODULE$.apply(Compiler$.MODULE$.apply$default$1()).withTunables(tunablesMap);
        Option<RefQName> option = rootNS;
        if (None$.MODULE$.equals(option)) {
            compiler = c;
        } else if (option instanceof Some && (refQName = (RefQName)((Some)option).value()) != null) {
            RefQName refQName2 = RefQName$.MODULE$.unapply(refQName);
            Option option2 = refQName2._1();
            String string = refQName2._2();
            NS nS = refQName2._3();
            String root = string;
            NS ns = nS;
            compiler = c.withDistinguishedRootNode(root, ns.toStringOrNullIfNoNS());
        } else {
            throw new MatchError(option);
        }
        Compiler compiler2 = compiler;
        Option res = (Option)Timer$.MODULE$.getResult("compiling", () -> this.$anonfun$6(compiler2, schemaSource, validate, path));
        return res;
    }

    public Option<CodeGenerator> createGeneratorFromSchema(URISchemaSource schemaSource, Option<RefQName> rootNS, Map<String, String> tunables, String language) {
        RefQName refQName;
        Compiler compiler;
        Compiler c = Compiler$.MODULE$.apply(Compiler$.MODULE$.apply$default$1()).withTunables(tunables);
        Option<RefQName> option = rootNS;
        if (None$.MODULE$.equals(option)) {
            compiler = c;
        } else if (option instanceof Some && (refQName = (RefQName)((Some)option).value()) != null) {
            RefQName refQName2 = RefQName$.MODULE$.unapply(refQName);
            Option option2 = refQName2._1();
            String string = refQName2._2();
            NS nS = refQName2._3();
            String root = string;
            NS ns = nS;
            compiler = c.withDistinguishedRootNode(root, ns.toStringOrNullIfNoNS());
        } else {
            throw new MatchError(option);
        }
        Compiler compiler2 = compiler;
        Option cg = (Option)Timer$.MODULE$.getResult("compiling", () -> this.$anonfun$10(compiler2, schemaSource, language));
        return cg;
    }

    public DaffodilLogger daffodilLogger() {
        Object object = this.daffodilLogger$lzy1;
        if (object instanceof DaffodilLogger) {
            return (DaffodilLogger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (DaffodilLogger)this.daffodilLogger$lzyINIT1();
    }

    private Object daffodilLogger$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.daffodilLogger$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    DaffodilLogger daffodilLogger = null;
                    try {
                        daffodilLogger = (DaffodilLogger)Logger$.MODULE$.log().underlying();
                        object2 = daffodilLogger == null ? LazyVals.NullValue$.MODULE$ : daffodilLogger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.daffodilLogger$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return daffodilLogger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public void setLogLevel(int verbose) {
        int n = verbose;
        Level verboseLevel = switch (n) {
            case 0 -> Level.WARN;
            case 1 -> Level.INFO;
            case 2 -> Level.DEBUG;
            default -> Level.TRACE;
        };
        this.daffodilLogger().setThreadLoggerConfig(verboseLevel, this.STDERR);
    }

    public Enumeration.Value runIgnoreExceptions(String[] arguments) {
        Enumeration.Value value;
        block95: {
            block93: {
                InputStream inputStream;
                OutputStream output;
                Enumeration.Value rc;
                block103: {
                    Tuple2 tuple2;
                    block101: {
                        boolean bl;
                        block104: {
                            boolean bl2;
                            Some exiFactory;
                            InputSource input;
                            block102: {
                                Some some;
                                InputStream inputStream2;
                                WritableByteChannel writableByteChannel;
                                ScallopConfBase scallopConfBase;
                                CLIConf conf;
                                block100: {
                                    Enumeration.Value rc2;
                                    Enumeration.Value value2;
                                    block99: {
                                        Runner runner;
                                        block98: {
                                            Enumeration.Value rc3;
                                            Enumeration.Value value3;
                                            WritableByteChannel writableByteChannel2;
                                            block97: {
                                                Enumeration.Value value4;
                                                InputStream inputStream3;
                                                OutputStream outputStream;
                                                Option<DataProcessor> option;
                                                block96: {
                                                    Enumeration.Value rc4;
                                                    Enumeration.Value value5;
                                                    Option processor;
                                                    Option<DataProcessor> option2;
                                                    block94: {
                                                        Enumeration.Value rc5;
                                                        Enumeration.Value value6;
                                                        Option processor2;
                                                        Option<DataProcessor> option3;
                                                        conf = new CLIConf(arguments, this.STDOUT, this.STDERR);
                                                        this.setLogLevel(BoxesRunTime.unboxToInt((Object)conf.verbose().apply()));
                                                        Option option4 = conf.subcommand();
                                                        if (!(option4 instanceof Some)) break block93;
                                                        scallopConfBase = (ScallopConfBase)((Some)option4).value();
                                                        if (!conf.parse().equals(scallopConfBase)) break block94;
                                                        CLIConf$parse$ parseOpts = conf.parse();
                                                        Tuple2 validate = (Tuple2)parseOpts.validate().apply();
                                                        Option optDafConfig = parseOpts.config().toOption().map((Function1 & Serializable)_$6 -> DaffodilConfig$.MODULE$.fromFile(_$6));
                                                        if (parseOpts.parser().isDefined()) {
                                                            option3 = this.createProcessorFromParser((File)parseOpts.parser().apply(), (Option<String>)parseOpts.path().toOption(), (Tuple2<String, Option<URI>>)validate);
                                                        } else {
                                                            Map tunables = DaffodilTunables$.MODULE$.configPlusMoreTunablesMap(parseOpts.tunables(), optDafConfig);
                                                            option3 = this.createProcessorFromSchema((URISchemaSource)parseOpts.schema().apply(), (Option<RefQName>)parseOpts.rootNS().toOption(), (Option<String>)parseOpts.path().toOption(), (Map<String, String>)tunables, (Tuple2<String, Option<URI>>)validate);
                                                        }
                                                        Option option5 = processor2 = option3.map((Function1 & Serializable)p -> ((DFDL.DataProcessor)p).withExternalVariables(this.combineExternalVariables((Map<String, String>)parseOpts.vars(), (Option<DaffodilConfig>)optDafConfig))).map((Function1 & Serializable)_$7 -> this.withDebugOrTrace((DataProcessor)_$7, parseOpts.trace(), parseOpts.debug()));
                                                        if (None$.MODULE$.equals(option5)) {
                                                            value6 = Main$ExitCode$.MODULE$.UnableToCreateProcessor();
                                                        } else if (option5 instanceof Some) {
                                                            InputSourceDataInputStream inputSourceDataInputStream;
                                                            DataProcessor processor3 = (DataProcessor)((Some)option5).value();
                                                            if (processor3.isError()) {
                                                                throw Assert$.MODULE$.abort("Invariant broken: processor.isError().unary_!");
                                                            }
                                                            Option option6 = parseOpts.infile().toOption();
                                                            if (option6 instanceof Some && "-".equals(((Some)option6).value()) || None$.MODULE$.equals(option6)) {
                                                                inputSourceDataInputStream = InputSourceDataInputStream$.MODULE$.apply(this.STDIN);
                                                            } else if (option6 instanceof Some) {
                                                                long size;
                                                                String file = (String)((Some)option6).value();
                                                                Path path = Paths.get(file, new String[0]);
                                                                Object optSize = Files.isRegularFile(path, new LinkOption[0]) ? Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)Files.size(path))) : None$.MODULE$;
                                                                None$ none$ = optSize;
                                                                if (none$ instanceof Some && (size = BoxesRunTime.unboxToLong((Object)((Some)none$).value())) <= Integer.MAX_VALUE) {
                                                                    FileChannel fc = FileChannel.open(path, StandardOpenOption.READ);
                                                                    MappedByteBuffer bb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, size);
                                                                    fc.close();
                                                                    inputSourceDataInputStream = InputSourceDataInputStream$.MODULE$.apply((ByteBuffer)bb);
                                                                } else {
                                                                    InputStream is = Files.newInputStream(path, StandardOpenOption.READ);
                                                                    inputSourceDataInputStream = InputSourceDataInputStream$.MODULE$.apply(is);
                                                                }
                                                            } else {
                                                                throw new MatchError((Object)option6);
                                                            }
                                                            InputSourceDataInputStream input2 = inputSourceDataInputStream;
                                                            value6 = (Enumeration.Value)Using$.MODULE$.resource((Object)input2, (Function1 & Serializable)inStream -> {
                                                                OutputStream outputStream;
                                                                Option option = parseOpts.output().toOption();
                                                                if (option instanceof Some && "-".equals(((Some)option).value()) || None$.MODULE$.equals(option)) {
                                                                    outputStream = this.STDOUT;
                                                                } else if (option instanceof Some) {
                                                                    String file = (String)((Some)option).value();
                                                                    outputStream = new FileOutputStream(file);
                                                                } else {
                                                                    throw new MatchError((Object)option);
                                                                }
                                                                PrintStream output = outputStream;
                                                                InfosetHandler infosetHandler = InfosetType$.MODULE$.getInfosetHandler((Enumeration.Value)parseOpts.infosetType().apply(), processor3, (Option<URI>)parseOpts.schema().map((Function1 & Serializable)_$8 -> _$8.uri()).toOption(), false);
                                                                long lastParseBitPosition = 0L;
                                                                boolean keepParsing = true;
                                                                Enumeration.Value exitCode = Main$ExitCode$.MODULE$.Success();
                                                                while (keepParsing) {
                                                                    Object object;
                                                                    String dataText;
                                                                    String string;
                                                                    String string2;
                                                                    InfosetParseResult infosetResult = (InfosetParseResult)Timer$.MODULE$.getResult("parsing", () -> Main.$anonfun$16(infosetHandler, inStream, output));
                                                                    DFDL.ParseResult parseResult = (DFDL.ParseResult)infosetResult.parseResult();
                                                                    FormatInfo finfo = (FormatInfo)((DFDL.Result)parseResult).resultState();
                                                                    DataLoc loc = (DataLoc)((DFDL.Result)parseResult).resultState().currentLocation();
                                                                    this.displayDiagnostics((WithDiagnostics)parseResult);
                                                                    if (((DFDL.Result)parseResult).isProcessingError() || ((DFDL.Result)parseResult).isValidationError()) {
                                                                        keepParsing = false;
                                                                        exitCode = Main$ExitCode$.MODULE$.ParseError();
                                                                        continue;
                                                                    }
                                                                    infosetResult.write(output);
                                                                    ((OutputStream)output).flush();
                                                                    if (!inStream.hasData()) {
                                                                        keepParsing = false;
                                                                        continue;
                                                                    }
                                                                    if (BoxesRunTime.unboxToBoolean((Object)parseOpts.stream().toOption().get())) {
                                                                        if (lastParseBitPosition == loc.bitPos0b()) {
                                                                            String remainingBits = MaybeULong$.MODULE$.isDefined$extension(loc.bitLimit0b()) ? BoxesRunTime.boxToLong((long)(MaybeULong$.MODULE$.get$extension(loc.bitLimit0b()) - loc.bitPos0b())).toString() : "at least " + inStream.inputSource().knownBytesAvailable() * 8L;
                                                                            Logger LoggerImpl_this = Logger$.MODULE$.log();
                                                                            if (LoggerImpl_this.underlying().isErrorEnabled()) {
                                                                                LoggerImpl_this.underlying().error("Left over data after consuming 0 bits while streaming. Stopped after consuming {} bit(s) with {} bit(s) remaining.", (Object[])Arrays$.MODULE$.seqToArray((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{BoxesRunTime.boxToLong((long)loc.bitPos0b()), remainingBits}), Object.class));
                                                                            }
                                                                            keepParsing = false;
                                                                            exitCode = Main$ExitCode$.MODULE$.LeftOverData();
                                                                            continue;
                                                                        }
                                                                        lastParseBitPosition = loc.bitPos0b();
                                                                        keepParsing = true;
                                                                        ((OutputStream)output).write(0);
                                                                        continue;
                                                                    }
                                                                    DataDumper Dump = new DataDumper();
                                                                    int bitsAlreadyConsumed = (int)(loc.bitPos0b() % 8L);
                                                                    if (bitsAlreadyConsumed != 0) {
                                                                        String dumpString;
                                                                        int bitsToDisplay = 8 - bitsAlreadyConsumed;
                                                                        long pbp = inStream.inputSource().position() + 1L;
                                                                        byte[] firstByteBitArray = inStream.getByteArray(bitsToDisplay, finfo);
                                                                        String fbs = StringOps$.MODULE$.reverse$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.padTo$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.reverse$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.takeRight$extension(Predef$.MODULE$.augmentString(RichInt$.MODULE$.toBinaryString$extension(Predef$.MODULE$.intWrapper((int)firstByteBitArray[0]))), 8)))), 8, '0')));
                                                                        BitOrder bitOrder = finfo.bitOrder();
                                                                        BitOrder.MostSignificantBitFirst$ mostSignificantBitFirst$ = BitOrder.MostSignificantBitFirst$.MODULE$;
                                                                        String bits = !(bitOrder != null ? !bitOrder.equals(mostSignificantBitFirst$) : mostSignificantBitFirst$ != null) ? StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("x"), bitsAlreadyConsumed) + StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(fbs), bitsAlreadyConsumed) : StringOps$.MODULE$.takeRight$extension(Predef$.MODULE$.augmentString(fbs), bitsToDisplay) + StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("x"), bitsAlreadyConsumed);
                                                                        string2 = dumpString = StringOps$.MODULE$.format$extension("\nLeft over data starts with partial byte. Left over data (Binary) at byte %s is: (0b%s)", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)pbp), bits}));
                                                                    } else {
                                                                        string2 = "";
                                                                    }
                                                                    String firstByteString = string2;
                                                                    long curBytePosition1b = inStream.inputSource().position() + 1L;
                                                                    long bytesAvailable = inStream.inputSource().knownBytesAvailable();
                                                                    int bytesLimit = (int)package$.MODULE$.min(8L, bytesAvailable);
                                                                    byte[] destArray = new byte[bytesLimit];
                                                                    boolean destArrayFilled = inStream.inputSource().get(destArray, 0, bytesLimit);
                                                                    if (destArrayFilled) {
                                                                        DataDumper.TextOnly textOnly = Dump.TextOnly().apply((Option)Some$.MODULE$.apply((Object)"utf-8"));
                                                                        int n = destArray.length * 8;
                                                                        ByteBuffer byteBuffer = ByteBuffer.wrap(destArray);
                                                                        int n2 = Dump.dump$default$5();
                                                                        Option option2 = Dump.dump$default$7();
                                                                        string = Dump.dump((DataDumper.Kind)textOnly, 0L, n, byteBuffer, n2, false, option2).mkString("\n");
                                                                    } else {
                                                                        string = "";
                                                                    }
                                                                    String dumpString = string;
                                                                    String string3 = dataText = destArrayFilled ? "\nLeft over data (UTF-8) starting at byte " + curBytePosition1b + " is: (" + dumpString + "...)" : "";
                                                                    if (destArrayFilled) {
                                                                        Object object2 = Predef$.MODULE$.byteArrayOps(destArray);
                                                                        object = "\nLeft over data (Hex) starting at byte " + curBytePosition1b + " is: (0x" + Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object2, (Function1 & Serializable)a -> StringOps$.MODULE$.format$extension("%02x", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToByte((Object)a))})), ClassTag$.MODULE$.apply(String.class))).mkString() + "...)";
                                                                    } else {
                                                                        object = "";
                                                                    }
                                                                    String dataHex = object;
                                                                    String remainingBits = MaybeULong$.MODULE$.isDefined$extension(loc.bitLimit0b()) ? BoxesRunTime.boxToLong((long)(MaybeULong$.MODULE$.get$extension(loc.bitLimit0b()) - loc.bitPos0b())).toString() : "at least " + bytesAvailable * 8L;
                                                                    String leftOverDataMessage = "Left over data. Consumed " + loc.bitPos0b() + " bit(s) with " + remainingBits + " bit(s) remaining." + firstByteString + dataHex + dataText;
                                                                    Logger LoggerImpl_this = Logger$.MODULE$.log();
                                                                    if (LoggerImpl_this.underlying().isErrorEnabled()) {
                                                                        LoggerImpl_this.underlying().error(leftOverDataMessage);
                                                                    }
                                                                    keepParsing = false;
                                                                    exitCode = Main$ExitCode$.MODULE$.LeftOverData();
                                                                }
                                                                return exitCode;
                                                            }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
                                                        } else {
                                                            throw new MatchError((Object)option5);
                                                        }
                                                        value = rc5 = value6;
                                                        break block95;
                                                    }
                                                    if (!conf.performance().equals(scallopConfBase)) break block96;
                                                    CLIConf$performance$ performanceOpts = conf.performance();
                                                    Tuple2 validate = (Tuple2)performanceOpts.validate().apply();
                                                    Option optDafConfig = performanceOpts.config().toOption().map((Function1 & Serializable)_$9 -> DaffodilConfig$.MODULE$.fromFile(_$9));
                                                    if (performanceOpts.parser().isDefined()) {
                                                        option2 = this.createProcessorFromParser((File)performanceOpts.parser().apply(), (Option<String>)performanceOpts.path().toOption(), (Tuple2<String, Option<URI>>)validate);
                                                    } else {
                                                        Map tunables = DaffodilTunables$.MODULE$.configPlusMoreTunablesMap(performanceOpts.tunables(), optDafConfig);
                                                        option2 = this.createProcessorFromSchema((URISchemaSource)performanceOpts.schema().apply(), (Option<RefQName>)performanceOpts.rootNS().toOption(), (Option<String>)performanceOpts.path().toOption(), (Map<String, String>)tunables, (Tuple2<String, Option<URI>>)validate);
                                                    }
                                                    Option option7 = processor = option2.map((Function1 & Serializable)p -> ((DFDL.DataProcessor)p).withExternalVariables(this.combineExternalVariables((Map<String, String>)performanceOpts.vars(), (Option<DaffodilConfig>)optDafConfig)));
                                                    if (None$.MODULE$.equals(option7)) {
                                                        value5 = Main$ExitCode$.MODULE$.UnableToCreateProcessor();
                                                    } else if (option7 instanceof Some) {
                                                        scala.collection.immutable.Seq seq;
                                                        Object[] objectArray;
                                                        DFDL.DataProcessor processor4 = (DFDL.DataProcessor)((Some)option7).value();
                                                        File infile = new File((String)performanceOpts.infile().apply());
                                                        if (infile.isDirectory()) {
                                                            Object object = Predef$.MODULE$.refArrayOps((Object[])infile.listFiles());
                                                            objectArray = (File[])ArrayOps$.MODULE$.filter$extension(object, (Function1 & Serializable)_$10 -> !_$10.isDirectory());
                                                        } else {
                                                            objectArray = new File[]{infile};
                                                        }
                                                        Object[] files = objectArray;
                                                        InfosetHandler infosetHandler = InfosetType$.MODULE$.getInfosetHandler((Enumeration.Value)performanceOpts.infosetType().apply(), (DataProcessor)processor4, (Option<URI>)performanceOpts.schema().map((Function1 & Serializable)_$11 -> _$11.uri()).toOption(), true);
                                                        boolean isUnparse = BoxesRunTime.unboxToBoolean((Object)performanceOpts.unparse().apply());
                                                        Object object = Predef$.MODULE$.refArrayOps(files);
                                                        Object[] dataArray = (Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)filePath -> {
                                                            FileInputStream input = new FileInputStream((File)filePath);
                                                            long dataSize = filePath.length();
                                                            byte[] bytes = new byte[(int)dataSize];
                                                            input.read(bytes);
                                                            byte[] data = isUnparse ? (Object)infosetHandler.dataToInfoset(bytes) : bytes;
                                                            return data;
                                                        }, ClassTag$.MODULE$.apply(Object.class));
                                                        ConcurrentLinkedQueue inputQueue = new ConcurrentLinkedQueue();
                                                        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), BoxesRunTime.unboxToInt((Object)performanceOpts.number().apply())).foreach((Function1)(JFunction1.mcZI.sp & Serializable)n -> {
                                                            int index = n % dataArray.length;
                                                            return inputQueue.add(dataArray[index]);
                                                        });
                                                        WritableByteChannel nullChannelForUnparse = Channels.newChannel((OutputStream)NullOutputStream.INSTANCE);
                                                        NullOutputStream nullOutputStreamForParse = NullOutputStream.INSTANCE;
                                                        long totalTimeStart = System.nanoTime();
                                                        IndexedSeq tasks = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), BoxesRunTime.unboxToInt((Object)performanceOpts.threads().apply())).map((Function1 & Serializable)id -> Future$.MODULE$.apply(() -> Main.$anonfun$24$$anonfun$1(inputQueue, isUnparse, infosetHandler, nullChannelForUnparse, nullOutputStreamForParse), ExecutionContext.Implicits$.MODULE$.global()));
                                                        try {
                                                            seq = (scala.collection.immutable.Seq)tasks.map((Function1 & Serializable)_$12 -> (Tuple2)Await$.MODULE$.result((Awaitable)_$12, (Duration)Duration$.MODULE$.Inf()));
                                                        }
                                                        catch (Exception exception) {
                                                            seq = (scala.collection.immutable.Seq)((SeqOps)Nil$.MODULE$);
                                                        }
                                                        scala.collection.immutable.Seq results = seq;
                                                        long totalTimeEnd = System.nanoTime();
                                                        if (results.length() == 0) {
                                                            Logger LoggerImpl_this = Logger$.MODULE$.log();
                                                            if (LoggerImpl_this.underlying().isErrorEnabled()) {
                                                                LoggerImpl_this.underlying().error("one or more files failed to parse/unparse");
                                                            }
                                                            value5 = Main$ExitCode$.MODULE$.PerformanceTestError();
                                                        } else {
                                                            String string;
                                                            boolean bl3 = BoxesRunTime.unboxToBoolean((Object)performanceOpts.unparse().apply());
                                                            if (bl3) {
                                                                string = "unparse";
                                                            } else if (!bl3) {
                                                                string = "parse";
                                                            } else {
                                                                throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl3));
                                                            }
                                                            String action = string;
                                                            Tuple2 tuple22 = (Tuple2)results.reduce((Function2 & Serializable)(x$1, x$2) -> {
                                                                Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                                                                if (tuple2 != null) {
                                                                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                                                                    Tuple2 tuple23 = (Tuple2)tuple2._2();
                                                                    if (tuple22 != null) {
                                                                        long a1 = tuple22._1$mcJ$sp();
                                                                        long a2 = tuple22._2$mcJ$sp();
                                                                        if (tuple23 != null) {
                                                                            long b1 = tuple23._1$mcJ$sp();
                                                                            long b2 = tuple23._2$mcJ$sp();
                                                                            return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)(a1 + b1)), (Object)BoxesRunTime.boxToLong((long)(a2 + b2)));
                                                                        }
                                                                    }
                                                                }
                                                                throw new MatchError((Object)tuple2);
                                                            });
                                                            if (tuple22 == null) {
                                                                throw new MatchError((Object)tuple22);
                                                            }
                                                            long totalLatencyNS = tuple22._1$mcJ$sp();
                                                            long totalFiles = tuple22._2$mcJ$sp();
                                                            Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(totalLatencyNS, totalFiles);
                                                            long totalLatencyNS2 = sp2._1$mcJ$sp();
                                                            long totalFiles2 = sp2._2$mcJ$sp();
                                                            long totalTimeNS = totalTimeEnd - totalTimeStart;
                                                            double totalTimeSec = (double)totalTimeNS / (double)1000000000;
                                                            double averageThroughputFilesPerSec = (double)totalFiles2 / totalTimeSec;
                                                            double averageLatencyMS = (double)totalLatencyNS2 / (double)totalFiles2 / (double)1000000;
                                                            this.STDOUT.println(StringOps$.MODULE$.format$extension("total %s time (sec): %.3f", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{action, BoxesRunTime.boxToDouble((double)totalTimeSec)})));
                                                            this.STDOUT.println(StringOps$.MODULE$.format$extension("average throughput (files/sec): %.3f", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)averageThroughputFilesPerSec)})));
                                                            this.STDOUT.println(StringOps$.MODULE$.format$extension("average latency (ms): %.3f", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)averageLatencyMS)})));
                                                            value5 = Main$ExitCode$.MODULE$.Success();
                                                        }
                                                    } else {
                                                        throw new MatchError((Object)option7);
                                                    }
                                                    value = rc4 = value5;
                                                    break block95;
                                                }
                                                if (!conf.unparse().equals(scallopConfBase)) break block97;
                                                CLIConf$unparse$ unparseOpts = conf.unparse();
                                                Tuple2 validate = (Tuple2)unparseOpts.validate().apply();
                                                Option optDafConfig = unparseOpts.config().toOption().map((Function1 & Serializable)_$13 -> DaffodilConfig$.MODULE$.fromFile(_$13));
                                                if (unparseOpts.parser().isDefined()) {
                                                    option = this.createProcessorFromParser((File)unparseOpts.parser().apply(), (Option<String>)unparseOpts.path().toOption(), (Tuple2<String, Option<URI>>)validate);
                                                } else {
                                                    Map tunables = DaffodilTunables$.MODULE$.configPlusMoreTunablesMap(unparseOpts.tunables(), optDafConfig);
                                                    option = this.createProcessorFromSchema((URISchemaSource)unparseOpts.schema().apply(), (Option<RefQName>)unparseOpts.rootNS().toOption(), (Option<String>)unparseOpts.path().toOption(), (Map<String, String>)tunables, (Tuple2<String, Option<URI>>)validate);
                                                }
                                                Option processor = option.map((Function1 & Serializable)p -> ((DFDL.DataProcessor)p).withExternalVariables(this.combineExternalVariables((Map<String, String>)unparseOpts.vars(), (Option<DaffodilConfig>)optDafConfig))).map((Function1 & Serializable)_$14 -> this.withDebugOrTrace((DataProcessor)_$14, unparseOpts.trace(), unparseOpts.debug()));
                                                Option option8 = unparseOpts.output().toOption();
                                                if (option8 instanceof Some && "-".equals(((Some)option8).value()) || None$.MODULE$.equals(option8)) {
                                                    outputStream = this.STDOUT;
                                                } else if (option8 instanceof Some) {
                                                    String file = (String)((Some)option8).value();
                                                    outputStream = new FileOutputStream(file);
                                                } else {
                                                    throw new MatchError((Object)option8);
                                                }
                                                PrintStream output2 = outputStream;
                                                WritableByteChannel outChannel = Channels.newChannel(output2);
                                                Option option9 = unparseOpts.infile().toOption();
                                                if (option9 instanceof Some && "-".equals(((Some)option9).value()) || None$.MODULE$.equals(option9)) {
                                                    inputStream3 = this.STDIN;
                                                } else if (option9 instanceof Some) {
                                                    String fileName = (String)((Some)option9).value();
                                                    inputStream3 = new FileInputStream(fileName);
                                                } else {
                                                    throw new MatchError((Object)option9);
                                                }
                                                InputStream is = inputStream3;
                                                Option option10 = processor;
                                                if (None$.MODULE$.equals(option10)) {
                                                    value4 = Main$ExitCode$.MODULE$.UnableToCreateProcessor();
                                                } else if (option10 instanceof Some) {
                                                    None$ none$;
                                                    DataProcessor processor5 = (DataProcessor)((Some)option10).value();
                                                    if (processor5.isError()) {
                                                        throw Assert$.MODULE$.abort("Invariant broken: processor.isError().==(false)");
                                                    }
                                                    if (BoxesRunTime.unboxToBoolean((Object)unparseOpts.stream().toOption().get())) {
                                                        Scanner scnr = new Scanner(is);
                                                        scnr.useDelimiter("\u0000");
                                                        none$ = Some$.MODULE$.apply((Object)scnr);
                                                    } else {
                                                        none$ = None$.MODULE$;
                                                    }
                                                    None$ maybeScanner = none$;
                                                    boolean keepUnparsing = maybeScanner.isEmpty() || ((Scanner)maybeScanner.get()).hasNext();
                                                    Enumeration.Value exitCode = Main$ExitCode$.MODULE$.Success();
                                                    InfosetHandler infosetHandler = InfosetType$.MODULE$.getInfosetHandler((Enumeration.Value)unparseOpts.infosetType().apply(), processor5, (Option<URI>)unparseOpts.schema().map((Function1 & Serializable)_$15 -> _$15.uri()).toOption(), false);
                                                    while (keepUnparsing) {
                                                        Object object;
                                                        if (maybeScanner.isDefined()) {
                                                            byte[] bytes = ((Scanner)maybeScanner.get()).next().getBytes();
                                                            object = infosetHandler.dataToInfoset(bytes);
                                                        } else {
                                                            object = infosetHandler.dataToInfoset(is);
                                                        }
                                                        Object inputterData = object;
                                                        UnparseResult unparseResult = (UnparseResult)Timer$.MODULE$.getResult("unparsing", () -> Main.$anonfun$31(infosetHandler, inputterData, outChannel));
                                                        this.displayDiagnostics((WithDiagnostics)unparseResult);
                                                        if (unparseResult.isError()) {
                                                            keepUnparsing = false;
                                                            exitCode = Main$ExitCode$.MODULE$.UnparseError();
                                                            continue;
                                                        }
                                                        keepUnparsing = maybeScanner.isDefined() && ((Scanner)maybeScanner.get()).hasNext();
                                                    }
                                                    value4 = exitCode;
                                                } else {
                                                    throw new MatchError((Object)option10);
                                                }
                                                Enumeration.Value rc6 = value4;
                                                is.close();
                                                outChannel.close();
                                                value = rc6;
                                                break block95;
                                            }
                                            if (!conf.save().equals(scallopConfBase)) break block98;
                                            CLIConf$save$ saveOpts = conf.save();
                                            Tuple2 validate = Tuple2$.MODULE$.apply((Object)"off", (Object)None$.MODULE$);
                                            Option optDafConfig = saveOpts.config().toOption().map((Function1 & Serializable)_$16 -> DaffodilConfig$.MODULE$.fromFile(_$16));
                                            Map tunables = DaffodilTunables$.MODULE$.configPlusMoreTunablesMap(saveOpts.tunables(), optDafConfig);
                                            DaffodilTunables tunablesObj = DaffodilTunables$.MODULE$.apply(tunables);
                                            Option<DataProcessor> processor = this.createProcessorFromSchema((URISchemaSource)saveOpts.schema().apply(), (Option<RefQName>)saveOpts.rootNS().toOption(), (Option<String>)saveOpts.path().toOption(), (Map<String, String>)tunables, (Tuple2<String, Option<URI>>)validate);
                                            Option option = saveOpts.outfile().toOption();
                                            if (option instanceof Some && "-".equals(((Some)option).value()) || None$.MODULE$.equals(option)) {
                                                writableByteChannel2 = Channels.newChannel(this.STDOUT);
                                            } else if (option instanceof Some) {
                                                String file = (String)((Some)option).value();
                                                writableByteChannel2 = new FileOutputStream(file).getChannel();
                                            } else {
                                                throw new MatchError((Object)option);
                                            }
                                            WritableByteChannel output3 = writableByteChannel2;
                                            Option<DataProcessor> option11 = processor;
                                            if (option11 instanceof Some) {
                                                DataProcessor processor6 = (DataProcessor)((Some)option11).value();
                                                if (processor6.isError()) {
                                                    throw Assert$.MODULE$.abort("Invariant broken: processor.isError().==(false)");
                                                }
                                                Timer$.MODULE$.getResult("saving", (Function0 & Serializable)() -> {
                                                    Main.$anonfun$33(processor6, output3);
                                                    return BoxedUnit.UNIT;
                                                });
                                                value3 = Main$ExitCode$.MODULE$.Success();
                                            } else if (None$.MODULE$.equals(option11)) {
                                                value3 = Main$ExitCode$.MODULE$.UnableToCreateProcessor();
                                            } else {
                                                throw new MatchError(option11);
                                            }
                                            value = rc3 = value3;
                                            break block95;
                                        }
                                        if (!conf.test().equals(scallopConfBase)) break block99;
                                        CLIConf$test$ testOpts = conf.test();
                                        String tdmlFile = (String)testOpts.tdmlfile().apply();
                                        Option optTDMLImplementation = testOpts.implementation().toOption();
                                        Runner tdmlRunnerInit = Runner$.MODULE$.apply(tdmlFile, optTDMLImplementation);
                                        if (BoxesRunTime.unboxToBoolean((Object)testOpts.trace().apply()) || testOpts.debug().isDefined()) {
                                            Debugger db = this.getTraceOrCLIDebugger(testOpts.trace(), testOpts.debug());
                                            tdmlRunnerInit.setDebugger((Object)db);
                                            runner = tdmlRunnerInit;
                                        } else {
                                            runner = tdmlRunnerInit;
                                        }
                                        Runner tdmlRunner = runner;
                                        scala.collection.immutable.Seq tests = (scala.collection.immutable.Seq)((SeqOps)(testOpts.testnames().isDefined() ? ((List)testOpts.testnames().apply()).flatMap((Function1 & Serializable)testName -> {
                                            if (BoxesRunTime.unboxToBoolean((Object)testOpts.regex().apply())) {
                                                Regex regex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(testName));
                                                scala.collection.immutable.Seq matches = (scala.collection.immutable.Seq)tdmlRunner.testCases().filter((Function1 & Serializable)testCase -> regex.pattern().matcher(testCase.tcName()).matches());
                                                scala.collection.immutable.Seq seq = matches;
                                                scala.collection.immutable.Seq m = seq;
                                                if (!m.isEmpty()) {
                                                    return (scala.collection.immutable.Seq)m.map((Function1 & Serializable)testCase -> Tuple2$.MODULE$.apply((Object)testCase.tcName(), (Object)Some$.MODULE$.apply(testCase)));
                                                }
                                                return (scala.collection.immutable.Seq)((SeqOps)new .colon.colon((Object)Tuple2$.MODULE$.apply(testName, (Object)None$.MODULE$), (List)Nil$.MODULE$));
                                            }
                                            return (IterableOnce)new .colon.colon((Object)Tuple2$.MODULE$.apply(testName, (Object)tdmlRunner.testCases().find((Function1 & Serializable)_$17 -> {
                                                String string = _$17.tcName();
                                                String string2 = testName;
                                                return !(string != null ? !string.equals(string2) : string2 != null);
                                            })), (List)Nil$.MODULE$);
                                        }) : (scala.collection.immutable.Seq)tdmlRunner.testCases().map((Function1 & Serializable)test -> Tuple2$.MODULE$.apply((Object)test.tcName(), (Object)Some$.MODULE$.apply(test)))).distinct()).sortBy((Function1 & Serializable)_$18 -> (String)_$18._1(), (Ordering)Ordering.String$.MODULE$);
                                        tdmlRunner.reset();
                                        if (BoxesRunTime.unboxToBoolean((Object)testOpts.list().apply())) {
                                            if (BoxesRunTime.unboxToInt((Object)testOpts.info().apply()) > 0) {
                                                List headers = (List)new .colon.colon((Object)"Name", (List)new .colon.colon((Object)"Model", (List)new .colon.colon((Object)"Root", (List)new .colon.colon((Object)"Description", (List)Nil$.MODULE$))));
                                                List maxCols = (List)tests.foldLeft((Object)headers.map((Function1 & Serializable)_$19 -> _$19.length()), (Function2 & Serializable)(maxVals, testPair) -> {
                                                    Tuple2 tuple2 = testPair;
                                                    if (tuple2 != null) {
                                                        String string = (String)tuple2._1();
                                                        Option option = (Option)tuple2._2();
                                                        String name = string;
                                                        if (None$.MODULE$.equals(option)) {
                                                            return (List)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(BoxesRunTime.unboxToInt((Object)maxVals.apply(0))), name.length())), (List)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)maxVals.apply(1))), (List)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)maxVals.apply(2))), (List)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)maxVals.apply(3))), (List)Nil$.MODULE$))));
                                                        }
                                                        String name2 = string;
                                                        if (option instanceof Some) {
                                                            TestCase test = (TestCase)((Some)option).value();
                                                            return (List)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(BoxesRunTime.unboxToInt((Object)maxVals.apply(0))), name2.length())), (List)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(BoxesRunTime.unboxToInt((Object)maxVals.apply(1))), test.model().length())), (List)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(BoxesRunTime.unboxToInt((Object)maxVals.apply(2))), test.rootName().length())), (List)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(BoxesRunTime.unboxToInt((Object)maxVals.apply(3))), test.description().length())), (List)Nil$.MODULE$))));
                                                        }
                                                    }
                                                    throw new MatchError((Object)tuple2);
                                                });
                                                String formatStr = maxCols.map((Function1 & Serializable)max -> Main.$anonfun$40(BoxesRunTime.unboxToInt((Object)max))).mkString("  ");
                                                this.STDOUT.println(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(formatStr), (scala.collection.immutable.Seq)headers));
                                                tests.foreach((Function1)(JProcedure1 & Serializable)testPair -> {
                                                    Tuple2 tuple2 = testPair;
                                                    if (tuple2 != null) {
                                                        String string = (String)tuple2._1();
                                                        Option option = (Option)tuple2._2();
                                                        String name = string;
                                                        if (option instanceof Some) {
                                                            TestCase test = (TestCase)((Some)option).value();
                                                            this.STDOUT.println(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(formatStr), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{name, test.model(), test.rootName(), test.description()})));
                                                            return;
                                                        }
                                                        String name2 = string;
                                                        if (None$.MODULE$.equals(option)) {
                                                            this.STDOUT.println(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(formatStr), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{name2, "[Not Found]", "", ""})));
                                                            return;
                                                        }
                                                    }
                                                    throw new MatchError((Object)tuple2);
                                                });
                                            } else {
                                                tests.foreach((Function1)(JProcedure1 & Serializable)testPair -> {
                                                    Tuple2 tuple2 = testPair;
                                                    if (tuple2 != null) {
                                                        String string = (String)tuple2._1();
                                                        Option option = (Option)tuple2._2();
                                                        String name = string;
                                                        if (option instanceof Some) {
                                                            TestCase test = (TestCase)((Some)option).value();
                                                            this.STDOUT.println(name);
                                                            return;
                                                        }
                                                        String name2 = string;
                                                        if (None$.MODULE$.equals(option)) {
                                                            this.STDOUT.println(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s  [Not Found]"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{name2})));
                                                            return;
                                                        }
                                                    }
                                                    throw new MatchError((Object)tuple2);
                                                });
                                            }
                                            value = Main$ExitCode$.MODULE$.Success();
                                        } else {
                                            IntRef pass = IntRef.create((int)0);
                                            IntRef fail = IntRef.create((int)0);
                                            IntRef notfound = IntRef.create((int)0);
                                            tests.foreach((Function1)(JProcedure1 & Serializable)testPair -> {
                                                Tuple2 tuple2 = testPair;
                                                if (tuple2 != null) {
                                                    String string = (String)tuple2._1();
                                                    Option option = (Option)tuple2._2();
                                                    String name = string;
                                                    if (option instanceof Some) {
                                                        block10: {
                                                            TestCase test = (TestCase)((Some)option).value();
                                                            try {
                                                                test.run();
                                                                this.STDOUT.println(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("[Pass] %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{name})));
                                                                ++pass$1.elem;
                                                            }
                                                            catch (ControlThrowable s) {
                                                                throw s;
                                                            }
                                                            catch (UnsuppressableException u) {
                                                                throw u;
                                                            }
                                                            catch (TDMLTestNotCompatibleException e) {
                                                                this.STDOUT.println(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("[Skipped] %s (not compatible with implementation: %s)"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{name, e.implementation().getOrElse(Main::$anonfun$43$$anonfun$1)})));
                                                            }
                                                            catch (Throwable e) {
                                                                Throwable throwable = e.getCause();
                                                                if (throwable instanceof TDMLTestNotCompatibleException) {
                                                                    TDMLTestNotCompatibleException e2 = (TDMLTestNotCompatibleException)throwable;
                                                                    this.STDOUT.println(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("[Skipped] %s (not compatible with implementation: %s)"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{name, e2.implementation().getOrElse(Main::$anonfun$43$$anonfun$2)})));
                                                                }
                                                                this.STDOUT.println(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("[Fail] %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{name})));
                                                                ++fail$1.elem;
                                                                if (BoxesRunTime.unboxToInt((Object)testOpts.info().apply()) > 0) {
                                                                    this.STDOUT.println("  Failure Information:");
                                                                    this.STDOUT.println(this.indent(e.toString(), 4));
                                                                }
                                                                if (BoxesRunTime.unboxToInt((Object)testOpts.info().apply()) <= 1) break block10;
                                                                this.STDOUT.println("  Backtrace:");
                                                                Object object = Predef$.MODULE$.refArrayOps((Object[])e.getStackTrace());
                                                                ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)st -> this.STDOUT.println(this.indent(st.toString(), 4)));
                                                            }
                                                        }
                                                        return;
                                                    }
                                                    String name2 = string;
                                                    if (None$.MODULE$.equals(option)) {
                                                        this.STDOUT.println(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("[Not Found] %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{name2})));
                                                        ++notfound$1.elem;
                                                        return;
                                                    }
                                                }
                                                throw new MatchError((Object)tuple2);
                                            });
                                            this.STDOUT.println("");
                                            this.STDOUT.println(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Total: %d, Pass: %d, Fail: %d, Not Found: %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(pass.elem + fail.elem + notfound.elem)), BoxesRunTime.boxToInteger((int)pass.elem), BoxesRunTime.boxToInteger((int)fail.elem), BoxesRunTime.boxToInteger((int)notfound.elem)})));
                                            value = fail.elem == 0 && notfound.elem == 0 ? Main$ExitCode$.MODULE$.Success() : Main$ExitCode$.MODULE$.TestError();
                                        }
                                        break block95;
                                    }
                                    if (!conf.generate().equals(scallopConfBase)) break block100;
                                    Option option = conf.generate().subcommand();
                                    if (!(option instanceof Some) || !conf.generate().c().equals(((Some)option).value())) {
                                        throw Assert$.MODULE$.impossible(Assert$.MODULE$.impossible$default$1());
                                    }
                                    CLIConf$generate$c$ generateOpts = conf.generate().c();
                                    Option optDafConfig = generateOpts.config().toOption().map((Function1 & Serializable)_$20 -> DaffodilConfig$.MODULE$.fromFile(_$20));
                                    Map tunables = DaffodilTunables$.MODULE$.configPlusMoreTunablesMap(generateOpts.tunables(), optDafConfig);
                                    Option<CodeGenerator> generator = this.createGeneratorFromSchema((URISchemaSource)generateOpts.schema().apply(), (Option<RefQName>)generateOpts.rootNS().toOption(), (Map<String, String>)tunables, generateOpts.language());
                                    String outputDir = (String)generateOpts.outdir().toOption().getOrElse(Main::$anonfun$45);
                                    Option<CodeGenerator> option12 = generator;
                                    if (option12 instanceof Some) {
                                        CodeGenerator generator2 = (CodeGenerator)((Some)option12).value();
                                        Timer$.MODULE$.getResult("generating", () -> Main.$anonfun$46(generator2, outputDir));
                                        this.displayDiagnostics((WithDiagnostics)generator2);
                                        value2 = generator2.isError() ? Main$ExitCode$.MODULE$.GenerateCodeError() : Main$ExitCode$.MODULE$.Success();
                                    } else if (None$.MODULE$.equals(option12)) {
                                        value2 = Main$ExitCode$.MODULE$.GenerateCodeError();
                                    } else {
                                        throw new MatchError(option12);
                                    }
                                    value = rc2 = value2;
                                    break block95;
                                }
                                if (!conf.exi().equals(scallopConfBase)) break block93;
                                rc = Main$ExitCode$.MODULE$.Success();
                                CLIConf$exi$ exiOpts = conf.exi();
                                Option option = exiOpts.output().toOption();
                                if (option instanceof Some && "-".equals(((Some)option).value()) || None$.MODULE$.equals(option)) {
                                    writableByteChannel = Channels.newChannel(this.STDOUT);
                                } else if (option instanceof Some) {
                                    String file = (String)((Some)option).value();
                                    writableByteChannel = new FileOutputStream(file).getChannel();
                                } else {
                                    throw new MatchError((Object)option);
                                }
                                WritableByteChannel channel = writableByteChannel;
                                output = Channels.newOutputStream(channel);
                                Option option13 = exiOpts.infile().toOption();
                                if (option13 instanceof Some && "-".equals(((Some)option13).value()) || None$.MODULE$.equals(option13)) {
                                    inputStream2 = this.STDIN;
                                } else if (option13 instanceof Some) {
                                    String file = (String)((Some)option13).value();
                                    File f = new File(file);
                                    inputStream2 = new FileInputStream(f);
                                } else {
                                    throw new MatchError((Object)option13);
                                }
                                inputStream = inputStream2;
                                input = new InputSource(inputStream);
                                try {
                                    some = Some$.MODULE$.apply((Object)EXIInfosetHandler$.MODULE$.createEXIFactory((Option<URI>)exiOpts.schema().map((Function1 & Serializable)_$21 -> _$21.uri()).toOption()));
                                }
                                catch (EXIException e) {
                                    Logger LoggerImpl_this = Logger$.MODULE$.log();
                                    if (LoggerImpl_this.underlying().isErrorEnabled()) {
                                        LoggerImpl_this.underlying().error("Error creating EXI grammar for the supplied schema: {}", Misc$.MODULE$.getSomeMessage((Throwable)e).get());
                                    }
                                    rc = Main$ExitCode$.MODULE$.Failure();
                                    some = None$.MODULE$;
                                }
                                exiFactory = some;
                                tuple2 = Tuple2$.MODULE$.apply(exiOpts.decode().toOption().get(), (Object)BoxesRunTime.boxToBoolean((boolean)exiFactory.isDefined()));
                                if (tuple2 == null) break block101;
                                bl2 = tuple2._1$mcZ$sp();
                                bl = tuple2._2$mcZ$sp();
                                if (!bl2 || !bl) break block102;
                                EXISource exiSource = new EXISource((EXIFactory)exiFactory.get());
                                exiSource.setInputSource(input);
                                StreamResult result = new StreamResult(output);
                                TransformerFactory tf = TransformerFactory.newInstance();
                                Transformer transformer = tf.newTransformer();
                                transformer.setErrorListener(new EXIErrorHandler());
                                try {
                                    transformer.transform((Source)exiSource, result);
                                }
                                catch (Exception e) {
                                    Logger LoggerImpl_this = Logger$.MODULE$.log();
                                    if (LoggerImpl_this.underlying().isErrorEnabled()) {
                                        LoggerImpl_this.underlying().error("Error decoding EXI input: {}", Misc$.MODULE$.getSomeMessage((Throwable)e).get());
                                    }
                                    rc = Main$ExitCode$.MODULE$.Failure();
                                }
                                break block103;
                            }
                            if (bl2 || !bl) break block104;
                            EXIResult exiResult = new EXIResult((EXIFactory)exiFactory.get());
                            exiResult.setOutputStream(output);
                            SAXParserFactory factory = SAXParserFactory.newInstance();
                            factory.setNamespaceAware(true);
                            SAXParser saxParser = factory.newSAXParser();
                            XMLReader reader = saxParser.getXMLReader();
                            reader.setContentHandler(exiResult.getHandler());
                            reader.setErrorHandler(new EXIErrorHandler());
                            try {
                                reader.parse(input);
                            }
                            catch (SAXException s) {
                                Logger LoggerImpl_this = Logger$.MODULE$.log();
                                if (LoggerImpl_this.underlying().isErrorEnabled()) {
                                    LoggerImpl_this.underlying().error("Error parsing input XML: {}", Misc$.MODULE$.getSomeMessage((Throwable)s).get());
                                }
                                rc = Main$ExitCode$.MODULE$.Failure();
                            }
                            break block103;
                        }
                        if (!bl) break block103;
                    }
                    throw new MatchError((Object)tuple2);
                }
                inputStream.close();
                output.close();
                value = rc;
                break block95;
            }
            throw Assert$.MODULE$.impossible(Assert$.MODULE$.impossible$default$1());
        }
        Enumeration.Value ret = value;
        return ret;
    }

    public int bugFound(Exception e) {
        this.STDERR.println(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|\n                      |!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n                      |!!   An unexpected exception occurred. This is a bug!   !!\n                      |!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n                      |\n                      | Please report this bug and help us fix it:\n                      |\n                      |  https://daffodil.apache.org/community/#issue-tracker\n                      |\n                      | Please include the following exception, the command you\n                      | ran, and any input, schema, or tdml files used that led\n                      | to this bug.\n                      |\n                      |")));
        e.printStackTrace(this.STDERR);
        return 1;
    }

    public int nyiFound(NotYetImplementedException e) {
        this.STDERR.println(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("|\n                      |!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n                      |!!                 Not Yet Implemented                  !!\n                      |!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n                      |\n                      | You are using a feature that is not yet implemented:\n                      |\n                      | %s\n                      |\n                      | You can create a bug and track the progress of this\n                      | feature at:\n                      |\n                      |  https://issues.apache.org/jira/projects/DAFFODIL\n                      |\n                      |"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Misc$.MODULE$.getSomeMessage((Throwable)e)})))));
        return 1;
    }

    public int oomError(OutOfMemoryError e) {
        this.STDERR.println(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|\n                      |!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n                      |!!             Daffodil ran out of memory!              !!\n                      |!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n                      |\n                      | Try increasing the amount of memory by changing or\n                      | setting the DAFFODIL_JAVA_OPTS environment variable.\n                      | \"DAFFODIL_JAVA_OPTS=-Xmx5G\" for 5GB.\n                      |\n                      |")));
        return 1;
    }

    /*
     * Exception decompiling
     */
    public Enumeration.Value run(String[] arguments) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static final scala.collection.immutable.Seq $anonfun$4() {
        return (scala.collection.immutable.Seq)((SeqOps)Nil$.MODULE$);
    }

    private static final DataProcessor $anonfun$5(Compiler compiler$1, File savedParser$1) {
        return compiler$1.reload(savedParser$1);
    }

    private static final URL createProcessorFromParser$$anonfun$2() {
        return null;
    }

    private static final String $anonfun$7() {
        return "/";
    }

    private static final URL $anonfun$9() {
        return null;
    }

    private final Option $anonfun$6(Compiler compiler$2, URISchemaSource schemaSource$1, Tuple2 validate$13, Option path$1) {
        ProcessorFactory processorFactory = compiler$2.compileSource((DaffodilSchemaSource)schemaSource$1, compiler$2.compileSource$default$2(), compiler$2.compileSource$default$3());
        if (!processorFactory.isError()) {
            Tuple2 tuple2 = validate$13;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String validationKind = (String)tuple2._1();
            Option validationConfig = (Option)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)validationKind, (Object)validationConfig);
            String validationKind2 = (String)tuple22._1();
            Option validationConfig2 = (Option)tuple22._2();
            org.apache.daffodil.runtime1.processors.DataProcessor processor = (org.apache.daffodil.runtime1.processors.DataProcessor)processorFactory.onPath((String)path$1.getOrElse(Main::$anonfun$7)).withValidation(validationKind2, (URL)validationConfig2.map((Function1 & Serializable)_$5 -> _$5.toURL()).getOrElse(Main::$anonfun$9));
            if (processor.isError()) {
                this.displayDiagnostics((WithDiagnostics)processor);
                return None$.MODULE$;
            }
            this.displayDiagnostics((WithDiagnostics)processor);
            Logger LoggerImpl_this = Logger$.MODULE$.log();
            if (LoggerImpl_this.underlying().isDebugEnabled()) {
                Logger LoggerImpl_this2;
                org.apache.daffodil.runtime1.processors.DataProcessor processorImpl = processor;
                Logger LoggerImpl_this3 = Logger$.MODULE$.log();
                if (LoggerImpl_this3.underlying().isDebugEnabled()) {
                    LoggerImpl_this3.underlying().debug("Parser = {}", (Object)processorImpl.ssrd().parser().toString());
                }
                if ((LoggerImpl_this2 = Logger$.MODULE$.log()).underlying().isDebugEnabled()) {
                    LoggerImpl_this2.underlying().debug("Unparser = {}", (Object)processorImpl.ssrd().unparser().toString());
                }
            }
            return Some$.MODULE$.apply((Object)processor);
        }
        this.displayDiagnostics((WithDiagnostics)processorFactory);
        return None$.MODULE$;
    }

    private final Option $anonfun$10(Compiler compiler$3, URISchemaSource schemaSource$2, String language$1) {
        ProcessorFactory processorFactory = compiler$3.compileSource((DaffodilSchemaSource)schemaSource$2, compiler$3.compileSource$default$2(), compiler$3.compileSource$default$3());
        if (!processorFactory.isError()) {
            CodeGenerator generator = processorFactory.forLanguage(language$1);
            this.displayDiagnostics((WithDiagnostics)generator);
            return Some$.MODULE$.apply((Object)generator);
        }
        this.displayDiagnostics((WithDiagnostics)processorFactory);
        return None$.MODULE$;
    }

    private static final InfosetParseResult $anonfun$16(InfosetHandler infosetHandler$1, InputSourceDataInputStream inStream$1, OutputStream output$1) {
        return infosetHandler$1.parse(inStream$1, output$1);
    }

    private static final Tuple2 $anonfun$24$$anonfun$1(ConcurrentLinkedQueue inputQueue$3, boolean isUnparse$3, InfosetHandler infosetHandler$4, WritableByteChannel nullChannelForUnparse$2, NullOutputStream nullOutputStreamForParse$2) {
        long threadLatencyNS = 0L;
        long threadFiles = 0L;
        Object input = null;
        while ((input = inputQueue$3.poll()) != null) {
            long latencyTimeStart = System.nanoTime();
            if (isUnparse$3) {
                UnparseResult unparseResult = infosetHandler$4.unparse(input, nullChannelForUnparse$2);
                if (unparseResult.isError()) {
                    throw new Exception("Failed to unparse");
                }
            } else {
                InputSourceDataInputStream isdis = InputSourceDataInputStream$.MODULE$.apply((byte[])input);
                InfosetParseResult infosetResult = infosetHandler$4.parse(isdis, (OutputStream)nullOutputStreamForParse$2);
                if (infosetResult.parseResult().isError()) {
                    throw new Exception("Failed to parse");
                }
            }
            long latencyTimeEnd = System.nanoTime();
            threadLatencyNS += latencyTimeEnd - latencyTimeStart;
            ++threadFiles;
        }
        return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)threadLatencyNS), (Object)BoxesRunTime.boxToLong((long)threadFiles));
    }

    private static final UnparseResult $anonfun$31(InfosetHandler infosetHandler$5, Object inputterData$1, WritableByteChannel outChannel$1) {
        return infosetHandler$5.unparse(inputterData$1, outChannel$1);
    }

    private static final void $anonfun$33(DataProcessor processor$2, WritableByteChannel output$2) {
        processor$2.save(output$2);
    }

    private static final /* synthetic */ String $anonfun$40(int max) {
        return "%" + -max + "s";
    }

    private static final String $anonfun$43$$anonfun$1() {
        return "<none>";
    }

    private static final String $anonfun$43$$anonfun$2() {
        return "<none>";
    }

    private static final String $anonfun$45() {
        return ".";
    }

    private static final Path $anonfun$46(CodeGenerator generator$1, String outputDir$1) {
        return generator$1.generateCode(outputDir$1);
    }

    private static final /* synthetic */ void $anonfun$48(StackTraceElement ste) {
        Logger LoggerImpl_this = Logger$.MODULE$.log();
        if (LoggerImpl_this.underlying().isErrorEnabled()) {
            LoggerImpl_this.underlying().error("    at {}", (Object)ste);
            return;
        }
    }
}

