/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.store.range;

import com.google.protobuf.ByteString;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.bifromq.basekv.store.range.IKVLoadRecorder;
import org.apache.bifromq.basekv.store.range.hinter.IKVLoadRecord;

public class KVLoadRecorder
implements IKVLoadRecorder {
    private final long startNanos;
    private final Map<ByteString, Long> loadDistribution = new HashMap<ByteString, Long>(256);
    private long kvIONanos = 0L;
    private int kvIOs = 0;

    public KVLoadRecorder() {
        this(System::nanoTime);
    }

    public KVLoadRecorder(Supplier<Long> nanoSource) {
        this.startNanos = nanoSource.get();
    }

    @Override
    public void record(ByteString key, long latencyNanos) {
        this.loadDistribution.compute(key, (k, v) -> v == null ? latencyNanos : v + latencyNanos);
        ++this.kvIOs;
        this.kvIONanos += latencyNanos;
    }

    @Override
    public void record(long latencyNanos) {
        this.kvIONanos += latencyNanos;
        ++this.kvIOs;
    }

    @Override
    public IKVLoadRecord stop() {
        return new IKVLoadRecord(){

            public long startNanos() {
                return KVLoadRecorder.this.startNanos;
            }

            public int getKVIOs() {
                return KVLoadRecorder.this.kvIOs;
            }

            public long getKVIONanos() {
                return KVLoadRecorder.this.kvIONanos;
            }

            public Map<ByteString, Long> keyDistribution() {
                return KVLoadRecorder.this.loadDistribution;
            }
        };
    }
}

