/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.store.wal;

import com.google.protobuf.ByteString;
import com.google.protobuf.UnsafeByteOperations;
import org.apache.bifromq.basekv.store.util.KVUtil;

class KVRangeWALKeys {
    public static final ByteString KEY_CURRENT_VOTING_BYTES = UnsafeByteOperations.unsafeWrap((byte[])new byte[]{0});
    public static final ByteString KEY_LATEST_SNAPSHOT_BYTES = UnsafeByteOperations.unsafeWrap((byte[])new byte[]{1});
    public static final ByteString KEY_CONFIG_ENTRY_INDEXES_BYTES = UnsafeByteOperations.unsafeWrap((byte[])new byte[]{2});
    public static final ByteString KEY_CURRENT_TERM_BYTES = UnsafeByteOperations.unsafeWrap((byte[])new byte[]{3});
    public static final ByteString KEY_LOG_ENTRIES_INCAR = UnsafeByteOperations.unsafeWrap((byte[])new byte[]{4});
    public static final ByteString KEY_PREFIX_LOG_ENTRIES_BYTES = UnsafeByteOperations.unsafeWrap((byte[])new byte[]{5});

    KVRangeWALKeys() {
    }

    public static ByteString configEntriesKeyPrefixInfix(int logEntriesKeyInfix) {
        return KEY_CONFIG_ENTRY_INDEXES_BYTES.concat(KVUtil.toByteString(logEntriesKeyInfix));
    }

    public static ByteString configEntriesKey(int logEntriesKeyInfix, long index) {
        return KVRangeWALKeys.configEntriesKeyPrefixInfix(logEntriesKeyInfix).concat(KVUtil.toByteString(index));
    }

    public static ByteString logEntriesKeyPrefixInfix(int logEntriesKeyInfix) {
        return KEY_PREFIX_LOG_ENTRIES_BYTES.concat(KVUtil.toByteString(logEntriesKeyInfix));
    }

    public static ByteString logEntryKey(int logEntriesKeyInfix, long logIndex) {
        return KVRangeWALKeys.logEntriesKeyPrefixInfix(logEntriesKeyInfix).concat(KVUtil.toByteString(logIndex));
    }

    public static long parseLogIndex(ByteString logEntryKey) {
        return logEntryKey.asReadOnlyByteBuffer().getLong(6);
    }
}

