/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.apiserver.http;

import io.netty.handler.codec.http.HttpMethod;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HEAD;
import jakarta.ws.rs.OPTIONS;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import java.lang.reflect.Method;
import org.apache.bifromq.apiserver.http.IHTTPRequestHandler;

public class AnnotationUtil {
    public static <T extends IHTTPRequestHandler> HttpMethod getHTTPMethod(Class<T> handlerClass) {
        for (Method handleMethod : handlerClass.getMethods()) {
            if (handleMethod.getAnnotation(GET.class) != null) {
                return HttpMethod.GET;
            }
            if (handleMethod.getAnnotation(PUT.class) != null) {
                return HttpMethod.PUT;
            }
            if (handleMethod.getAnnotation(POST.class) != null) {
                return HttpMethod.POST;
            }
            if (handleMethod.getAnnotation(DELETE.class) != null) {
                return HttpMethod.DELETE;
            }
            if (handleMethod.getAnnotation(OPTIONS.class) != null) {
                return HttpMethod.OPTIONS;
            }
            if (handleMethod.getAnnotation(HEAD.class) != null) {
                return HttpMethod.HEAD;
            }
            if (handleMethod.getAnnotation(PATCH.class) == null) continue;
            return HttpMethod.PATCH;
        }
        return null;
    }

    public static <T extends IHTTPRequestHandler> Path getPath(Class<T> handlerClass) {
        return handlerClass.getAnnotation(Path.class);
    }
}

