/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.utils;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractOperatorWithNestedPlans;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractReplicateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ExchangeOperator;
import org.apache.hyracks.algebricks.core.utils.LogicalOperatorDotVisitor;
import org.apache.hyracks.api.util.DotFormatBuilder;

public class DotFormatGenerator {
    private final LogicalOperatorDotVisitor dotVisitor = new LogicalOperatorDotVisitor();

    public String generate(ILogicalPlan plan, boolean showDetails) throws AlgebricksException {
        ILogicalOperator root = (ILogicalOperator)plan.getRoots().get(0).getValue();
        return this.generate(root, showDetails);
    }

    public String generate(ILogicalOperator startingOp, boolean showDetails) throws AlgebricksException {
        DotFormatBuilder graphBuilder = new DotFormatBuilder(DotFormatBuilder.StringValue.of((String)"Plan"));
        this.generateNode(graphBuilder, startingOp, showDetails, new HashSet<ILogicalOperator>());
        return graphBuilder.getDotDocument();
    }

    private void generateNode(DotFormatBuilder dotBuilder, ILogicalOperator op, boolean showDetails, Set<ILogicalOperator> operatorsVisited) throws AlgebricksException {
        DotFormatBuilder.Node sourceNode;
        DotFormatBuilder.StringValue sourceNodeLabel;
        DotFormatBuilder.StringValue destinationNodeLabel = this.formatStringOf(op, showDetails);
        DotFormatBuilder.Node destinationNode = dotBuilder.createNode(DotFormatBuilder.StringValue.of((String)Integer.toString(op.hashCode())), destinationNodeLabel);
        for (Mutable<ILogicalOperator> mutable : op.getInputs()) {
            sourceNodeLabel = this.formatStringOf((ILogicalOperator)mutable.getValue(), showDetails);
            sourceNode = dotBuilder.createNode(DotFormatBuilder.StringValue.of((String)Integer.toString(((ILogicalOperator)mutable.getValue()).hashCode())), sourceNodeLabel);
            dotBuilder.createEdge(sourceNode, destinationNode);
            if (operatorsVisited.contains(mutable.getValue())) continue;
            this.generateNode(dotBuilder, (ILogicalOperator)mutable.getValue(), showDetails, operatorsVisited);
        }
        if (((AbstractLogicalOperator)op).hasNestedPlans()) {
            for (ILogicalPlan nestedPlan : ((AbstractOperatorWithNestedPlans)op).getNestedPlans()) {
                ILogicalOperator nestedOperator = (ILogicalOperator)nestedPlan.getRoots().get(0).getValue();
                sourceNodeLabel = this.formatStringOf(nestedOperator, showDetails);
                sourceNode = dotBuilder.createNode(DotFormatBuilder.StringValue.of((String)Integer.toString(nestedOperator.hashCode())), sourceNodeLabel);
                dotBuilder.createEdge(sourceNode, destinationNode).setLabel(DotFormatBuilder.StringValue.of((String)"subplan"));
                if (operatorsVisited.contains(nestedOperator)) continue;
                this.generateNode(dotBuilder, nestedOperator, showDetails, operatorsVisited);
            }
        }
        if (!(op instanceof ExchangeOperator)) {
            destinationNode.setFillColor(DotFormatBuilder.Color.SKYBLUE);
        }
        if (op.getOperatorTag() == LogicalOperatorTag.REPLICATE || op.getOperatorTag() == LogicalOperatorTag.SPLIT) {
            AbstractReplicateOperator replicateOperator = (AbstractReplicateOperator)op;
            sourceNode = destinationNode;
            for (int i = 0; i < replicateOperator.getOutputs().size(); ++i) {
                ILogicalOperator iLogicalOperator = (ILogicalOperator)replicateOperator.getOutputs().get(i).getValue();
                destinationNodeLabel = this.formatStringOf(iLogicalOperator, showDetails);
                destinationNode = dotBuilder.createNode(DotFormatBuilder.StringValue.of((String)Integer.toString(iLogicalOperator.hashCode())), destinationNodeLabel);
                if (replicateOperator.getOutputMaterializationFlags()[i]) {
                    dotBuilder.createEdge(sourceNode, destinationNode).setColor(DotFormatBuilder.Color.RED);
                    continue;
                }
                dotBuilder.createEdge(sourceNode, destinationNode);
            }
        }
        operatorsVisited.add(op);
    }

    private DotFormatBuilder.StringValue formatStringOf(ILogicalOperator operator, boolean showDetails) throws AlgebricksException {
        String formattedString = operator.accept(this.dotVisitor, showDetails).trim();
        return DotFormatBuilder.StringValue.of((String)formattedString);
    }
}

