/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.objects;

import it.unimi.dsi.fastutil.Function;
import it.unimi.dsi.fastutil.SafeMath;
import it.unimi.dsi.fastutil.objects.AbstractReference2FloatFunction;
import it.unimi.dsi.fastutil.objects.Reference2FloatFunction;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Objects;
import java.util.function.ToDoubleFunction;

public final class Reference2FloatFunctions {
    public static final EmptyFunction EMPTY_FUNCTION = new EmptyFunction();

    private Reference2FloatFunctions() {
    }

    public static <K> Reference2FloatFunction<K> singleton(K key, float value) {
        return new Singleton<K>(key, value);
    }

    public static <K> Reference2FloatFunction<K> singleton(K key, Float value) {
        return new Singleton<K>(key, value.floatValue());
    }

    public static <K> Reference2FloatFunction<K> synchronize(Reference2FloatFunction<K> f) {
        return new SynchronizedFunction<K>(f);
    }

    public static <K> Reference2FloatFunction<K> synchronize(Reference2FloatFunction<K> f, Object sync) {
        return new SynchronizedFunction<K>(f, sync);
    }

    public static <K> Reference2FloatFunction<K> unmodifiable(Reference2FloatFunction<? extends K> f) {
        return new UnmodifiableFunction<K>(f);
    }

    public static <K> Reference2FloatFunction<K> primitive(java.util.function.Function<? super K, ? extends Float> f) {
        Objects.requireNonNull(f);
        if (f instanceof Reference2FloatFunction) {
            return (Reference2FloatFunction)f;
        }
        if (f instanceof ToDoubleFunction) {
            return key -> SafeMath.safeDoubleToFloat((double)((ToDoubleFunction)((Object)f)).applyAsDouble(key));
        }
        return new PrimitiveFunction<K>(f);
    }

    public static class Singleton<K>
    extends AbstractReference2FloatFunction<K>
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final K key;
        protected final float value;

        protected Singleton(K key, float value) {
            this.key = key;
            this.value = value;
        }

        public boolean containsKey(Object k) {
            return this.key == k;
        }

        public float getFloat(Object k) {
            return this.key == k ? this.value : this.defRetValue;
        }

        public float getOrDefault(Object k, float defaultValue) {
            return this.key == k ? this.value : defaultValue;
        }

        public int size() {
            return 1;
        }

        public Object clone() {
            return this;
        }
    }

    public static class SynchronizedFunction<K>
    implements Reference2FloatFunction<K>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final Reference2FloatFunction<K> function;
        protected final Object sync;

        protected SynchronizedFunction(Reference2FloatFunction<K> f, Object sync) {
            if (f == null) {
                throw new NullPointerException();
            }
            this.function = f;
            this.sync = sync;
        }

        protected SynchronizedFunction(Reference2FloatFunction<K> f) {
            if (f == null) {
                throw new NullPointerException();
            }
            this.function = f;
            this.sync = this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public double applyAsDouble(K operand) {
            Object object = this.sync;
            synchronized (object) {
                return this.function.applyAsDouble(operand);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Deprecated
        public Float apply(K key) {
            Object object = this.sync;
            synchronized (object) {
                return (Float)this.function.apply(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int size() {
            Object object = this.sync;
            synchronized (object) {
                return this.function.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public float defaultReturnValue() {
            Object object = this.sync;
            synchronized (object) {
                return this.function.defaultReturnValue();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void defaultReturnValue(float defRetValue) {
            Object object = this.sync;
            synchronized (object) {
                this.function.defaultReturnValue(defRetValue);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsKey(Object k) {
            Object object = this.sync;
            synchronized (object) {
                return this.function.containsKey(k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public float put(K k, float v) {
            Object object = this.sync;
            synchronized (object) {
                return this.function.put(k, v);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public float getFloat(Object k) {
            Object object = this.sync;
            synchronized (object) {
                return this.function.getFloat(k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public float getOrDefault(Object k, float defaultValue) {
            Object object = this.sync;
            synchronized (object) {
                return this.function.getOrDefault(k, defaultValue);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public float removeFloat(Object k) {
            Object object = this.sync;
            synchronized (object) {
                return this.function.removeFloat(k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Object object = this.sync;
            synchronized (object) {
                this.function.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Deprecated
        public Float put(K k, Float v) {
            Object object = this.sync;
            synchronized (object) {
                return this.function.put(k, v);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Deprecated
        public Float get(Object k) {
            Object object = this.sync;
            synchronized (object) {
                return this.function.get(k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Deprecated
        public Float getOrDefault(Object k, Float defaultValue) {
            Object object = this.sync;
            synchronized (object) {
                return this.function.getOrDefault(k, defaultValue);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Deprecated
        public Float remove(Object k) {
            Object object = this.sync;
            synchronized (object) {
                return this.function.remove(k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int hashCode() {
            Object object = this.sync;
            synchronized (object) {
                return this.function.hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            Object object = this.sync;
            synchronized (object) {
                return this.function.equals(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Object object = this.sync;
            synchronized (object) {
                return this.function.toString();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeObject(ObjectOutputStream s) throws IOException {
            Object object = this.sync;
            synchronized (object) {
                s.defaultWriteObject();
            }
        }
    }

    public static class UnmodifiableFunction<K>
    extends AbstractReference2FloatFunction<K>
    implements Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final Reference2FloatFunction<? extends K> function;

        protected UnmodifiableFunction(Reference2FloatFunction<? extends K> f) {
            if (f == null) {
                throw new NullPointerException();
            }
            this.function = f;
        }

        public int size() {
            return this.function.size();
        }

        @Override
        public float defaultReturnValue() {
            return this.function.defaultReturnValue();
        }

        @Override
        public void defaultReturnValue(float defRetValue) {
            throw new UnsupportedOperationException();
        }

        public boolean containsKey(Object k) {
            return this.function.containsKey(k);
        }

        public float put(K k, float v) {
            throw new UnsupportedOperationException();
        }

        public float getFloat(Object k) {
            return this.function.getFloat(k);
        }

        public float getOrDefault(Object k, float defaultValue) {
            return this.function.getOrDefault(k, defaultValue);
        }

        public float removeFloat(Object k) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Deprecated
        public Float put(K k, Float v) {
            throw new UnsupportedOperationException();
        }

        @Deprecated
        public Float get(Object k) {
            return this.function.get(k);
        }

        @Deprecated
        public Float getOrDefault(Object k, Float defaultValue) {
            return this.function.getOrDefault(k, defaultValue);
        }

        @Deprecated
        public Float remove(Object k) {
            throw new UnsupportedOperationException();
        }

        public int hashCode() {
            return this.function.hashCode();
        }

        public boolean equals(Object o) {
            return o == this || this.function.equals(o);
        }

        public String toString() {
            return this.function.toString();
        }
    }

    public static class PrimitiveFunction<K>
    implements Reference2FloatFunction<K> {
        protected final java.util.function.Function<? super K, ? extends Float> function;

        protected PrimitiveFunction(java.util.function.Function<? super K, ? extends Float> function) {
            this.function = function;
        }

        public boolean containsKey(Object key) {
            return this.function.apply(key) != null;
        }

        public float getFloat(Object key) {
            Float v = this.function.apply(key);
            if (v == null) {
                return this.defaultReturnValue();
            }
            return v.floatValue();
        }

        public float getOrDefault(Object key, float defaultValue) {
            Float v = this.function.apply(key);
            if (v == null) {
                return defaultValue;
            }
            return v.floatValue();
        }

        @Deprecated
        public Float get(Object key) {
            return this.function.apply(key);
        }

        @Deprecated
        public Float getOrDefault(Object key, Float defaultValue) {
            Float v = this.function.apply(key);
            return v == null ? defaultValue : v;
        }

        @Deprecated
        public Float put(K key, Float value) {
            throw new UnsupportedOperationException();
        }
    }

    public static class EmptyFunction<K>
    extends AbstractReference2FloatFunction<K>
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;

        protected EmptyFunction() {
        }

        public float getFloat(Object k) {
            return 0.0f;
        }

        public float getOrDefault(Object k, float defaultValue) {
            return defaultValue;
        }

        public boolean containsKey(Object k) {
            return false;
        }

        @Override
        public float defaultReturnValue() {
            return 0.0f;
        }

        @Override
        public void defaultReturnValue(float defRetValue) {
            throw new UnsupportedOperationException();
        }

        public int size() {
            return 0;
        }

        public void clear() {
        }

        public Object clone() {
            return EMPTY_FUNCTION;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Function)) {
                return false;
            }
            return ((Function)o).size() == 0;
        }

        public String toString() {
            return "{}";
        }

        private Object readResolve() {
            return EMPTY_FUNCTION;
        }
    }
}

