/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.btree.frames;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.btree.api.IBTreeLeafFrame;
import org.apache.hyracks.storage.am.btree.api.IPrefixSlotManager;
import org.apache.hyracks.storage.am.btree.compressors.FieldPrefixCompressor;
import org.apache.hyracks.storage.am.btree.impls.BTreeFieldPrefixTupleReference;
import org.apache.hyracks.storage.am.btree.impls.BTreeOpContext;
import org.apache.hyracks.storage.am.btree.impls.FieldPrefixPrefixTupleReference;
import org.apache.hyracks.storage.am.btree.impls.FieldPrefixSlotManager;
import org.apache.hyracks.storage.am.btree.tuples.BTreeTypeAwareTupleWriter;
import org.apache.hyracks.storage.am.common.api.IBTreeIndexTupleReference;
import org.apache.hyracks.storage.am.common.api.ISplitKey;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrame;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrameCompressor;
import org.apache.hyracks.storage.am.common.api.ITreeIndexTupleReference;
import org.apache.hyracks.storage.am.common.frames.FrameOpSpaceStatus;
import org.apache.hyracks.storage.am.common.ophelpers.FindTupleMode;
import org.apache.hyracks.storage.am.common.ophelpers.FindTupleNoExactMatchPolicy;
import org.apache.hyracks.storage.am.common.ophelpers.SlotOffTupleOff;
import org.apache.hyracks.storage.common.MultiComparator;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;
import org.apache.hyracks.storage.common.buffercache.ICachedPage;
import org.apache.hyracks.storage.common.buffercache.IExtraPageBlockHelper;

public class BTreeFieldPrefixNSMLeafFrame
implements IBTreeLeafFrame {
    protected static final int PAGE_LSN_OFFSET = 9;
    protected static final int TOTAL_FREE_SPACE_OFFSET = 17;
    protected static final int SM_FLAG_OFFSET = 21;
    protected static final int UNCOMPRESSED_TUPLE_COUNT_OFFSET = 22;
    protected static final int PREFIX_TUPLE_COUNT_OFFSET = 26;
    protected static final int NEXT_LEAF_OFFSET = 30;
    private final IPrefixSlotManager slotManager;
    private final ITreeIndexFrameCompressor compressor;
    private final BTreeFieldPrefixTupleReference frameTuple;
    private final FieldPrefixPrefixTupleReference framePrefixTuple;
    private final BTreeTypeAwareTupleWriter tupleWriter;
    private MultiComparator cmp;
    protected ICachedPage page = null;
    protected ByteBuffer buf = null;

    public BTreeFieldPrefixNSMLeafFrame(BTreeTypeAwareTupleWriter tupleWriter) {
        this.tupleWriter = tupleWriter;
        this.frameTuple = new BTreeFieldPrefixTupleReference(tupleWriter.createTupleReference());
        this.slotManager = new FieldPrefixSlotManager();
        ITypeTraits[] typeTraits = tupleWriter.getTypeTraits();
        this.framePrefixTuple = new FieldPrefixPrefixTupleReference(typeTraits);
        this.compressor = new FieldPrefixCompressor(typeTraits, 0.001f, 2);
    }

    public int getMaxTupleSize(int pageSize) {
        return (pageSize - this.getPageHeaderSize()) / 2;
    }

    public int getBytesRequiredToWriteTuple(ITupleReference tuple) {
        return this.tupleWriter.bytesRequired(tuple) + this.slotManager.getSlotSize();
    }

    public void setPage(ICachedPage page) {
        this.page = page;
        this.buf = page.getBuffer();
        this.slotManager.setFrame(this);
    }

    public ByteBuffer getBuffer() {
        return this.page.getBuffer();
    }

    public ICachedPage getPage() {
        return this.page;
    }

    public boolean compress() throws HyracksDataException {
        try {
            return this.compressor.compress((ITreeIndexFrame)this, this.cmp);
        }
        catch (Exception e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public boolean compact() {
        int tupleSlot;
        int i;
        this.resetSpaceParams();
        int tupleCount = this.buf.getInt(0);
        int freeSpace = this.buf.getInt(4);
        int prefixTupleCount = this.buf.getInt(26);
        if (prefixTupleCount > 0) {
            int max = 0;
            for (i = 0; i < prefixTupleCount; ++i) {
                this.framePrefixTuple.resetByTupleIndex(this, i);
                int end = this.framePrefixTuple.getFieldStart(this.framePrefixTuple.getFieldCount() - 1) + this.framePrefixTuple.getFieldLength(this.framePrefixTuple.getFieldCount() - 1);
                if (end <= max) continue;
                max = end;
            }
            this.framePrefixTuple.resetByTupleIndex(this, prefixTupleCount - 1);
            freeSpace = this.framePrefixTuple.getFieldStart(this.framePrefixTuple.getFieldCount() - 1) + this.framePrefixTuple.getFieldLength(this.framePrefixTuple.getFieldCount() - 1);
        }
        ArrayList<SlotOffTupleOff> sortedTupleOffs = new ArrayList<SlotOffTupleOff>();
        sortedTupleOffs.ensureCapacity(tupleCount);
        for (i = 0; i < tupleCount; ++i) {
            int tupleSlotOff = this.slotManager.getTupleSlotOff(i);
            tupleSlot = this.buf.getInt(tupleSlotOff);
            int tupleOff = this.slotManager.decodeSecondSlotField(tupleSlot);
            sortedTupleOffs.add(new SlotOffTupleOff(i, tupleSlotOff, tupleOff));
        }
        Collections.sort(sortedTupleOffs);
        for (i = 0; i < sortedTupleOffs.size(); ++i) {
            int tupleOff = ((SlotOffTupleOff)sortedTupleOffs.get((int)i)).tupleOff;
            tupleSlot = this.buf.getInt(((SlotOffTupleOff)sortedTupleOffs.get((int)i)).slotOff);
            int prefixSlotNum = this.slotManager.decodeFirstSlotField(tupleSlot);
            this.frameTuple.resetByTupleIndex(this, ((SlotOffTupleOff)sortedTupleOffs.get((int)i)).tupleIndex);
            int tupleEndOff = this.frameTuple.getFieldStart(this.frameTuple.getFieldCount() - 1) + this.frameTuple.getFieldLength(this.frameTuple.getFieldCount() - 1);
            int tupleLength = tupleEndOff - tupleOff;
            System.arraycopy(this.buf.array(), tupleOff, this.buf.array(), freeSpace, tupleLength);
            this.slotManager.setSlot(((SlotOffTupleOff)sortedTupleOffs.get((int)i)).slotOff, this.slotManager.encodeSlotFields(prefixSlotNum, freeSpace));
            freeSpace += tupleLength;
        }
        this.buf.putInt(4, freeSpace);
        int totalFreeSpace = this.buf.capacity() - this.buf.getInt(4) - (this.buf.getInt(0) + this.buf.getInt(26)) * this.slotManager.getSlotSize();
        this.buf.putInt(17, totalFreeSpace);
        return false;
    }

    public void delete(ITupleReference tuple, int slot) {
        int tupleIndex = this.slotManager.decodeSecondSlotField(slot);
        int prefixSlotNum = this.slotManager.decodeFirstSlotField(slot);
        int tupleSlotOff = this.slotManager.getTupleSlotOff(tupleIndex);
        int slotEndOff = this.slotManager.getTupleSlotEndOff();
        int length = tupleSlotOff - slotEndOff;
        System.arraycopy(this.buf.array(), slotEndOff, this.buf.array(), slotEndOff + this.slotManager.getSlotSize(), length);
        int tupleSize = 0;
        int suffixFieldStart = 0;
        if (prefixSlotNum == 255) {
            suffixFieldStart = 0;
            this.buf.putInt(22, this.buf.getInt(22) - 1);
        } else {
            int prefixSlot = this.buf.getInt(this.slotManager.getPrefixSlotOff(prefixSlotNum));
            suffixFieldStart = this.slotManager.decodeFirstSlotField(prefixSlot);
        }
        this.frameTuple.resetByTupleIndex(this, tupleIndex);
        tupleSize = this.tupleWriter.bytesRequired((ITupleReference)this.frameTuple, suffixFieldStart, this.frameTuple.getFieldCount() - suffixFieldStart);
        this.buf.putInt(0, this.buf.getInt(0) - 1);
        this.buf.putInt(17, this.buf.getInt(17) + tupleSize + this.slotManager.getSlotSize());
    }

    public FrameOpSpaceStatus hasSpaceInsert(ITupleReference tuple) throws HyracksDataException {
        int prefixSlotOff;
        int prefixSlot;
        int numPrefixFields;
        int compressedSize;
        int freeContiguous = this.buf.capacity() - this.buf.getInt(4) - (this.buf.getInt(0) + this.buf.getInt(26)) * this.slotManager.getSlotSize();
        int bytesRequired = this.tupleWriter.bytesRequired(tuple);
        if (bytesRequired + this.slotManager.getSlotSize() <= freeContiguous) {
            return FrameOpSpaceStatus.SUFFICIENT_CONTIGUOUS_SPACE;
        }
        if (bytesRequired + this.slotManager.getSlotSize() <= this.buf.getInt(17)) {
            return FrameOpSpaceStatus.SUFFICIENT_SPACE;
        }
        int prefixSlotNum = this.slotManager.findPrefix(tuple, (ITreeIndexTupleReference)this.framePrefixTuple);
        if (prefixSlotNum != 255 && (compressedSize = this.tupleWriter.bytesRequired(tuple, numPrefixFields = this.slotManager.decodeFirstSlotField(prefixSlot = this.buf.getInt(prefixSlotOff = this.slotManager.getPrefixSlotOff(prefixSlotNum))), tuple.getFieldCount() - numPrefixFields)) + this.slotManager.getSlotSize() <= freeContiguous) {
            return FrameOpSpaceStatus.SUFFICIENT_CONTIGUOUS_SPACE;
        }
        return FrameOpSpaceStatus.INSUFFICIENT_SPACE;
    }

    public void insert(ITupleReference tuple, int tupleIndex) {
        int slot = this.slotManager.insertSlot(tupleIndex, this.buf.getInt(4));
        int prefixSlotNum = this.slotManager.decodeFirstSlotField(slot);
        int numPrefixFields = 0;
        if (prefixSlotNum != 255) {
            int prefixSlotOff = this.slotManager.getPrefixSlotOff(prefixSlotNum);
            int prefixSlot = this.buf.getInt(prefixSlotOff);
            numPrefixFields = this.slotManager.decodeFirstSlotField(prefixSlot);
        } else {
            this.buf.putInt(22, this.buf.getInt(22) + 1);
        }
        int freeSpace = this.buf.getInt(4);
        int bytesWritten = this.tupleWriter.writeTupleFields(tuple, numPrefixFields, tuple.getFieldCount() - numPrefixFields, this.buf.array(), freeSpace);
        this.buf.putInt(0, this.buf.getInt(0) + 1);
        this.buf.putInt(4, this.buf.getInt(4) + bytesWritten);
        this.buf.putInt(17, this.buf.getInt(17) - bytesWritten - this.slotManager.getSlotSize());
    }

    public FrameOpSpaceStatus hasSpaceUpdate(ITupleReference newTuple, int oldTupleIndex) {
        int tupleIndex = this.slotManager.decodeSecondSlotField(oldTupleIndex);
        this.frameTuple.resetByTupleIndex(this, tupleIndex);
        int oldTupleBytes = 0;
        int newTupleBytes = 0;
        int numPrefixFields = this.frameTuple.getNumPrefixFields();
        int fieldCount = this.frameTuple.getFieldCount();
        if (numPrefixFields != 0) {
            oldTupleBytes = this.frameTuple.getSuffixTupleSize();
            newTupleBytes = this.tupleWriter.bytesRequired(newTuple, numPrefixFields, fieldCount - numPrefixFields);
        } else {
            oldTupleBytes = this.frameTuple.getTupleSize();
            newTupleBytes = this.tupleWriter.bytesRequired(newTuple);
        }
        int additionalBytesRequired = newTupleBytes - oldTupleBytes;
        if (additionalBytesRequired <= 0) {
            return FrameOpSpaceStatus.SUFFICIENT_INPLACE_SPACE;
        }
        int freeContiguous = this.buf.capacity() - this.buf.getInt(4) - (this.buf.getInt(0) + this.buf.getInt(26)) * this.slotManager.getSlotSize();
        if (newTupleBytes <= freeContiguous) {
            return FrameOpSpaceStatus.SUFFICIENT_CONTIGUOUS_SPACE;
        }
        if (additionalBytesRequired <= this.buf.getInt(17)) {
            return FrameOpSpaceStatus.SUFFICIENT_SPACE;
        }
        return FrameOpSpaceStatus.INSUFFICIENT_SPACE;
    }

    public void update(ITupleReference newTuple, int oldTupleIndex, boolean inPlace) {
        int tupleIndex = this.slotManager.decodeSecondSlotField(oldTupleIndex);
        int tupleSlotOff = this.slotManager.getTupleSlotOff(tupleIndex);
        int tupleSlot = this.buf.getInt(tupleSlotOff);
        int prefixSlotNum = this.slotManager.decodeFirstSlotField(tupleSlot);
        int suffixTupleStartOff = this.slotManager.decodeSecondSlotField(tupleSlot);
        this.frameTuple.resetByTupleIndex(this, tupleIndex);
        int fieldCount = this.frameTuple.getFieldCount();
        int numPrefixFields = this.frameTuple.getNumPrefixFields();
        int oldTupleBytes = this.frameTuple.getSuffixTupleSize();
        int bytesWritten = 0;
        if (inPlace) {
            bytesWritten = this.tupleWriter.writeTupleFields(newTuple, numPrefixFields, fieldCount - numPrefixFields, this.buf.array(), suffixTupleStartOff);
        } else {
            int newSuffixTupleStartOff = this.buf.getInt(4);
            bytesWritten = this.tupleWriter.writeTupleFields(newTuple, numPrefixFields, fieldCount - numPrefixFields, this.buf.array(), newSuffixTupleStartOff);
            this.slotManager.setSlot(tupleSlotOff, this.slotManager.encodeSlotFields(prefixSlotNum, newSuffixTupleStartOff));
            this.buf.putInt(4, newSuffixTupleStartOff + bytesWritten);
        }
        this.buf.putInt(17, this.buf.getInt(17) + oldTupleBytes - bytesWritten);
    }

    protected void resetSpaceParams() {
        this.buf.putInt(4, this.getOrigFreeSpaceOff());
        this.buf.putInt(17, this.getOrigTotalFreeSpace());
    }

    public void initBuffer(byte level) {
        this.buf.putLong(9, 0L);
        this.buf.putInt(0, 0);
        this.resetSpaceParams();
        this.buf.putInt(22, 0);
        this.buf.putInt(26, 0);
        this.buf.put(8, level);
        this.buf.put(21, (byte)0);
        this.buf.putInt(30, -1);
    }

    public void setTotalFreeSpace(int totalFreeSpace) {
        this.buf.putInt(17, totalFreeSpace);
    }

    public int getOrigTotalFreeSpace() {
        return this.buf.capacity() - 34;
    }

    @Override
    public int findInsertTupleIndex(ITupleReference tuple) throws HyracksDataException {
        int slot = this.slotManager.findSlot(tuple, (ITreeIndexTupleReference)this.frameTuple, (ITreeIndexTupleReference)this.framePrefixTuple, this.cmp, FindTupleMode.EXCLUSIVE_ERROR_IF_EXISTS, FindTupleNoExactMatchPolicy.HIGHER_KEY);
        int tupleIndex = this.slotManager.decodeSecondSlotField(slot);
        if (tupleIndex == this.slotManager.getErrorIndicator()) {
            throw HyracksDataException.create((ErrorCode)ErrorCode.DUPLICATE_KEY, (Serializable[])new Serializable[0]);
        }
        return slot;
    }

    @Override
    public int findUpsertTupleIndex(ITupleReference tuple) throws HyracksDataException {
        int slot = this.slotManager.findSlot(tuple, (ITreeIndexTupleReference)this.frameTuple, (ITreeIndexTupleReference)this.framePrefixTuple, this.cmp, FindTupleMode.INCLUSIVE, FindTupleNoExactMatchPolicy.HIGHER_KEY);
        int tupleIndex = this.slotManager.decodeSecondSlotField(slot);
        if (tupleIndex == this.slotManager.getErrorIndicator()) {
            throw HyracksDataException.create((ErrorCode)ErrorCode.DUPLICATE_KEY, (Serializable[])new Serializable[0]);
        }
        return slot;
    }

    @Override
    public ITupleReference getMatchingKeyTuple(ITupleReference searchTuple, int targetTupleIndex) throws HyracksDataException {
        int tupleIndex = this.slotManager.decodeSecondSlotField(targetTupleIndex);
        if (tupleIndex != this.slotManager.getGreatestKeyIndicator()) {
            this.frameTuple.resetByTupleIndex(this, tupleIndex);
            if (this.cmp.compare(searchTuple, (ITupleReference)this.frameTuple) == 0) {
                return this.frameTuple;
            }
        }
        return null;
    }

    @Override
    public int findUpdateTupleIndex(ITupleReference tuple) throws HyracksDataException {
        int slot = this.slotManager.findSlot(tuple, (ITreeIndexTupleReference)this.frameTuple, (ITreeIndexTupleReference)this.framePrefixTuple, this.cmp, FindTupleMode.EXACT, FindTupleNoExactMatchPolicy.HIGHER_KEY);
        int tupleIndex = this.slotManager.decodeSecondSlotField(slot);
        if (tupleIndex == this.slotManager.getErrorIndicator()) {
            throw HyracksDataException.create((ErrorCode)ErrorCode.UPDATE_OR_DELETE_NON_EXISTENT_KEY, (Serializable[])new Serializable[0]);
        }
        return slot;
    }

    @Override
    public int findDeleteTupleIndex(ITupleReference tuple) throws HyracksDataException {
        int slot = this.slotManager.findSlot(tuple, (ITreeIndexTupleReference)this.frameTuple, (ITreeIndexTupleReference)this.framePrefixTuple, this.cmp, FindTupleMode.EXACT, FindTupleNoExactMatchPolicy.HIGHER_KEY);
        int tupleIndex = this.slotManager.decodeSecondSlotField(slot);
        if (tupleIndex == this.slotManager.getErrorIndicator()) {
            throw HyracksDataException.create((ErrorCode)ErrorCode.UPDATE_OR_DELETE_NON_EXISTENT_KEY, (Serializable[])new Serializable[0]);
        }
        return slot;
    }

    public String printHeader() {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("pageLsnOff:                9\n");
        strBuilder.append("tupleCountOff:             0\n");
        strBuilder.append("freeSpaceOff:              4\n");
        strBuilder.append("totalFreeSpaceOff:         17\n");
        strBuilder.append("levelOff:                  8\n");
        strBuilder.append("smFlagOff:                 21\n");
        strBuilder.append("uncompressedTupleCountOff: 22\n");
        strBuilder.append("prefixTupleCountOff:       26\n");
        strBuilder.append("nextLeafOff:               30\n");
        return strBuilder.toString();
    }

    public int getTupleCount() {
        return this.buf.getInt(0);
    }

    public IPrefixSlotManager getSlotManager() {
        return this.slotManager;
    }

    public int getTupleOffset(int slotNum) {
        int tupleSlotOff = this.slotManager.getTupleSlotOff(slotNum);
        int tupleSlot = this.buf.getInt(tupleSlotOff);
        return this.slotManager.decodeSecondSlotField(tupleSlot);
    }

    public long getPageLsn() {
        return this.buf.getLong(9);
    }

    public void setPageLsn(long pageLsn) {
        this.buf.putLong(9, pageLsn);
    }

    public int getTotalFreeSpace() {
        return this.buf.getInt(17);
    }

    public boolean isLeaf() {
        return this.buf.get(8) == 0;
    }

    public boolean isInterior() {
        return this.buf.get(8) > 0;
    }

    public byte getLevel() {
        return this.buf.get(8);
    }

    public void setLevel(byte level) {
        this.buf.put(8, level);
    }

    @Override
    public boolean getSmFlag() {
        return this.buf.get(21) != 0;
    }

    @Override
    public void setSmFlag(boolean smFlag) {
        if (smFlag) {
            this.buf.put(21, (byte)1);
        } else {
            this.buf.put(21, (byte)0);
        }
    }

    @Override
    public void setLargeFlag(boolean largePage) {
        throw new IllegalStateException();
    }

    @Override
    public boolean getLargeFlag() {
        return false;
    }

    public int getPrefixTupleCount() {
        return this.buf.getInt(26);
    }

    public void setPrefixTupleCount(int prefixTupleCount) {
        this.buf.putInt(26, prefixTupleCount);
    }

    @Override
    public void insertSorted(ITupleReference tuple) throws HyracksDataException {
        int freeSpace = this.buf.getInt(4);
        int fieldsToTruncate = 0;
        if (this.buf.getInt(26) > 0) {
            this.framePrefixTuple.resetByTupleIndex(this, this.buf.getInt(26) - 1);
            if (this.cmp.fieldRangeCompare(tuple, (ITupleReference)this.framePrefixTuple, 0, this.framePrefixTuple.getFieldCount()) == 0) {
                fieldsToTruncate = this.framePrefixTuple.getFieldCount();
            }
        }
        int bytesWritten = this.tupleWriter.writeTupleFields(tuple, fieldsToTruncate, tuple.getFieldCount() - fieldsToTruncate, this.buf.array(), freeSpace);
        int prefixSlotNum = 255;
        if (fieldsToTruncate > 0) {
            prefixSlotNum = this.buf.getInt(26) - 1;
        } else {
            this.buf.putInt(22, this.buf.getInt(22) + 1);
        }
        int insSlot = this.slotManager.encodeSlotFields(prefixSlotNum, 0xFFFFFF);
        this.slotManager.insertSlot(insSlot, freeSpace);
        this.buf.putInt(0, this.buf.getInt(0) + 1);
        this.buf.putInt(4, this.buf.getInt(4) + bytesWritten);
        this.buf.putInt(17, this.buf.getInt(17) - bytesWritten - this.slotManager.getSlotSize());
    }

    public void split(ITreeIndexFrame rightFrame, ITupleReference tuple, ISplitKey splitKey, IExtraPageBlockHelper extraPageBlockHelper, IBufferCache bufferCache) throws HyracksDataException {
        int tuplesToLeft;
        BTreeFieldPrefixNSMLeafFrame rf = (BTreeFieldPrefixNSMLeafFrame)rightFrame;
        ByteBuffer right = rf.getBuffer();
        int tupleCount = this.getTupleCount();
        int prefixTupleCount = this.getPrefixTupleCount();
        int midSlotNum = tupleCount / 2;
        BTreeFieldPrefixNSMLeafFrame targetFrame = null;
        this.frameTuple.resetByTupleIndex(this, midSlotNum);
        int comparison = this.cmp.compare(tuple, (ITupleReference)this.frameTuple);
        if (comparison >= 0) {
            tuplesToLeft = midSlotNum + tupleCount % 2;
            targetFrame = rf;
        } else {
            tuplesToLeft = midSlotNum;
            targetFrame = this;
        }
        int tuplesToRight = tupleCount - tuplesToLeft;
        System.arraycopy(this.buf.array(), 0, right.array(), 0, this.buf.capacity());
        int prefixesToLeft = prefixTupleCount;
        for (int i = tuplesToLeft; i < tupleCount; ++i) {
            int tupleSlotOff = rf.slotManager.getTupleSlotOff(i);
            int tupleSlot = right.getInt(tupleSlotOff);
            int prefixSlotNum = rf.slotManager.decodeFirstSlotField(tupleSlot);
            if (prefixSlotNum == 255) continue;
            prefixesToLeft = prefixSlotNum;
            break;
        }
        int boundaryTupleSlotOff = rf.slotManager.getTupleSlotOff(tuplesToLeft - 1);
        int boundaryTupleSlot = this.buf.getInt(boundaryTupleSlotOff);
        int boundaryPrefixSlotNum = rf.slotManager.decodeFirstSlotField(boundaryTupleSlot);
        int prefixesToRight = prefixTupleCount - prefixesToLeft;
        if (boundaryPrefixSlotNum == prefixesToLeft && boundaryPrefixSlotNum != 255) {
            ++prefixesToLeft;
        }
        if (prefixesToRight > 0 && prefixesToLeft > 0 && prefixTupleCount > 1) {
            int freeSpace = rf.getOrigFreeSpaceOff();
            int lastPrefixSlotNum = -1;
            for (int i = tuplesToLeft; i < tupleCount; ++i) {
                int tupleSlotOff = rf.slotManager.getTupleSlotOff(i);
                int tupleSlot = right.getInt(tupleSlotOff);
                int prefixSlotNum = rf.slotManager.decodeFirstSlotField(tupleSlot);
                if (prefixSlotNum == 255) continue;
                this.framePrefixTuple.resetByTupleIndex(this, prefixSlotNum);
                int bytesWritten = 0;
                if (lastPrefixSlotNum != prefixSlotNum) {
                    bytesWritten = this.tupleWriter.writeTuple((ITupleReference)this.framePrefixTuple, right.array(), freeSpace);
                    int newPrefixSlot = rf.slotManager.encodeSlotFields(this.framePrefixTuple.getFieldCount(), freeSpace);
                    int prefixSlotOff = rf.slotManager.getPrefixSlotOff(prefixSlotNum);
                    right.putInt(prefixSlotOff, newPrefixSlot);
                    lastPrefixSlotNum = prefixSlotNum;
                }
                int tupleOff = rf.slotManager.decodeSecondSlotField(tupleSlot);
                int newTupleSlot = rf.slotManager.encodeSlotFields(prefixSlotNum - (prefixTupleCount - prefixesToRight), tupleOff);
                right.putInt(tupleSlotOff, newTupleSlot);
                freeSpace += bytesWritten;
            }
        }
        int prefixSrc = rf.slotManager.getPrefixSlotEndOff();
        int prefixDest = rf.slotManager.getPrefixSlotEndOff() + (prefixTupleCount - prefixesToRight) * rf.slotManager.getSlotSize();
        int prefixLength = rf.slotManager.getSlotSize() * prefixesToRight;
        System.arraycopy(right.array(), prefixSrc, right.array(), prefixDest, prefixLength);
        int src = rf.slotManager.getTupleSlotEndOff();
        int dest = rf.slotManager.getTupleSlotEndOff() + tuplesToLeft * rf.slotManager.getSlotSize() + (prefixTupleCount - prefixesToRight) * rf.slotManager.getSlotSize();
        int length = rf.slotManager.getSlotSize() * tuplesToRight;
        System.arraycopy(right.array(), src, right.array(), dest, length);
        right.putInt(0, tuplesToRight);
        right.putInt(26, prefixesToRight);
        src = this.slotManager.getTupleSlotEndOff() + tuplesToRight * this.slotManager.getSlotSize();
        dest = this.slotManager.getTupleSlotEndOff() + tuplesToRight * this.slotManager.getSlotSize() + (prefixTupleCount - prefixesToLeft) * this.slotManager.getSlotSize();
        length = this.slotManager.getSlotSize() * tuplesToLeft;
        System.arraycopy(this.buf.array(), src, this.buf.array(), dest, length);
        this.buf.putInt(0, tuplesToLeft);
        this.buf.putInt(26, prefixesToLeft);
        this.compact();
        rightFrame.compact();
        int targetTupleIndex = ((IBTreeLeafFrame)targetFrame).findInsertTupleIndex(tuple);
        targetFrame.insert(tuple, targetTupleIndex);
        this.frameTuple.resetByTupleIndex(this, this.getTupleCount() - 1);
        int splitKeySize = this.tupleWriter.bytesRequired((ITupleReference)this.frameTuple, 0, this.cmp.getKeyFieldCount());
        splitKey.initData(splitKeySize);
        this.tupleWriter.writeTupleFields((ITupleReference)this.frameTuple, 0, this.cmp.getKeyFieldCount(), splitKey.getBuffer().array(), 0);
        splitKey.getTuple().resetByTupleOffset(splitKey.getBuffer().array(), 0);
    }

    public int getFreeSpaceOff() {
        return this.buf.getInt(4);
    }

    public int getOrigFreeSpaceOff() {
        return 34;
    }

    public void setFreeSpaceOff(int freeSpace) {
        this.buf.putInt(4, freeSpace);
    }

    @Override
    public void setNextLeaf(int page) {
        this.buf.putInt(30, page);
    }

    @Override
    public int getNextLeaf() {
        return this.buf.getInt(30);
    }

    public int getUncompressedTupleCount() {
        return this.buf.getInt(22);
    }

    public void setUncompressedTupleCount(int uncompressedTupleCount) {
        this.buf.putInt(22, uncompressedTupleCount);
    }

    public int getSlotSize() {
        return this.slotManager.getSlotSize();
    }

    public BTreeTypeAwareTupleWriter getTupleWriter() {
        return this.tupleWriter;
    }

    public IBTreeIndexTupleReference createTupleReference() {
        return new BTreeFieldPrefixTupleReference(this.tupleWriter.createTupleReference());
    }

    @Override
    public int findTupleIndex(ITupleReference searchKey, ITreeIndexTupleReference pageTuple, MultiComparator cmp, FindTupleMode ftm, FindTupleNoExactMatchPolicy ftp) throws HyracksDataException {
        int slot = this.slotManager.findSlot(searchKey, pageTuple, (ITreeIndexTupleReference)this.framePrefixTuple, cmp, ftm, ftp);
        int tupleIndex = this.slotManager.decodeSecondSlotField(slot);
        if (tupleIndex == 0xFFFFFF || tupleIndex == 0xFFFFFE) {
            return -1;
        }
        return tupleIndex;
    }

    @Override
    public int findTupleIndex(ITupleReference searchKey, ITreeIndexTupleReference pageTuple, MultiComparator cmp, int startIndex) throws HyracksDataException {
        throw new UnsupportedOperationException("Stateful search is not supported by BTreeFieldPrefixNSMLeafFrame");
    }

    public int getPageHeaderSize() {
        return 30;
    }

    public void setMultiComparator(MultiComparator cmp) {
        this.cmp = cmp;
        this.slotManager.setMultiComparator(cmp);
    }

    @Override
    public void validate(BTreeOpContext.PageValidationInfo pvi) {
    }

    @Override
    public void ensureCapacity(IBufferCache bufferCache, ITupleReference tuple, IExtraPageBlockHelper helper) throws HyracksDataException {
        throw new IllegalStateException("nyi");
    }

    public ITupleReference getLeftmostTuple() throws HyracksDataException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public ITupleReference getRightmostTuple() throws HyracksDataException {
        throw new UnsupportedOperationException("Not implemented");
    }
}

