/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.channel;

import io.netty.resolver.AddressResolver;
import io.netty.resolver.AddressResolverGroup;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import reactor.netty.channel.ChannelMetricsRecorder;

final class AddressResolverGroupMetrics
extends AddressResolverGroup<SocketAddress> {
    final AddressResolverGroup<SocketAddress> resolverGroup;
    final ChannelMetricsRecorder recorder;

    AddressResolverGroupMetrics(AddressResolverGroup<SocketAddress> resolverGroup, @Nullable ChannelMetricsRecorder recorder) {
        this.resolverGroup = resolverGroup;
        this.recorder = recorder;
    }

    protected AddressResolver<SocketAddress> newResolver(EventExecutor executor) {
        final AddressResolver resolver = this.resolverGroup.getResolver(executor);
        return new AddressResolver<SocketAddress>(){

            public boolean isSupported(SocketAddress address) {
                return resolver.isSupported(address);
            }

            public boolean isResolved(SocketAddress address) {
                return resolver.isResolved(address);
            }

            public Future<SocketAddress> resolve(SocketAddress address) {
                return this.resolveInternal(address, () -> resolver.resolve(address));
            }

            public Future<SocketAddress> resolve(SocketAddress address, Promise<SocketAddress> promise) {
                return this.resolveInternal(address, () -> resolver.resolve(address, promise));
            }

            public Future<List<SocketAddress>> resolveAll(SocketAddress address) {
                return this.resolveAllInternal(address, () -> resolver.resolveAll(address));
            }

            public Future<List<SocketAddress>> resolveAll(SocketAddress address, Promise<List<SocketAddress>> promise) {
                return this.resolveAllInternal(address, () -> resolver.resolveAll(address, promise));
            }

            public void close() {
                resolver.close();
            }

            Future<SocketAddress> resolveInternal(SocketAddress address, Supplier<Future<SocketAddress>> resolver2) {
                long resolveTimeStart = System.nanoTime();
                return resolver2.get().addListener(future -> this.record(resolveTimeStart, future.isSuccess() ? "SUCCESS" : "ERROR", address));
            }

            Future<List<SocketAddress>> resolveAllInternal(SocketAddress address, Supplier<Future<List<SocketAddress>>> resolver2) {
                long resolveTimeStart = System.nanoTime();
                return resolver2.get().addListener(future -> this.record(resolveTimeStart, future.isSuccess() ? "SUCCESS" : "ERROR", address));
            }

            void record(long resolveTimeStart, String status, SocketAddress remoteAddress) {
                AddressResolverGroupMetrics.this.recorder.recordResolveAddressTime(remoteAddress, Duration.ofNanos(System.nanoTime() - resolveTimeStart), status);
            }
        };
    }
}

