/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.declared;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.external.api.ITypedAdapterFactory;
import org.apache.asterix.metadata.IDatasetDetails;
import org.apache.asterix.metadata.MetadataManager;
import org.apache.asterix.metadata.declared.DataSource;
import org.apache.asterix.metadata.declared.DataSourceId;
import org.apache.asterix.metadata.declared.ExternalDataProjectionInfo;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.ExternalDatasetDetails;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.entities.InternalDatasetDetails;
import org.apache.asterix.metadata.utils.KeyFieldTypeUtil;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraint;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.metadata.IDataSource;
import org.apache.hyracks.algebricks.core.algebra.metadata.IProjectionInfo;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IOperatorSchema;
import org.apache.hyracks.algebricks.core.algebra.properties.INodeDomain;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenContext;
import org.apache.hyracks.algebricks.core.rewriter.base.PhysicalOptimizationConfig;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.storage.am.common.api.ITupleFilterFactory;

public class DatasetDataSource
extends DataSource {
    private final Dataset dataset;

    public DatasetDataSource(DataSourceId id, Dataset dataset, IAType itemType, IAType metaItemType, byte datasourceType, IDatasetDetails datasetDetails, INodeDomain datasetDomain) throws AlgebricksException {
        super(id, itemType, metaItemType, datasourceType, datasetDomain);
        this.dataset = dataset;
        switch (dataset.getDatasetType()) {
            case INTERNAL: {
                this.initInternalDataset(itemType, metaItemType, datasetDetails);
                break;
            }
            case EXTERNAL: {
                this.initExternalDataset(itemType);
            }
        }
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    private void initInternalDataset(IAType itemType, IAType metaItemType, IDatasetDetails datasetDetails) throws AlgebricksException {
        InternalDatasetDetails internalDatasetDetails = (InternalDatasetDetails)datasetDetails;
        ARecordType recordType = (ARecordType)itemType;
        ARecordType metaRecordType = (ARecordType)metaItemType;
        List<IAType> partitioningKeyTypes = KeyFieldTypeUtil.getPartitioningKeyTypes(internalDatasetDetails, recordType, metaRecordType);
        int n = partitioningKeyTypes.size();
        this.schemaTypes = metaItemType == null ? new IAType[n + 1] : new IAType[n + 2];
        for (int keyIndex = 0; keyIndex < n; ++keyIndex) {
            this.schemaTypes[keyIndex] = partitioningKeyTypes.get(keyIndex);
        }
        this.schemaTypes[n] = itemType;
        if (metaItemType != null) {
            this.schemaTypes[n + 1] = metaItemType;
        }
    }

    private void initExternalDataset(IAType itemType) {
        this.schemaTypes = new IAType[1];
        this.schemaTypes[0] = itemType;
    }

    @Override
    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> buildDatasourceScanRuntime(MetadataProvider metadataProvider, IDataSource<DataSourceId> dataSource, List<LogicalVariable> scanVariables, List<LogicalVariable> projectVariables, boolean projectPushed, List<LogicalVariable> minFilterVars, List<LogicalVariable> maxFilterVars, ITupleFilterFactory tupleFilterFactory, long outputLimit, IOperatorSchema opSchema, IVariableTypeEnvironment typeEnv, JobGenContext context, JobSpecification jobSpec, Object implConfig, IProjectionInfo<?> projectionInfo) throws AlgebricksException {
        switch (this.dataset.getDatasetType()) {
            case EXTERNAL: {
                Dataset externalDataset = ((DatasetDataSource)dataSource).getDataset();
                String itemTypeName = externalDataset.getItemTypeName();
                IAType itemType = MetadataManager.INSTANCE.getDatatype(metadataProvider.getMetadataTxnContext(), externalDataset.getItemTypeDataverseName(), itemTypeName).getDatatype();
                ExternalDatasetDetails edd = (ExternalDatasetDetails)externalDataset.getDatasetDetails();
                PhysicalOptimizationConfig physicalOptimizationConfig = context.getPhysicalOptimizationConfig();
                int externalScanBufferSize = physicalOptimizationConfig.getExternalScanBufferSize();
                Map<String, String> properties = this.addProjectionInfo(projectionInfo, edd.getProperties());
                properties.put("external-scan-buffer-size", String.valueOf(externalScanBufferSize));
                ITypedAdapterFactory adapterFactory = metadataProvider.getConfiguredAdapterFactory(externalDataset, edd.getAdapter(), properties, (ARecordType)itemType, null, context.getWarningCollector());
                return metadataProvider.buildExternalDatasetDataScannerRuntime(jobSpec, itemType, adapterFactory, tupleFilterFactory, outputLimit);
            }
            case INTERNAL: {
                DataSourceId id = this.getId();
                DataverseName dataverseName = id.getDataverseName();
                String datasetName = id.getDatasourceName();
                Index primaryIndex = MetadataManager.INSTANCE.getIndex(metadataProvider.getMetadataTxnContext(), dataverseName, datasetName, datasetName);
                int[] minFilterFieldIndexes = this.createFilterIndexes(minFilterVars, opSchema);
                int[] maxFilterFieldIndexes = this.createFilterIndexes(maxFilterVars, opSchema);
                return metadataProvider.buildBtreeRuntime(jobSpec, opSchema, typeEnv, context, true, false, ((DatasetDataSource)dataSource).getDataset(), primaryIndex.getIndexName(), null, null, true, true, false, minFilterFieldIndexes, maxFilterFieldIndexes, tupleFilterFactory, outputLimit, false, false);
            }
        }
        throw new AlgebricksException("Unknown datasource type");
    }

    private Map<String, String> addProjectionInfo(IProjectionInfo<?> projectionInfo, Map<String, String> properties) {
        Map<String, String> propertiesCopy = properties;
        if (projectionInfo != null) {
            propertiesCopy = new HashMap<String, String>(properties);
            ExternalDataProjectionInfo fieldNamesInfo = (ExternalDataProjectionInfo)projectionInfo;
            fieldNamesInfo.addToProperties(propertiesCopy);
        }
        return propertiesCopy;
    }

    private int[] createFilterIndexes(List<LogicalVariable> filterVars, IOperatorSchema opSchema) {
        if (filterVars != null && !filterVars.isEmpty()) {
            int size = filterVars.size();
            int[] result = new int[size];
            for (int i = 0; i < size; ++i) {
                result[i] = opSchema.findVariable(filterVars.get(i));
            }
            return result;
        }
        return null;
    }

    public boolean isScanAccessPathALeaf() {
        return this.dataset.getDatasetType() == DatasetConfig.DatasetType.EXTERNAL;
    }
}

