/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.hdfs.parquet;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.AbstractComplexConverter;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.IFieldValue;
import org.apache.asterix.external.input.stream.StandardUTF8ToModifiedUTF8DataOutput;
import org.apache.asterix.external.parser.jackson.ParserContext;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.PrimitiveConverter;

class AtomicConverter
extends PrimitiveConverter
implements IFieldValue {
    private final AbstractComplexConverter parent;
    private final IValueReference fieldName;
    private final int index;
    private final ParserContext context;

    public AtomicConverter(AbstractComplexConverter parent, int index, ParserContext context) {
        this(parent, null, index, context);
    }

    public AtomicConverter(AbstractComplexConverter parent, IValueReference fieldName, int index, ParserContext context) {
        this.parent = parent;
        this.fieldName = fieldName;
        this.index = index;
        this.context = context;
    }

    public void addBinary(Binary value) {
        DataOutput out = this.parent.getDataOutput();
        StandardUTF8ToModifiedUTF8DataOutput stringOut = this.context.getModifiedUTF8DataOutput();
        stringOut.setDataOutput(out);
        try {
            out.writeByte(ATypeTag.STRING.serialize());
            value.writeTo((DataOutput)stringOut);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this.parent.addValue(this);
    }

    public void addBoolean(boolean value) {
        DataOutput out = this.parent.getDataOutput();
        try {
            out.writeByte(ATypeTag.BOOLEAN.serialize());
            out.writeBoolean(value);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this.parent.addValue(this);
    }

    public void addFloat(float value) {
        this.addDouble(value);
    }

    public void addDouble(double value) {
        DataOutput out = this.parent.getDataOutput();
        try {
            out.writeByte(ATypeTag.DOUBLE.serialize());
            out.writeDouble(value);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this.parent.addValue(this);
    }

    public void addInt(int value) {
        this.addLong(value);
    }

    public void addLong(long value) {
        DataOutput out = this.parent.getDataOutput();
        try {
            out.writeByte(ATypeTag.BIGINT.serialize());
            out.writeLong(value);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this.parent.addValue(this);
    }

    @Override
    public IValueReference getFieldName() {
        return this.fieldName;
    }

    @Override
    public int getIndex() {
        return this.index;
    }
}

