/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.cloud.lazy.accessor;

import java.io.FilenameFilter;
import java.util.Collections;
import java.util.Set;
import org.apache.asterix.cloud.CloudFileHandle;
import org.apache.asterix.cloud.bulk.IBulkOperationCallBack;
import org.apache.asterix.cloud.clients.ICloudClient;
import org.apache.asterix.cloud.lazy.IParallelCacher;
import org.apache.asterix.cloud.lazy.accessor.AbstractLazyAccessor;
import org.apache.asterix.cloud.lazy.accessor.ILazyAccessorReplacer;
import org.apache.asterix.common.utils.StoragePathUtil;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.control.nc.io.IOManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReplaceableCloudAccessor
extends AbstractLazyAccessor {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Set<Integer> partitions;
    private final ILazyAccessorReplacer replacer;
    private final IParallelCacher cacher;
    private final IBulkOperationCallBack deleteCallBack;

    public ReplaceableCloudAccessor(ICloudClient cloudClient, String bucket, IOManager localIoManager, Set<Integer> partitions, ILazyAccessorReplacer replacer, IParallelCacher cacher) {
        super(cloudClient, bucket, localIoManager);
        this.partitions = partitions;
        this.replacer = replacer;
        this.cacher = cacher;
        this.deleteCallBack = deletedFiles -> {
            if (cacher.remove(deletedFiles)) {
                this.replace();
            }
        };
    }

    @Override
    public boolean isLocalAccessor() {
        return false;
    }

    @Override
    public IBulkOperationCallBack getBulkOperationCallBack() {
        return this.deleteCallBack;
    }

    @Override
    public void doOnOpen(CloudFileHandle fileHandle, IIOManager.FileReadWriteMode rwMode, IIOManager.FileSyncMode syncMode) throws HyracksDataException {
        FileReference fileRef = fileHandle.getFileReference();
        if (!this.localIoManager.exists(fileRef) && this.cloudClient.exists(this.bucket, fileRef.getRelativePath()) && this.cacher.downloadData(fileRef)) {
            this.replace();
        }
    }

    @Override
    public Set<FileReference> doList(FileReference dir, FilenameFilter filter) throws HyracksDataException {
        if (ReplaceableCloudAccessor.isTxnDir(dir)) {
            return this.cloudBackedList(dir, filter);
        }
        Set localList = this.localIoManager.list(dir, filter);
        Set<FileReference> uncachedFiles = this.cacher.getUncachedFiles(dir, filter);
        localList.addAll(uncachedFiles);
        return localList;
    }

    private static boolean isTxnDir(FileReference dir) {
        return dir.getRelativePath().startsWith("mtd-txn-logs") || dir.getName().equals(".");
    }

    @Override
    public boolean doExists(FileReference fileRef) throws HyracksDataException {
        return this.localIoManager.exists(fileRef) || this.cloudClient.exists(this.bucket, fileRef.getRelativePath());
    }

    @Override
    public long doGetSize(FileReference fileReference) throws HyracksDataException {
        if (this.localIoManager.exists(fileReference)) {
            return this.localIoManager.getSize(fileReference);
        }
        return this.cloudClient.getObjectSize(this.bucket, fileReference.getRelativePath());
    }

    @Override
    public byte[] doReadAllBytes(FileReference fileRef) throws HyracksDataException {
        if (!this.localIoManager.exists(fileRef) && this.isInNodePartition(fileRef.getRelativePath()) && this.cacher.downloadMetadata(fileRef)) {
            this.replace();
        }
        return this.localIoManager.readAllBytes(fileRef);
    }

    @Override
    public void doDelete(FileReference fileReference) throws HyracksDataException {
        Set<FileReference> deletedFiles = this.doCloudDelete(fileReference);
        if (this.cacher.remove(deletedFiles)) {
            this.replace();
        }
        this.localIoManager.delete(fileReference);
    }

    @Override
    public void doOverwrite(FileReference fileReference, byte[] bytes) throws HyracksDataException {
        boolean existsLocally = this.localIoManager.exists(fileReference);
        this.cloudClient.write(this.bucket, fileReference.getRelativePath(), bytes);
        this.localIoManager.overwrite(fileReference, bytes);
        if (!existsLocally && this.cacher.remove(fileReference)) {
            this.replace();
        }
    }

    private Set<FileReference> cloudBackedList(FileReference dir, FilenameFilter filter) throws HyracksDataException {
        LOGGER.debug("CLOUD LIST: {}", (Object)dir);
        Set<String> cloudFiles = this.cloudClient.listObjects(this.bucket, dir.getRelativePath(), filter);
        if (cloudFiles.isEmpty()) {
            return Collections.emptySet();
        }
        Set localFiles = this.localIoManager.list(dir, filter);
        for (FileReference file : localFiles) {
            String path = file.getRelativePath();
            if (!cloudFiles.contains(path)) {
                throw new IllegalStateException("Local file is not clean. Offending path: " + path);
            }
            cloudFiles.remove(path);
        }
        for (String cloudFile : cloudFiles) {
            FileReference localFile = this.localIoManager.resolve(cloudFile);
            if (!this.isInNodePartition(cloudFile) || !StoragePathUtil.hasSameStorageRoot((FileReference)dir, (FileReference)localFile)) continue;
            localFiles.add(localFile);
        }
        return localFiles;
    }

    private boolean isInNodePartition(String path) {
        return this.partitions.contains(StoragePathUtil.getPartitionNumFromRelativePath((String)path));
    }

    private void replace() {
        this.cacher.close();
        this.replacer.replace();
    }
}

