/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.assembler;

import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.asterix.column.assembler.AbstractPrimitiveValueAssembler;
import org.apache.asterix.column.assembler.AssemblerInfo;
import org.apache.asterix.column.assembler.AssemblerState;
import org.apache.asterix.column.assembler.value.IValueGetter;
import org.apache.asterix.column.bytes.stream.in.AbstractBytesInputStream;
import org.apache.asterix.column.values.IColumnValuesReader;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.lsm.btree.column.error.ColumnarValueException;

final class PrimitiveValueAssembler
extends AbstractPrimitiveValueAssembler {
    private final boolean primaryKey;

    PrimitiveValueAssembler(int level, AssemblerInfo info, IColumnValuesReader reader, IValueGetter primitiveValue, boolean primaryKey) {
        super(level, info, reader, primitiveValue);
        this.primaryKey = primaryKey;
    }

    @Override
    public void reset(AbstractBytesInputStream in, int numberOfTuples) throws HyracksDataException {
        if (!this.primaryKey) {
            this.reader.reset(in, numberOfTuples);
        }
    }

    @Override
    public int next(AssemblerState state) throws HyracksDataException {
        if (!this.primaryKey && !this.reader.next()) {
            throw this.createException();
        }
        if (this.reader.isNull() && (this.isDelegate() || this.reader.getLevel() + 1 == this.level)) {
            this.addNullToAncestor(this.reader.getLevel());
        } else if (this.reader.isMissing() && this.isDelegate() && this.reader.getLevel() < this.level) {
            this.addMissingToAncestor(this.reader.getLevel());
        } else if (this.reader.isValue()) {
            this.addValueToParent();
        }
        if (this.isDelegate()) {
            this.getParent().end();
        }
        return -1;
    }

    private ColumnarValueException createException() {
        ColumnarValueException e = new ColumnarValueException();
        ObjectNode assemblerNode = e.createNode(this.getClass().getSimpleName());
        assemblerNode.put("isDelegate", this.isDelegate());
        ObjectNode readerNode = assemblerNode.putObject("assemblerReader");
        this.reader.appendReaderInformation(readerNode);
        return e;
    }
}

