/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.operation.lsm.merge;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.column.metadata.AbstractColumnImmutableMetadata;
import org.apache.asterix.column.operation.lsm.flush.FlushColumnMetadata;
import org.apache.asterix.column.values.IColumnValuesWriter;
import org.apache.asterix.column.values.writer.ColumnValuesWriterFactory;
import org.apache.asterix.om.types.ARecordType;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.storage.am.lsm.btree.column.api.IColumnTupleIterator;
import org.apache.hyracks.storage.am.lsm.btree.column.api.IColumnWriteMultiPageOp;

public final class MergeColumnWriteMetadata
extends AbstractColumnImmutableMetadata {
    private final Mutable<IColumnWriteMultiPageOp> multiPageOpRef;
    private final List<IColumnValuesWriter> columnWriters;
    private final List<IColumnTupleIterator> componentsTuples;

    private MergeColumnWriteMetadata(ARecordType datasetType, ARecordType metaType, int numberOfPrimaryKeys, Mutable<IColumnWriteMultiPageOp> multiPageOpRef, List<IColumnValuesWriter> columnWriters, IValueReference serializedMetadata, List<IColumnTupleIterator> componentsTuples) {
        super(datasetType, metaType, numberOfPrimaryKeys, serializedMetadata, columnWriters.size());
        this.multiPageOpRef = multiPageOpRef;
        this.columnWriters = columnWriters;
        this.componentsTuples = componentsTuples;
    }

    public void init(IColumnWriteMultiPageOp multiPageOp) throws HyracksDataException {
        this.multiPageOpRef.setValue((Object)multiPageOp);
        for (int i = 0; i < this.columnWriters.size(); ++i) {
            this.columnWriters.get(i).reset();
        }
    }

    public Mutable<IColumnWriteMultiPageOp> getMultiPageOpRef() {
        return this.multiPageOpRef;
    }

    public IColumnValuesWriter getWriter(int columnIndex) {
        return this.columnWriters.get(columnIndex);
    }

    public void close() {
        this.multiPageOpRef.setValue(null);
        for (int i = 0; i < this.columnWriters.size(); ++i) {
            this.columnWriters.get(i).close();
        }
    }

    public static MergeColumnWriteMetadata create(ARecordType datasetType, ARecordType metaType, int numberOfPrimaryKeys, Mutable<IColumnWriteMultiPageOp> multiPageOpRef, IValueReference serializedMetadata, List<IColumnTupleIterator> componentsTuples) throws IOException {
        byte[] bytes = serializedMetadata.getByteArray();
        int offset = serializedMetadata.getStartOffset();
        int length = serializedMetadata.getLength();
        int writersOffset = offset + IntegerPointable.getInteger((byte[])bytes, (int)(offset + 0));
        DataInputStream input = new DataInputStream(new ByteArrayInputStream(bytes, writersOffset, length));
        ColumnValuesWriterFactory writerFactory = new ColumnValuesWriterFactory(multiPageOpRef);
        ArrayList<IColumnValuesWriter> writers = new ArrayList<IColumnValuesWriter>();
        FlushColumnMetadata.deserializeWriters(input, writers, writerFactory);
        return new MergeColumnWriteMetadata(datasetType, metaType, numberOfPrimaryKeys, multiPageOpRef, writers, serializedMetadata, componentsTuples);
    }

    public List<IColumnTupleIterator> getComponentsTuples() {
        return this.componentsTuples;
    }
}

