/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.compute.options;

import com.google.common.base.Charsets;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.scriptbuilder.domain.Statement;

public class CloudStackTemplateOptions
extends TemplateOptions
implements Cloneable {
    private Set<String> securityGroupIds = ImmutableSet.of();
    private Map<String, String> ipsToNetworks = ImmutableMap.of();
    private String ipOnDefaultNetwork;
    private String keyPair;
    private boolean setupStaticNat = true;
    private String account;
    private String domainId;
    private boolean generateKeyPair = false;
    private boolean generateSecurityGroup = false;
    private String diskOfferingId;
    private int dataDiskSize;
    private byte[] userData;

    public CloudStackTemplateOptions securityGroupIds(Iterable<String> securityGroupIds) {
        this.securityGroupIds = ImmutableSet.copyOf(securityGroupIds);
        return this;
    }

    public CloudStackTemplateOptions ipsToNetworks(Map<String, String> ipsToNetworks) {
        this.ipsToNetworks = ImmutableMap.copyOf(ipsToNetworks);
        return this;
    }

    public CloudStackTemplateOptions ipOnDefaultNetwork(String ipOnDefaultNetwork) {
        this.ipOnDefaultNetwork = ipOnDefaultNetwork;
        return this;
    }

    public CloudStackTemplateOptions keyPair(String keyPair) {
        this.keyPair = keyPair;
        return this;
    }

    public CloudStackTemplateOptions setupStaticNat(boolean setupStaticNat) {
        this.setupStaticNat = setupStaticNat;
        return this;
    }

    public CloudStackTemplateOptions account(String account) {
        this.account = account;
        return this;
    }

    public CloudStackTemplateOptions domainId(String domainId) {
        this.domainId = domainId;
        return this;
    }

    public CloudStackTemplateOptions generateKeyPair(boolean generateKeyPair) {
        this.generateKeyPair = generateKeyPair;
        return this;
    }

    public CloudStackTemplateOptions generateSecurityGroup(boolean generateSecurityGroup) {
        this.generateSecurityGroup = generateSecurityGroup;
        return this;
    }

    public CloudStackTemplateOptions diskOfferingId(String diskOfferingId) {
        this.diskOfferingId = diskOfferingId;
        return this;
    }

    public CloudStackTemplateOptions dataDiskSize(int dataDiskSize) {
        this.dataDiskSize = dataDiskSize;
        return this;
    }

    public CloudStackTemplateOptions userData(byte[] userData) {
        this.userData = userData;
        return this;
    }

    public CloudStackTemplateOptions userData(String userData) {
        this.userData = ((String)Preconditions.checkNotNull((Object)userData, (Object)"userdata")).getBytes(Charsets.UTF_8);
        return this;
    }

    public CloudStackTemplateOptions userData(URL userDataUrl) throws IOException {
        this.userData = Resources.toString((URL)((URL)Preconditions.checkNotNull((Object)userDataUrl, (Object)"userDataUrl")), (Charset)Charsets.UTF_8).getBytes(Charsets.UTF_8);
        return this;
    }

    public Set<String> getSecurityGroupIds() {
        return this.securityGroupIds;
    }

    public Map<String, String> getIpsToNetworks() {
        return this.ipsToNetworks;
    }

    public String getIpOnDefaultNetwork() {
        return this.ipOnDefaultNetwork;
    }

    public String getKeyPair() {
        return this.keyPair;
    }

    public boolean shouldSetupStaticNat() {
        return this.setupStaticNat;
    }

    public String getAccount() {
        return this.account;
    }

    public String getDomainId() {
        return this.domainId;
    }

    public boolean shouldGenerateKeyPair() {
        return this.generateKeyPair;
    }

    public boolean shouldGenerateSecurityGroup() {
        return this.generateSecurityGroup;
    }

    public String getDiskOfferingId() {
        return this.diskOfferingId;
    }

    public int getDataDiskSize() {
        return this.dataDiskSize;
    }

    public byte[] getUserData() {
        return this.userData;
    }

    public CloudStackTemplateOptions clone() {
        CloudStackTemplateOptions options = new CloudStackTemplateOptions();
        this.copyTo(options);
        return options;
    }

    public void copyTo(TemplateOptions to) {
        super.copyTo(to);
        if (to instanceof CloudStackTemplateOptions) {
            CloudStackTemplateOptions eTo = (CloudStackTemplateOptions)CloudStackTemplateOptions.class.cast(to);
            eTo.securityGroupIds(this.securityGroupIds);
            eTo.ipsToNetworks(this.ipsToNetworks);
            eTo.ipOnDefaultNetwork(this.ipOnDefaultNetwork);
            eTo.keyPair(this.keyPair);
            eTo.generateKeyPair(this.generateKeyPair);
            eTo.generateSecurityGroup(this.generateSecurityGroup);
            eTo.account(this.account);
            eTo.domainId(this.domainId);
            eTo.setupStaticNat(this.setupStaticNat);
            eTo.diskOfferingId(this.diskOfferingId);
            eTo.dataDiskSize(this.dataDiskSize);
            eTo.userData(this.userData);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CloudStackTemplateOptions)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CloudStackTemplateOptions that = (CloudStackTemplateOptions)o;
        return this.setupStaticNat == that.setupStaticNat && this.generateKeyPair == that.generateKeyPair && this.generateSecurityGroup == that.generateSecurityGroup && this.dataDiskSize == that.dataDiskSize && Objects.equal(this.securityGroupIds, that.securityGroupIds) && Objects.equal(this.ipsToNetworks, that.ipsToNetworks) && Objects.equal((Object)this.ipOnDefaultNetwork, (Object)that.ipOnDefaultNetwork) && Objects.equal((Object)this.keyPair, (Object)that.keyPair) && Objects.equal((Object)this.account, (Object)that.account) && Objects.equal((Object)this.domainId, (Object)that.domainId) && Objects.equal((Object)this.diskOfferingId, (Object)that.diskOfferingId) && Arrays.equals(this.userData, that.userData);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.securityGroupIds, this.ipsToNetworks, this.ipOnDefaultNetwork, this.keyPair, this.setupStaticNat, this.account, this.domainId, this.generateKeyPair, this.generateSecurityGroup, this.diskOfferingId, this.dataDiskSize, Arrays.hashCode(this.userData)});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("securityGroupIds", this.securityGroupIds).add("ipsToNetworks", this.ipsToNetworks).add("ipOnDefaultNetwork", (Object)this.ipOnDefaultNetwork).add("keyPair", (Object)this.keyPair).add("setupStaticNat", this.setupStaticNat).add("account", (Object)this.account).add("domainId", (Object)this.domainId).add("generateKeyPair", this.generateKeyPair).add("generateSecurityGroup", this.generateSecurityGroup).add("diskOfferingId", (Object)this.diskOfferingId).add("dataDiskSize", this.dataDiskSize).add("userData", (Object)this.userData).toString();
    }

    public CloudStackTemplateOptions blockOnPort(int port, int seconds) {
        return (CloudStackTemplateOptions)CloudStackTemplateOptions.class.cast(super.blockOnPort(port, seconds));
    }

    public CloudStackTemplateOptions inboundPorts(int ... ports) {
        return (CloudStackTemplateOptions)CloudStackTemplateOptions.class.cast(super.inboundPorts(ports));
    }

    public CloudStackTemplateOptions authorizePublicKey(String publicKey) {
        return (CloudStackTemplateOptions)CloudStackTemplateOptions.class.cast(super.authorizePublicKey(publicKey));
    }

    public CloudStackTemplateOptions installPrivateKey(String privateKey) {
        return (CloudStackTemplateOptions)CloudStackTemplateOptions.class.cast(super.installPrivateKey(privateKey));
    }

    public CloudStackTemplateOptions blockUntilRunning(boolean blockUntilRunning) {
        return (CloudStackTemplateOptions)CloudStackTemplateOptions.class.cast(super.blockUntilRunning(blockUntilRunning));
    }

    public CloudStackTemplateOptions dontAuthorizePublicKey() {
        return (CloudStackTemplateOptions)CloudStackTemplateOptions.class.cast(super.dontAuthorizePublicKey());
    }

    public CloudStackTemplateOptions nameTask(String name) {
        return (CloudStackTemplateOptions)CloudStackTemplateOptions.class.cast(super.nameTask(name));
    }

    public CloudStackTemplateOptions runAsRoot(boolean runAsRoot) {
        return (CloudStackTemplateOptions)CloudStackTemplateOptions.class.cast(super.runAsRoot(runAsRoot));
    }

    public CloudStackTemplateOptions runScript(Statement script) {
        return (CloudStackTemplateOptions)CloudStackTemplateOptions.class.cast(super.runScript(script));
    }

    public CloudStackTemplateOptions overrideLoginCredentials(LoginCredentials overridingCredentials) {
        return (CloudStackTemplateOptions)CloudStackTemplateOptions.class.cast(super.overrideLoginCredentials(overridingCredentials));
    }

    public CloudStackTemplateOptions overrideLoginPassword(String password) {
        return (CloudStackTemplateOptions)CloudStackTemplateOptions.class.cast(super.overrideLoginPassword(password));
    }

    public CloudStackTemplateOptions overrideLoginPrivateKey(String privateKey) {
        return (CloudStackTemplateOptions)CloudStackTemplateOptions.class.cast(super.overrideLoginPrivateKey(privateKey));
    }

    public CloudStackTemplateOptions overrideLoginUser(String loginUser) {
        return (CloudStackTemplateOptions)CloudStackTemplateOptions.class.cast(super.overrideLoginUser(loginUser));
    }

    public CloudStackTemplateOptions overrideAuthenticateSudo(boolean authenticateSudo) {
        return (CloudStackTemplateOptions)CloudStackTemplateOptions.class.cast(super.overrideAuthenticateSudo(authenticateSudo));
    }

    public CloudStackTemplateOptions userMetadata(Map<String, String> userMetadata) {
        return (CloudStackTemplateOptions)CloudStackTemplateOptions.class.cast(super.userMetadata(userMetadata));
    }

    public CloudStackTemplateOptions userMetadata(String key, String value) {
        return (CloudStackTemplateOptions)CloudStackTemplateOptions.class.cast(super.userMetadata(key, value));
    }

    public CloudStackTemplateOptions nodeNames(Iterable<String> nodeNames) {
        return (CloudStackTemplateOptions)CloudStackTemplateOptions.class.cast(super.nodeNames(nodeNames));
    }

    public CloudStackTemplateOptions networks(Iterable<String> networks) {
        return (CloudStackTemplateOptions)CloudStackTemplateOptions.class.cast(super.networks(networks));
    }

    public static class Builder {
        public static CloudStackTemplateOptions securityGroupIds(Iterable<String> securityGroupIds) {
            CloudStackTemplateOptions options = new CloudStackTemplateOptions();
            return options.securityGroupIds(securityGroupIds);
        }

        public static CloudStackTemplateOptions ipsToNetworks(Map<String, String> ipToNetworkMap) {
            CloudStackTemplateOptions options = new CloudStackTemplateOptions();
            return options.ipsToNetworks(ipToNetworkMap);
        }

        public static CloudStackTemplateOptions ipOnDefaultNetwork(String ipAddress) {
            CloudStackTemplateOptions options = new CloudStackTemplateOptions();
            return options.ipOnDefaultNetwork(ipAddress);
        }

        public static CloudStackTemplateOptions keyPair(String keyPair) {
            CloudStackTemplateOptions options = new CloudStackTemplateOptions();
            return options.keyPair(keyPair);
        }

        public static CloudStackTemplateOptions setupStaticNat(boolean setupStaticNat) {
            CloudStackTemplateOptions options = new CloudStackTemplateOptions();
            return options.setupStaticNat(setupStaticNat);
        }

        public static CloudStackTemplateOptions account(String account) {
            CloudStackTemplateOptions options = new CloudStackTemplateOptions();
            return options.account(account);
        }

        public static CloudStackTemplateOptions domainId(String domainId) {
            CloudStackTemplateOptions options = new CloudStackTemplateOptions();
            return options.domainId(domainId);
        }

        public static CloudStackTemplateOptions generateKeyPair(boolean enable) {
            return new CloudStackTemplateOptions().generateKeyPair(enable);
        }

        public static CloudStackTemplateOptions generateSecurityGroup(boolean enable) {
            return new CloudStackTemplateOptions().generateSecurityGroup(enable);
        }

        public static CloudStackTemplateOptions diskOfferingId(String diskOfferingId) {
            CloudStackTemplateOptions options = new CloudStackTemplateOptions();
            return options.diskOfferingId(diskOfferingId);
        }

        public static CloudStackTemplateOptions dataDiskSize(int dataDiskSize) {
            CloudStackTemplateOptions options = new CloudStackTemplateOptions();
            return options.dataDiskSize(dataDiskSize);
        }

        public static CloudStackTemplateOptions userData(byte[] userData) {
            CloudStackTemplateOptions options = new CloudStackTemplateOptions();
            return options.userData(userData);
        }
    }
}

