/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.integrationspec.traits;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.builder.Editable;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import org.apache.camel.v1.integrationspec.traits.DeploymentBuilder;
import org.apache.camel.v1.integrationspec.traits.deployment.Configuration;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"configuration", "enabled", "progressDeadlineSeconds", "rollingUpdateMaxSurge", "rollingUpdateMaxUnavailable", "strategy"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class Deployment
implements Editable<DeploymentBuilder>,
KubernetesResource {
    @JsonProperty(value="configuration")
    @JsonPropertyDescription(value="Legacy trait configuration parameters. Deprecated: for backward compatibility.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Configuration configuration;
    @JsonProperty(value="enabled")
    @JsonPropertyDescription(value="Deprecated: no longer in use.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean enabled;
    @JsonProperty(value="progressDeadlineSeconds")
    @JsonPropertyDescription(value="The maximum time in seconds for the deployment to make progress before it is considered to be failed. It defaults to `60s`.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Integer progressDeadlineSeconds;
    @JsonProperty(value="rollingUpdateMaxSurge")
    @JsonPropertyDescription(value="The maximum number of pods that can be scheduled above the desired number of pods. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). This can not be 0 if MaxUnavailable is 0. Absolute number is calculated from percentage by rounding up. Defaults to `25%`.")
    @JsonSetter(nulls=Nulls.SKIP)
    private IntOrString rollingUpdateMaxSurge;
    @JsonProperty(value="rollingUpdateMaxUnavailable")
    @JsonPropertyDescription(value="The maximum number of pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). Absolute number is calculated from percentage by rounding down. This can not be 0 if MaxSurge is 0. Defaults to `25%`.")
    @JsonSetter(nulls=Nulls.SKIP)
    private IntOrString rollingUpdateMaxUnavailable;
    @JsonProperty(value="strategy")
    @JsonPropertyDescription(value="The deployment strategy to use to replace existing pods with new ones.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Strategy strategy;

    public DeploymentBuilder edit() {
        return new DeploymentBuilder(this);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Integer getProgressDeadlineSeconds() {
        return this.progressDeadlineSeconds;
    }

    public void setProgressDeadlineSeconds(Integer progressDeadlineSeconds) {
        this.progressDeadlineSeconds = progressDeadlineSeconds;
    }

    public IntOrString getRollingUpdateMaxSurge() {
        return this.rollingUpdateMaxSurge;
    }

    public void setRollingUpdateMaxSurge(IntOrString rollingUpdateMaxSurge) {
        this.rollingUpdateMaxSurge = rollingUpdateMaxSurge;
    }

    public IntOrString getRollingUpdateMaxUnavailable() {
        return this.rollingUpdateMaxUnavailable;
    }

    public void setRollingUpdateMaxUnavailable(IntOrString rollingUpdateMaxUnavailable) {
        this.rollingUpdateMaxUnavailable = rollingUpdateMaxUnavailable;
    }

    public Strategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(Strategy strategy) {
        this.strategy = strategy;
    }

    public String toString() {
        return "Deployment(configuration=" + this.getConfiguration() + ", enabled=" + this.getEnabled() + ", progressDeadlineSeconds=" + this.getProgressDeadlineSeconds() + ", rollingUpdateMaxSurge=" + this.getRollingUpdateMaxSurge() + ", rollingUpdateMaxUnavailable=" + this.getRollingUpdateMaxUnavailable() + ", strategy=" + this.getStrategy() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Deployment)) {
            return false;
        }
        Deployment other = (Deployment)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$enabled = this.getEnabled();
        Boolean other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        Integer this$progressDeadlineSeconds = this.getProgressDeadlineSeconds();
        Integer other$progressDeadlineSeconds = other.getProgressDeadlineSeconds();
        if (this$progressDeadlineSeconds == null ? other$progressDeadlineSeconds != null : !((Object)this$progressDeadlineSeconds).equals(other$progressDeadlineSeconds)) {
            return false;
        }
        Configuration this$configuration = this.getConfiguration();
        Configuration other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !((Object)this$configuration).equals(other$configuration)) {
            return false;
        }
        IntOrString this$rollingUpdateMaxSurge = this.getRollingUpdateMaxSurge();
        IntOrString other$rollingUpdateMaxSurge = other.getRollingUpdateMaxSurge();
        if (this$rollingUpdateMaxSurge == null ? other$rollingUpdateMaxSurge != null : !this$rollingUpdateMaxSurge.equals(other$rollingUpdateMaxSurge)) {
            return false;
        }
        IntOrString this$rollingUpdateMaxUnavailable = this.getRollingUpdateMaxUnavailable();
        IntOrString other$rollingUpdateMaxUnavailable = other.getRollingUpdateMaxUnavailable();
        if (this$rollingUpdateMaxUnavailable == null ? other$rollingUpdateMaxUnavailable != null : !this$rollingUpdateMaxUnavailable.equals(other$rollingUpdateMaxUnavailable)) {
            return false;
        }
        Strategy this$strategy = this.getStrategy();
        Strategy other$strategy = other.getStrategy();
        return !(this$strategy == null ? other$strategy != null : !((Object)((Object)this$strategy)).equals((Object)other$strategy));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Deployment;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $enabled = this.getEnabled();
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        Integer $progressDeadlineSeconds = this.getProgressDeadlineSeconds();
        result = result * 59 + ($progressDeadlineSeconds == null ? 43 : ((Object)$progressDeadlineSeconds).hashCode());
        Configuration $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : ((Object)$configuration).hashCode());
        IntOrString $rollingUpdateMaxSurge = this.getRollingUpdateMaxSurge();
        result = result * 59 + ($rollingUpdateMaxSurge == null ? 43 : $rollingUpdateMaxSurge.hashCode());
        IntOrString $rollingUpdateMaxUnavailable = this.getRollingUpdateMaxUnavailable();
        result = result * 59 + ($rollingUpdateMaxUnavailable == null ? 43 : $rollingUpdateMaxUnavailable.hashCode());
        Strategy $strategy = this.getStrategy();
        result = result * 59 + ($strategy == null ? 43 : ((Object)((Object)$strategy)).hashCode());
        return result;
    }

    public static enum Strategy {
        RECREATE("Recreate"),
        ROLLINGUPDATE("RollingUpdate");

        String value;

        private Strategy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }
    }
}

