/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.pref;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.pref.CayennePreference;
import org.apache.cayenne.pref.PreferenceDecorator;

public class ChildrenMapPreference
extends PreferenceDecorator {
    private Map<String, Object> children;
    private List<String> removeObject;

    public ChildrenMapPreference(CayennePreference delegate) {
        super(delegate);
        this.children = new HashMap<String, Object>();
        this.removeObject = new ArrayList<String>();
    }

    public ChildrenMapPreference(CayennePreference delegate, Preferences preferences) {
        super(delegate);
        delegate.setCurrentPreference(preferences);
        this.children = new HashMap<String, Object>();
    }

    public void initChildrenPreferences() {
        HashMap children = new HashMap();
        try {
            String[] names = this.getCurrentPreference().childrenNames();
            for (int i = 0; i < names.length; ++i) {
                try {
                    Class<?> cls = this.delegate.getClass();
                    Class[] partypes = new Class[]{String.class, Boolean.TYPE};
                    Constructor<?> ct = cls.getConstructor(partypes);
                    Object[] arglist = new Object[]{names[i], true};
                    Object retobj = ct.newInstance(arglist);
                    children.put(names[i], retobj);
                    continue;
                }
                catch (Throwable e) {
                    new CayenneRuntimeException("Error initializing preference", e, new Object[0]);
                }
            }
            this.children.putAll(children);
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }

    public Map getChildrenPreferences() {
        return this.children;
    }

    public CayennePreference getObject(String key) {
        return (CayennePreference)this.children.get(key);
    }

    public void remove(String key) {
        this.removeObject.add(key);
        this.children.remove(key);
    }

    public CayennePreference create(String nodeName) {
        try {
            Class<?> cls = this.delegate.getClass();
            Class[] partypes = new Class[]{String.class, Boolean.TYPE};
            Constructor<?> ct = cls.getConstructor(partypes);
            Object[] arglist = new Object[]{nodeName, false};
            Object retobj = ct.newInstance(arglist);
            this.children.put(nodeName, retobj);
        }
        catch (Throwable e) {
            new CayenneRuntimeException("Error creating preference", new Object[0]);
        }
        return (CayennePreference)this.children.get(nodeName);
    }

    public void create(String nodeName, Object obj) {
        this.children.put(nodeName, obj);
    }

    public void save() {
        if (this.removeObject.size() > 0) {
            for (int i = 0; i < this.removeObject.size(); ++i) {
                try {
                    this.delegate.getCurrentPreference().node(this.removeObject.get(i)).removeNode();
                    continue;
                }
                catch (BackingStoreException e) {
                    new CayenneRuntimeException("Error saving preference", new Object[0]);
                }
            }
        }
        for (Map.Entry<String, Object> pairs : this.children.entrySet()) {
            this.delegate.getCurrentPreference().node(pairs.getKey());
            ((CayennePreference)pairs.getValue()).saveObjectPreference();
        }
    }

    public void cancel() {
        this.children.clear();
        this.initChildrenPreferences();
    }
}

