/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.resource;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import org.apache.cayenne.ConfigurationException;
import org.apache.cayenne.resource.Resource;
import org.apache.cayenne.resource.ResourceLocator;
import org.apache.cayenne.resource.URLResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoaderResourceLocator
implements ResourceLocator {
    @Override
    public Collection<Resource> findResources(String name) {
        Enumeration<URL> urls;
        ArrayList<Resource> resources = new ArrayList<Resource>(3);
        try {
            urls = this.getClassLoader().getResources(name);
        }
        catch (IOException e) {
            throw new ConfigurationException("Error getting resources for ", new Object[0]);
        }
        while (urls.hasMoreElements()) {
            resources.add(new URLResource(urls.nextElement()));
        }
        return resources;
    }

    protected ClassLoader getClassLoader() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = this.getClass().getClassLoader();
        }
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        if (loader == null) {
            throw new IllegalStateException("Can't detect ClassLoader to use for resouyrce location");
        }
        return loader;
    }
}

