/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.tool;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.MinimalPrettyPrinter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import org.apache.avro.tool.Tool;
import org.apache.avro.tool.TrevniUtil;
import org.apache.trevni.ColumnFileReader;
import org.apache.trevni.ColumnMetaData;
import org.apache.trevni.ColumnValues;
import org.apache.trevni.Input;

public class TrevniToJsonTool
implements Tool {
    static final JsonFactory FACTORY = new JsonFactory();
    private JsonGenerator generator;
    private ColumnValues[] values;
    private String[] shortNames;

    @Override
    public String getName() {
        return "trevni_tojson";
    }

    @Override
    public String getShortDescription() {
        return "Dumps a Trevni file as JSON.";
    }

    @Override
    public int run(InputStream stdin, PrintStream out, PrintStream err, List<String> args) throws Exception {
        String filename;
        boolean pretty = false;
        if (args.size() == 2 && "-pretty".equals(args.get(0))) {
            pretty = true;
            filename = args.get(1);
        } else if (args.size() == 1) {
            filename = args.get(0);
        } else {
            err.println("Usage: [-pretty] input");
            return 1;
        }
        this.toJson(TrevniUtil.input(filename), out, pretty);
        return 0;
    }

    public void toJson(Input input, PrintStream out, boolean pretty) throws IOException {
        this.generator = FACTORY.createGenerator((OutputStream)out, JsonEncoding.UTF8);
        if (pretty) {
            this.generator.useDefaultPrettyPrinter();
        } else {
            MinimalPrettyPrinter pp = new MinimalPrettyPrinter();
            pp.setRootValueSeparator(System.getProperty("line.separator"));
            this.generator.setPrettyPrinter((PrettyPrinter)pp);
        }
        ColumnFileReader reader = new ColumnFileReader(input);
        int columnCount = (int)reader.getColumnCount();
        this.values = new ColumnValues[columnCount];
        this.shortNames = new String[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            this.values[i] = reader.getValues(i);
            this.shortNames[i] = this.shortName(reader.getColumnMetaData(i));
        }
        List roots = reader.getRoots();
        for (long row = 0L; row < reader.getRowCount(); ++row) {
            for (ColumnValues v : this.values) {
                v.startRow();
            }
            this.generator.writeStartObject();
            for (ColumnMetaData root : roots) {
                this.valueToJson(root);
            }
            this.generator.writeEndObject();
        }
        this.generator.flush();
        out.println();
        reader.close();
    }

    private void valueToJson(ColumnMetaData column) throws IOException {
        this.generator.writeFieldName(this.shortNames[column.getNumber()]);
        ColumnValues in = this.values[column.getNumber()];
        if (!column.isArray()) {
            this.primitiveToJson(column, in.nextValue());
        } else {
            this.generator.writeStartArray();
            int length = in.nextLength();
            for (int i = 0; i < length; ++i) {
                Comparable value = in.nextValue();
                List children = column.getChildren();
                if (children.size() == 0) {
                    this.primitiveToJson(column, value);
                    continue;
                }
                this.generator.writeStartObject();
                if (value != null) {
                    this.generator.writeFieldName("value$");
                    this.primitiveToJson(column, value);
                }
                for (ColumnMetaData child : children) {
                    this.valueToJson(child);
                }
                this.generator.writeEndObject();
            }
            this.generator.writeEndArray();
        }
    }

    private void primitiveToJson(ColumnMetaData column, Object value) throws IOException {
        switch (column.getType()) {
            case NULL: {
                this.generator.writeNull();
                break;
            }
            case BOOLEAN: {
                this.generator.writeBoolean(((Boolean)value).booleanValue());
                break;
            }
            case INT: {
                this.generator.writeNumber(((Integer)value).intValue());
                break;
            }
            case LONG: {
                this.generator.writeNumber(((Long)value).longValue());
                break;
            }
            case FIXED32: {
                this.generator.writeNumber(((Integer)value).intValue());
                break;
            }
            case FIXED64: {
                this.generator.writeNumber(((Long)value).longValue());
                break;
            }
            case FLOAT: {
                this.generator.writeNumber(((Float)value).floatValue());
                break;
            }
            case DOUBLE: {
                this.generator.writeNumber(((Double)value).doubleValue());
                break;
            }
            case STRING: {
                this.generator.writeString((String)value);
                break;
            }
            case BYTES: {
                this.generator.writeBinary((byte[])value);
                break;
            }
            default: {
                throw new RuntimeException("Unknown value type: " + String.valueOf(column.getType()));
            }
        }
    }

    private String shortName(ColumnMetaData column) {
        String name = column.getName();
        ColumnMetaData parent = column.getParent();
        if (parent != null && name.startsWith(parent.getName())) {
            name = name.substring(parent.getName().length());
        }
        if (!Character.isLetterOrDigit(name.charAt(0))) {
            name = name.substring(1);
        }
        return name;
    }
}

