/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Write records and execute queries on AWS time-series database
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface Timestream2EndpointBuilderFactory {

    /**
     * Builder for endpoint for the AWS Timestream component.
     */
    public interface Timestream2EndpointBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedTimestream2EndpointBuilder advanced() {
            return (AdvancedTimestream2EndpointBuilder) this;
        }

        /**
         * The operation to perform. It can be
         * describeEndpoints,createBatchLoadTask,describeBatchLoadTask,
         * resumeBatchLoadTask,listBatchLoadTasks,createDatabase,deleteDatabase,describeDatabase,updateDatabase, listDatabases,createTable,deleteTable,describeTable,updateTable,listTables,writeRecords, createScheduledQuery,deleteScheduledQuery,executeScheduledQuery,updateScheduledQuery, describeScheduledQuery,listScheduledQueries,prepareQuery,query,cancelQuery.
         * 
         * The option is a:
         * <code>org.apache.camel.component.aws2.timestream.Timestream2Operations</code> type.
         * 
         * Required: true
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default Timestream2EndpointBuilder operation(org.apache.camel.component.aws2.timestream.Timestream2Operations operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * The operation to perform. It can be
         * describeEndpoints,createBatchLoadTask,describeBatchLoadTask,
         * resumeBatchLoadTask,listBatchLoadTasks,createDatabase,deleteDatabase,describeDatabase,updateDatabase, listDatabases,createTable,deleteTable,describeTable,updateTable,listTables,writeRecords, createScheduledQuery,deleteScheduledQuery,executeScheduledQuery,updateScheduledQuery, describeScheduledQuery,listScheduledQueries,prepareQuery,query,cancelQuery.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.aws2.timestream.Timestream2Operations</code> type.
         * 
         * Required: true
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default Timestream2EndpointBuilder operation(String operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * Set the need for overriding the endpoint. This option needs to be
         * used in combination with the uriEndpointOverride option.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param overrideEndpoint the value to set
         * @return the dsl builder
         */
        default Timestream2EndpointBuilder overrideEndpoint(boolean overrideEndpoint) {
            doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }
        /**
         * Set the need for overriding the endpoint. This option needs to be
         * used in combination with the uriEndpointOverride option.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param overrideEndpoint the value to set
         * @return the dsl builder
         */
        default Timestream2EndpointBuilder overrideEndpoint(String overrideEndpoint) {
            doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }
        /**
         * If we want to use a POJO request as body or not.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param pojoRequest the value to set
         * @return the dsl builder
         */
        default Timestream2EndpointBuilder pojoRequest(boolean pojoRequest) {
            doSetProperty("pojoRequest", pojoRequest);
            return this;
        }
        /**
         * If we want to use a POJO request as body or not.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param pojoRequest the value to set
         * @return the dsl builder
         */
        default Timestream2EndpointBuilder pojoRequest(String pojoRequest) {
            doSetProperty("pojoRequest", pojoRequest);
            return this;
        }
        /**
         * If using a profile credentials provider, this parameter will set the
         * profile name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param profileCredentialsName the value to set
         * @return the dsl builder
         */
        default Timestream2EndpointBuilder profileCredentialsName(String profileCredentialsName) {
            doSetProperty("profileCredentialsName", profileCredentialsName);
            return this;
        }
        /**
         * The region in which the Timestream client needs to work. When using
         * this parameter, the configuration will expect the lowercase name of
         * the region (for example, ap-east-1) You'll need to use the name
         * Region.EU_WEST_1.id().
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param region the value to set
         * @return the dsl builder
         */
        default Timestream2EndpointBuilder region(String region) {
            doSetProperty("region", region);
            return this;
        }
        /**
         * If we want to trust all certificates in case of overriding the
         * endpoint.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param trustAllCertificates the value to set
         * @return the dsl builder
         */
        default Timestream2EndpointBuilder trustAllCertificates(boolean trustAllCertificates) {
            doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }
        /**
         * If we want to trust all certificates in case of overriding the
         * endpoint.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param trustAllCertificates the value to set
         * @return the dsl builder
         */
        default Timestream2EndpointBuilder trustAllCertificates(String trustAllCertificates) {
            doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }
        /**
         * Set the overriding uri endpoint. This option needs to be used in
         * combination with overrideEndpoint option.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param uriEndpointOverride the value to set
         * @return the dsl builder
         */
        default Timestream2EndpointBuilder uriEndpointOverride(String uriEndpointOverride) {
            doSetProperty("uriEndpointOverride", uriEndpointOverride);
            return this;
        }
        /**
         * Set whether the Timestream client should expect to load credentials
         * through a default credentials provider or to expect static
         * credentials to be passed in.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param useDefaultCredentialsProvider the value to set
         * @return the dsl builder
         */
        default Timestream2EndpointBuilder useDefaultCredentialsProvider(boolean useDefaultCredentialsProvider) {
            doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }
        /**
         * Set whether the Timestream client should expect to load credentials
         * through a default credentials provider or to expect static
         * credentials to be passed in.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param useDefaultCredentialsProvider the value to set
         * @return the dsl builder
         */
        default Timestream2EndpointBuilder useDefaultCredentialsProvider(String useDefaultCredentialsProvider) {
            doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }
        /**
         * Set whether the Timestream client should expect to load credentials
         * through a profile credentials provider.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param useProfileCredentialsProvider the value to set
         * @return the dsl builder
         */
        default Timestream2EndpointBuilder useProfileCredentialsProvider(boolean useProfileCredentialsProvider) {
            doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }
        /**
         * Set whether the Timestream client should expect to load credentials
         * through a profile credentials provider.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param useProfileCredentialsProvider the value to set
         * @return the dsl builder
         */
        default Timestream2EndpointBuilder useProfileCredentialsProvider(String useProfileCredentialsProvider) {
            doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }
        /**
         * To define a proxy host when instantiating the Timestream client.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         * 
         * @param proxyHost the value to set
         * @return the dsl builder
         */
        default Timestream2EndpointBuilder proxyHost(String proxyHost) {
            doSetProperty("proxyHost", proxyHost);
            return this;
        }
        /**
         * To define a proxy port when instantiating the Timestream client.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: proxy
         * 
         * @param proxyPort the value to set
         * @return the dsl builder
         */
        default Timestream2EndpointBuilder proxyPort(Integer proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * To define a proxy port when instantiating the Timestream client.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: proxy
         * 
         * @param proxyPort the value to set
         * @return the dsl builder
         */
        default Timestream2EndpointBuilder proxyPort(String proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * To define a proxy protocol when instantiating the Timestream client.
         * 
         * The option is a: <code>software.amazon.awssdk.core.Protocol</code>
         * type.
         * 
         * Default: HTTPS
         * Group: proxy
         * 
         * @param proxyProtocol the value to set
         * @return the dsl builder
         */
        default Timestream2EndpointBuilder proxyProtocol(software.amazon.awssdk.core.Protocol proxyProtocol) {
            doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }
        /**
         * To define a proxy protocol when instantiating the Timestream client.
         * 
         * The option will be converted to a
         * <code>software.amazon.awssdk.core.Protocol</code> type.
         * 
         * Default: HTTPS
         * Group: proxy
         * 
         * @param proxyProtocol the value to set
         * @return the dsl builder
         */
        default Timestream2EndpointBuilder proxyProtocol(String proxyProtocol) {
            doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }
        /**
         * Amazon AWS Access Key.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param accessKey the value to set
         * @return the dsl builder
         */
        default Timestream2EndpointBuilder accessKey(String accessKey) {
            doSetProperty("accessKey", accessKey);
            return this;
        }
        /**
         * Amazon AWS Secret Key.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param secretKey the value to set
         * @return the dsl builder
         */
        default Timestream2EndpointBuilder secretKey(String secretKey) {
            doSetProperty("secretKey", secretKey);
            return this;
        }
        /**
         * Amazon AWS Session Token used when the user needs to assume an IAM
         * role.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param sessionToken the value to set
         * @return the dsl builder
         */
        default Timestream2EndpointBuilder sessionToken(String sessionToken) {
            doSetProperty("sessionToken", sessionToken);
            return this;
        }
        /**
         * Set whether the Timestream client should expect to use Session
         * Credentials. This is useful in a situation in which the user needs to
         * assume an IAM role for doing operations in Timestream.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useSessionCredentials the value to set
         * @return the dsl builder
         */
        default Timestream2EndpointBuilder useSessionCredentials(boolean useSessionCredentials) {
            doSetProperty("useSessionCredentials", useSessionCredentials);
            return this;
        }
        /**
         * Set whether the Timestream client should expect to use Session
         * Credentials. This is useful in a situation in which the user needs to
         * assume an IAM role for doing operations in Timestream.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useSessionCredentials the value to set
         * @return the dsl builder
         */
        default Timestream2EndpointBuilder useSessionCredentials(String useSessionCredentials) {
            doSetProperty("useSessionCredentials", useSessionCredentials);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the AWS Timestream component.
     */
    public interface AdvancedTimestream2EndpointBuilder
            extends
                EndpointProducerBuilder {
        default Timestream2EndpointBuilder basic() {
            return (Timestream2EndpointBuilder) this;
        }

        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedTimestream2EndpointBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedTimestream2EndpointBuilder lazyStartProducer(String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * To use an existing configured AwsTimestreamQueryClient client.
         * 
         * The option is a:
         * <code>software.amazon.awssdk.services.timestreamquery.TimestreamQueryClient</code> type.
         * 
         * Group: advanced
         * 
         * @param awsTimestreamQueryClient the value to set
         * @return the dsl builder
         */
        default AdvancedTimestream2EndpointBuilder awsTimestreamQueryClient(software.amazon.awssdk.services.timestreamquery.TimestreamQueryClient awsTimestreamQueryClient) {
            doSetProperty("awsTimestreamQueryClient", awsTimestreamQueryClient);
            return this;
        }
        /**
         * To use an existing configured AwsTimestreamQueryClient client.
         * 
         * The option will be converted to a
         * <code>software.amazon.awssdk.services.timestreamquery.TimestreamQueryClient</code> type.
         * 
         * Group: advanced
         * 
         * @param awsTimestreamQueryClient the value to set
         * @return the dsl builder
         */
        default AdvancedTimestream2EndpointBuilder awsTimestreamQueryClient(String awsTimestreamQueryClient) {
            doSetProperty("awsTimestreamQueryClient", awsTimestreamQueryClient);
            return this;
        }
        /**
         * To use an existing configured AwsTimestreamWriteClient client.
         * 
         * The option is a:
         * <code>software.amazon.awssdk.services.timestreamwrite.TimestreamWriteClient</code> type.
         * 
         * Group: advanced
         * 
         * @param awsTimestreamWriteClient the value to set
         * @return the dsl builder
         */
        default AdvancedTimestream2EndpointBuilder awsTimestreamWriteClient(software.amazon.awssdk.services.timestreamwrite.TimestreamWriteClient awsTimestreamWriteClient) {
            doSetProperty("awsTimestreamWriteClient", awsTimestreamWriteClient);
            return this;
        }
        /**
         * To use an existing configured AwsTimestreamWriteClient client.
         * 
         * The option will be converted to a
         * <code>software.amazon.awssdk.services.timestreamwrite.TimestreamWriteClient</code> type.
         * 
         * Group: advanced
         * 
         * @param awsTimestreamWriteClient the value to set
         * @return the dsl builder
         */
        default AdvancedTimestream2EndpointBuilder awsTimestreamWriteClient(String awsTimestreamWriteClient) {
            doSetProperty("awsTimestreamWriteClient", awsTimestreamWriteClient);
            return this;
        }
    }

    public interface Timestream2Builders {
        /**
         * AWS Timestream (camel-aws2-timestream)
         * Write records and execute queries on AWS time-series database
         * 
         * Category: cloud,database
         * Since: 4.1
         * Maven coordinates: org.apache.camel:camel-aws2-timestream
         * 
         * @return the dsl builder for the headers' name.
         */
        default Timestream2HeaderNameBuilder aws2Timestream() {
            return Timestream2HeaderNameBuilder.INSTANCE;
        }
        /**
         * AWS Timestream (camel-aws2-timestream)
         * Write records and execute queries on AWS time-series database
         * 
         * Category: cloud,database
         * Since: 4.1
         * Maven coordinates: org.apache.camel:camel-aws2-timestream
         * 
         * Syntax: <code>aws2-timestream:clientType:label</code>
         * 
         * Path parameter: clientType (required)
         * Type of client - write/query
         * There are 2 enums and the value can be one of: write, query
         * 
         * Path parameter: label (required)
         * Logical name
         * 
         * @param path clientType:label
         * @return the dsl builder
         */
        default Timestream2EndpointBuilder aws2Timestream(String path) {
            return Timestream2EndpointBuilderFactory.endpointBuilder("aws2-timestream", path);
        }
        /**
         * AWS Timestream (camel-aws2-timestream)
         * Write records and execute queries on AWS time-series database
         * 
         * Category: cloud,database
         * Since: 4.1
         * Maven coordinates: org.apache.camel:camel-aws2-timestream
         * 
         * Syntax: <code>aws2-timestream:clientType:label</code>
         * 
         * Path parameter: clientType (required)
         * Type of client - write/query
         * There are 2 enums and the value can be one of: write, query
         * 
         * Path parameter: label (required)
         * Logical name
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path clientType:label
         * @return the dsl builder
         */
        default Timestream2EndpointBuilder aws2Timestream(String componentName, String path) {
            return Timestream2EndpointBuilderFactory.endpointBuilder(componentName, path);
        }

    }
    /**
     * The builder of headers' name for the AWS Timestream component.
     */
    public static class Timestream2HeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final Timestream2HeaderNameBuilder INSTANCE = new Timestream2HeaderNameBuilder();

        /**
         * The operation we want to perform.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsTimestreamOperation}.
         */
        public String awsTimestreamOperation() {
            return "CamelAwsTimestreamOperation";
        }
        /**
         * Represents a time-series data point being written into Timestream.
         * 
         * The option is a: {@code
         * software.amazon.awssdk.services.timestreamwrite.model.Record} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsTimestreamRecord}.
         */
        public String awsTimestreamRecord() {
            return "CamelAwsTimestreamRecord";
        }
        /**
         * List of Records.
         * 
         * The option is a: {@code List} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsTimestreamRecordList}.
         */
        public String awsTimestreamRecordList() {
            return "CamelAwsTimestreamRecordList";
        }
        /**
         * Status of Batch Load Task.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsTimestreamTaskStatus}.
         */
        public String awsTimestreamTaskStatus() {
            return "CamelAwsTimestreamTaskStatus";
        }
        /**
         * The ID of the batch load task to resume.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsTimestreamTaskId}.
         */
        public String awsTimestreamTaskId() {
            return "CamelAwsTimestreamTaskId";
        }
        /**
         * Name of Database.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsTimestreamDatabaseName}.
         */
        public String awsTimestreamDatabaseName() {
            return "CamelAwsTimestreamDatabaseName";
        }
        /**
         * Name of Table.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsTimestreamTableName}.
         */
        public String awsTimestreamTableName() {
            return "CamelAwsTimestreamTableName";
        }
        /**
         * Name of Target Database.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * AwsTimestreamTargetDatabaseName}.
         */
        public String awsTimestreamTargetDatabaseName() {
            return "CamelAwsTimestreamTargetDatabaseName";
        }
        /**
         * Name of Target Table.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsTimestreamTargetTableName}.
         */
        public String awsTimestreamTargetTableName() {
            return "CamelAwsTimestreamTargetTableName";
        }
        /**
         * Record version.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsTimestreamRecordVersion}.
         */
        public String awsTimestreamRecordVersion() {
            return "CamelAwsTimestreamRecordVersion";
        }
        /**
         * Configuration of Data Model.
         * 
         * The option is a: {@code
         * software.amazon.awssdk.services.timestreamwrite.model.DataModelConfiguration} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * AwsTimestreamDataModelConfiguration}.
         */
        public String awsTimestreamDataModelConfiguration() {
            return "CamelAwsTimestreamDataModelConfiguration";
        }
        /**
         * Configuration of Data Source.
         * 
         * The option is a: {@code
         * software.amazon.awssdk.services.timestreamwrite.model.DataSourceConfiguration} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * AwsTimestreamDataSourceConfiguration}.
         */
        public String awsTimestreamDataSourceConfiguration() {
            return "CamelAwsTimestreamDataSourceConfiguration";
        }
        /**
         * Reporting Configuration.
         * 
         * The option is a: {@code
         * software.amazon.awssdk.services.timestreamwrite.model.ReportConfiguration} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * AwsTimestreamReportConfiguration}.
         */
        public String awsTimestreamReportConfiguration() {
            return "CamelAwsTimestreamReportConfiguration";
        }
        /**
         * Timestream Table Schema.
         * 
         * The option is a: {@code
         * software.amazon.awssdk.services.timestreamwrite.model.Schema} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsTimestreamTableSchema}.
         */
        public String awsTimestreamTableSchema() {
            return "CamelAwsTimestreamTableSchema";
        }
        /**
         * Timestream Table Retention Properties.
         * 
         * The option is a: {@code
         * software.amazon.awssdk.services.timestreamwrite.model.RetentionProperties} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * AwsTimestreamRetentionProperties}.
         */
        public String awsTimestreamRetentionProperties() {
            return "CamelAwsTimestreamRetentionProperties";
        }
        /**
         * Timestream Table Magentic Store Write properties.
         * 
         * The option is a: {@code
         * software.amazon.awssdk.services.timestreamwrite.model.MagneticStoreWriteProperties} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * AwsTimestreamMagneticStoreWriteProperties}.
         */
        public String awsTimestreamMagneticStoreWriteProperties() {
            return "CamelAwsTimestreamMagneticStoreWriteProperties";
        }
        /**
         * Name of Time column.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsTimestreamTimeColumn}.
         */
        public String awsTimestreamTimeColumn() {
            return "CamelAwsTimestreamTimeColumn";
        }
        /**
         * Name of the measure column.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * AwsTimestreamMeasureColumnName}.
         */
        public String awsTimestreamMeasureColumnName() {
            return "CamelAwsTimestreamMeasureColumnName";
        }
        /**
         * This is to allow mapping column(s) from the query result to the
         * dimension in the destination table.
         * 
         * The option is a: {@code List} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * AwsTimestreamDimensionMappingList}.
         */
        public String awsTimestreamDimensionMappingList() {
            return "CamelAwsTimestreamDimensionMappingList";
        }
        /**
         * Multi-measure mappings.
         * 
         * The option is a: {@code
         * software.amazon.awssdk.services.timestreamquery.model.MultiMeasureMappings} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * AwsTimestreamMultiMeasureMappings}.
         */
        public String awsTimestreamMultiMeasureMappings() {
            return "CamelAwsTimestreamMultiMeasureMappings";
        }
        /**
         * Specifies how to map measures to multi-measure records.
         * 
         * The option is a: {@code List} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * AwsTimestreamMixedMeasureMappingList}.
         */
        public String awsTimestreamMixedMeasureMappingList() {
            return "CamelAwsTimestreamMixedMeasureMappingList";
        }
        /**
         * Name of scheduled query.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * AwsTimestreamScheduledQueryName}.
         */
        public String awsTimestreamScheduledQueryName() {
            return "CamelAwsTimestreamScheduledQueryName";
        }
        /**
         * Arn of scheduled query.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * AwsTimestreamScheduledQueryArn}.
         */
        public String awsTimestreamScheduledQueryArn() {
            return "CamelAwsTimestreamScheduledQueryArn";
        }
        /**
         * State of scheduled query.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * AwsTimestreamScheduledQueryState}.
         */
        public String awsTimestreamScheduledQueryState() {
            return "CamelAwsTimestreamScheduledQueryState";
        }
        /**
         * Invocation Time for scheduled query execution.
         * 
         * The option is a: {@code Instant} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * AwsTimestreamScheduledQueryInvocationTime}.
         */
        public String awsTimestreamScheduledQueryInvocationTime() {
            return "CamelAwsTimestreamScheduledQueryInvocationTime";
        }
        /**
         * The query string to run.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsTimestreamQueryString}.
         */
        public String awsTimestreamQueryString() {
            return "CamelAwsTimestreamQueryString";
        }
        /**
         * ID of query.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsTimestreamQueryId}.
         */
        public String awsTimestreamQueryId() {
            return "CamelAwsTimestreamQueryId";
        }
        /**
         * Validates the prepared query, but does not store for later execution.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * AwsTimestreamQueryValidateOnly}.
         */
        public String awsTimestreamQueryValidateOnly() {
            return "CamelAwsTimestreamQueryValidateOnly";
        }
        /**
         * The total number of rows to be returned in the Query output.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsTimestreamQueryMaxRows}.
         */
        public String awsTimestreamQueryMaxRows() {
            return "CamelAwsTimestreamQueryMaxRows";
        }
        /**
         * Max Results to be returned in output.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsTimestreamMaxResults}.
         */
        public String awsTimestreamMaxResults() {
            return "CamelAwsTimestreamMaxResults";
        }
        /**
         * The schedule expression for the query.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * AwsTimestreamScheduleExpression}.
         */
        public String awsTimestreamScheduleExpression() {
            return "CamelAwsTimestreamScheduleExpression";
        }
        /**
         * Notification Topic Arn for the scheduled query.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * AwsTimestreamNotificationTopicArn}.
         */
        public String awsTimestreamNotificationTopicArn() {
            return "CamelAwsTimestreamNotificationTopicArn";
        }
        /**
         * S3 Bucket name for error reporting.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * AwsTimestreamErrorReportS3BucketName}.
         */
        public String awsTimestreamErrorReportS3BucketName() {
            return "CamelAwsTimestreamErrorReportS3BucketName";
        }
        /**
         * S3 object key prefix for error reporting.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * AwsTimestreamErrorReportS3ObjectKeyPrefix}.
         */
        public String awsTimestreamErrorReportS3ObjectKeyPrefix() {
            return "CamelAwsTimestreamErrorReportS3ObjectKeyPrefix";
        }
        /**
         * S3 encryption option for error reporting.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * AwsTimestreamErrorReportS3EncryptionOption}.
         */
        public String awsTimestreamErrorReportS3EncryptionOption() {
            return "CamelAwsTimestreamErrorReportS3EncryptionOption";
        }
        /**
         * he ARN for the IAM role that Timestream will assume when running the
         * scheduled query.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * AwsTimestreamScheduledQueryExecutionRoleArn}.
         */
        public String awsTimestreamScheduledQueryExecutionRoleArn() {
            return "CamelAwsTimestreamScheduledQueryExecutionRoleArn";
        }
        /**
         * Using a ClientToken makes the call to CreateScheduledQuery
         * idempotent.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsTimestreamClientToken}.
         */
        public String awsTimestreamClientToken() {
            return "CamelAwsTimestreamClientToken";
        }
        /**
         * The Amazon KMS key used to encrypt the scheduled query resource,
         * at-rest.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsTimestreamKmsKeyId}.
         */
        public String awsTimestreamKmsKeyId() {
            return "CamelAwsTimestreamKmsKeyId";
        }
    }
    static Timestream2EndpointBuilder endpointBuilder(String componentName, String path) {
        class Timestream2EndpointBuilderImpl extends AbstractEndpointBuilder implements Timestream2EndpointBuilder, AdvancedTimestream2EndpointBuilder {
            public Timestream2EndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new Timestream2EndpointBuilderImpl(path);
    }
}