/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.store.shared;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.ehcache.CachePersistenceException;
import org.ehcache.config.Eviction;
import org.ehcache.config.EvictionAdvisor;
import org.ehcache.config.ResourcePool;
import org.ehcache.config.ResourceType;
import org.ehcache.core.EhcachePrefixLoggerFactory;
import org.ehcache.core.spi.service.StatisticsService;
import org.ehcache.core.spi.store.Store;
import org.ehcache.core.spi.store.tiering.AuthoritativeTier;
import org.ehcache.core.spi.store.tiering.CachingTier;
import org.ehcache.core.store.StoreConfigurationImpl;
import org.ehcache.core.store.StoreSupport;
import org.ehcache.core.util.ClassLoading;
import org.ehcache.expiry.ExpiryPolicy;
import org.ehcache.impl.config.ResourcePoolsImpl;
import org.ehcache.impl.internal.store.shared.AbstractPartition;
import org.ehcache.impl.internal.store.shared.StateHolderIdGenerator;
import org.ehcache.impl.internal.store.shared.composites.CompositeEvictionAdvisor;
import org.ehcache.impl.internal.store.shared.composites.CompositeExpiryPolicy;
import org.ehcache.impl.internal.store.shared.composites.CompositeInvalidationListener;
import org.ehcache.impl.internal.store.shared.composites.CompositeInvalidationValve;
import org.ehcache.impl.internal.store.shared.composites.CompositeSerializer;
import org.ehcache.impl.internal.store.shared.composites.CompositeValue;
import org.ehcache.spi.loaderwriter.CacheLoaderWriter;
import org.ehcache.spi.persistence.PersistableResourceService;
import org.ehcache.spi.persistence.StateRepository;
import org.ehcache.spi.serialization.Serializer;
import org.ehcache.spi.service.Service;
import org.ehcache.spi.service.ServiceConfiguration;
import org.ehcache.spi.service.ServiceProvider;
import org.slf4j.Logger;

public class SharedStorage {
    protected final Logger logger = EhcachePrefixLoggerFactory.getLogger(SharedStorage.class);
    private ServiceProvider<Service> serviceProvider;
    private int lastUsedId = 0;
    private final Map<Integer, Serializer<?>> keySerializerMap = new HashMap();
    private final Map<Integer, Serializer<?>> valueSerializerMap = new HashMap();
    private final Map<Integer, EvictionAdvisor<?, ?>> evictionAdvisorMap = new HashMap();
    private final Map<Integer, ExpiryPolicy<?, ?>> expiryPolicyMap = new HashMap();
    private final Map<Integer, AuthoritativeTier.InvalidationValve> invalidationValveMap = new HashMap<Integer, AuthoritativeTier.InvalidationValve>();
    private final Map<Integer, CachingTier.InvalidationListener<?, ?>> invalidationListenerMap = new HashMap();
    private final ResourcePool resourcePool;
    private Store.Provider storeProvider = null;
    private Store<CompositeValue<?>, CompositeValue<?>> store = null;
    private StateHolderIdGenerator<String> persistentPartitionIds = null;
    private PersistableResourceService.PersistenceSpaceIdentifier<?> sharedResourcesSpaceIdentifier;
    private PersistableResourceService persistableResourceService;
    private final boolean persistent;

    public SharedStorage(ResourcePool resourcePool) {
        this.resourcePool = Objects.requireNonNull(resourcePool);
        this.persistent = resourcePool.isPersistent();
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public void start(ServiceProvider<Service> serviceProvider) {
        this.serviceProvider = serviceProvider;
        HashSet serviceConfigs = new HashSet();
        ClassLoader classLoader = ClassLoading.getDefaultClassLoader();
        CacheLoaderWriter<CompositeValue<?>, CompositeValue<?>> cacheLoaderWriter = null;
        this.createSharedStore(classLoader, serviceConfigs, cacheLoaderWriter);
    }

    public void stop() {
        if (this.storeProvider != null && this.store != null) {
            this.storeProvider.releaseStore(this.store);
        }
        if (this.persistableResourceService != null && this.sharedResourcesSpaceIdentifier != null) {
            try {
                this.persistableResourceService.releasePersistenceSpaceIdentifier(this.sharedResourcesSpaceIdentifier);
            }
            catch (CachePersistenceException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void createSharedStore(ClassLoader classLoader, Collection<ServiceConfiguration<?, ?>> serviceConfigs, CacheLoaderWriter<CompositeValue<?>, CompositeValue<?>> cacheLoaderWriter) {
        ResourceType<?> type = this.resourcePool.getType();
        if (type.isPersistable()) {
            Set persistenceServices = this.serviceProvider.getServicesOfType(PersistableResourceService.class).stream().filter(persistence -> persistence.handlesResourceType(type)).collect(Collectors.toSet());
            if (persistenceServices.size() > 1) {
                throw new IllegalStateException("Multiple persistence services for " + type);
            }
            if (persistenceServices.isEmpty()) {
                throw new IllegalStateException("No persistence services for " + type);
            }
            try {
                this.persistableResourceService = (PersistableResourceService)persistenceServices.iterator().next();
                this.sharedResourcesSpaceIdentifier = this.persistableResourceService.getSharedPersistenceSpaceIdentifier(this.resourcePool);
                this.persistentPartitionIds = new StateHolderIdGenerator<String>(this.persistableResourceService.getStateRepositoryWithin(this.sharedResourcesSpaceIdentifier, "persistent-partition-ids"), String.class);
                serviceConfigs.add(this.sharedResourcesSpaceIdentifier);
            }
            catch (CachePersistenceException e) {
                throw new RuntimeException("Unable to handle persistence", e);
            }
        }
        Class<CompositeValue> keyType = CompositeValue.class;
        Class<CompositeValue> valueType = CompositeValue.class;
        CompositeSerializer keySerializer = new CompositeSerializer(this.keySerializerMap);
        CompositeSerializer valueSerializer = new CompositeSerializer(this.valueSerializerMap);
        CompositeExpiryPolicy expiry = new CompositeExpiryPolicy(this.expiryPolicyMap);
        CompositeEvictionAdvisor evictionAdvisor = new CompositeEvictionAdvisor(this.evictionAdvisorMap);
        ResourcePoolsImpl resourcePools = new ResourcePoolsImpl(this.resourcePool);
        StoreConfigurationImpl storeConfig = new StoreConfigurationImpl(keyType, valueType, evictionAdvisor, classLoader, expiry, resourcePools, 1, true, keySerializer, valueSerializer, cacheLoaderWriter, false);
        ServiceConfiguration[] serviceConfigArray = serviceConfigs.toArray(new ServiceConfiguration[0]);
        this.storeProvider = StoreSupport.select(Store.ElementalProvider.class, this.serviceProvider, store -> store.rank(resourcePools.getResourceTypeSet(), serviceConfigs));
        this.store = this.storeProvider.createStore(storeConfig, serviceConfigArray);
        if (this.store instanceof AuthoritativeTier) {
            ((AuthoritativeTier)this.store).setInvalidationValve(new CompositeInvalidationValve(this.invalidationValveMap));
        }
        if (this.store instanceof CachingTier) {
            ((CachingTier)((Object)this.store)).setInvalidationListener(new CompositeInvalidationListener(this.invalidationListenerMap));
        }
        this.storeProvider.initStore(this.store);
    }

    protected <T, U, K, V> U createPartition(String alias, Store.Configuration<K, V> storeConfig, PartitionFactory<T, U> partitionFactory) {
        int storeId = this.persistent ? this.persistentPartitionIds.map((String)((Object)((Serializable)((Object)Objects.requireNonNull(alias))))) : ++this.lastUsedId;
        this.keySerializerMap.put(storeId, storeConfig.getKeySerializer());
        this.valueSerializerMap.put(storeId, storeConfig.getValueSerializer());
        this.expiryPolicyMap.put(storeId, storeConfig.getExpiry());
        EvictionAdvisor<Object, Object> evictionAdvisor = storeConfig.getEvictionAdvisor();
        if (evictionAdvisor == null) {
            evictionAdvisor = Eviction.noAdvice();
        }
        this.evictionAdvisorMap.put(storeId, evictionAdvisor);
        return partitionFactory.createPartition(storeId, this.store, this);
    }

    public void releasePartition(AbstractPartition<?> partition) {
        int id = partition.id();
        this.keySerializerMap.remove(id);
        this.valueSerializerMap.remove(id);
        this.expiryPolicyMap.remove(id);
        this.evictionAdvisorMap.remove(id);
        this.expiryPolicyMap.remove(id);
        this.invalidationValveMap.remove(id);
        this.invalidationListenerMap.remove(id);
        StatisticsService statisticsService = this.serviceProvider.getService(StatisticsService.class);
        if (statisticsService != null) {
            statisticsService.cleanForNode(partition);
        }
    }

    public boolean supports(Class<?> providerClass) {
        return providerClass.isInstance(this.store);
    }

    public Map<Integer, CachingTier.InvalidationListener<?, ?>> getInvalidationListeners() {
        return this.invalidationListenerMap;
    }

    public void destroyPartition(String alias) {
        if (this.persistent) {
            this.persistentPartitionIds.purge(alias);
        }
    }

    public StateRepository stateRepository(String name) throws CachePersistenceException {
        return this.persistableResourceService.getStateRepositoryWithin(this.sharedResourcesSpaceIdentifier, name);
    }

    public static interface PartitionFactory<T, U> {
        public U createPartition(int var1, T var2, SharedStorage var3);
    }
}

