/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.apiserver.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.apache.bifromq.apiserver.Headers;
import org.apache.bifromq.apiserver.http.IHTTPRouteMap;
import org.apache.bifromq.apiserver.http.handler.utils.HeaderUtils;
import org.apache.bifromq.plugin.settingprovider.ISettingProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPRequestRouter
extends SimpleChannelInboundHandler<FullHttpRequest> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HTTPRequestRouter.class);
    private static final FullHttpResponse TOO_LARGE_CLOSE = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE, Unpooled.EMPTY_BUFFER);
    private final IHTTPRouteMap routeMap;
    private final ISettingProvider settingProvider;

    public HTTPRequestRouter(IHTTPRouteMap routeMap, ISettingProvider settingProvider) {
        this.routeMap = routeMap;
        this.settingProvider = settingProvider;
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof HttpServerUpgradeHandler.UpgradeEvent) {
            ctx.pipeline().remove((ChannelHandler)this);
        }
        super.userEventTriggered(ctx, evt);
    }

    protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest req) {
        long reqId = HeaderUtils.getOptionalReqId(req);
        req.retain();
        this.doHandle(reqId, req).whenComplete((v, e) -> {
            FullHttpResponse response;
            if (e != null) {
                ByteBuf content = ctx.alloc().buffer();
                content.writeBytes(e.getMessage().getBytes());
                response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, this.toHTTPStatus((Throwable)e), content);
                response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/plain; charset=UTF-8");
            } else {
                response = v;
            }
            response.headers().set(Headers.HEADER_REQ_ID.header, (Object)reqId);
            response.headers().setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, response.content().readableBytes());
            this.doResponse(ctx, req, response);
            req.release();
        });
    }

    private CompletableFuture<FullHttpResponse> doHandle(long reqId, FullHttpRequest req) {
        try {
            log.trace("Handling request: reqId={} \n{}", (Object)reqId, (Object)req);
            return this.routeMap.getHandler((HttpRequest)req).handle(reqId, req);
        }
        catch (Throwable e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private void doResponse(ChannelHandlerContext ctx, FullHttpRequest req, FullHttpResponse response) {
        boolean keepAlive = HttpUtil.isKeepAlive((HttpMessage)req);
        if (keepAlive) {
            if (req.protocolVersion().equals((Object)HttpVersion.HTTP_1_0)) {
                response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
            }
            ctx.writeAndFlush((Object)response);
        } else {
            response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
            ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    private HttpResponseStatus toHTTPStatus(Throwable t) {
        if (t instanceof IllegalArgumentException) {
            return HttpResponseStatus.BAD_REQUEST;
        }
        return HttpResponseStatus.INTERNAL_SERVER_ERROR;
    }

    static {
        TOO_LARGE_CLOSE.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
        TOO_LARGE_CLOSE.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
    }
}

