/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rds.RdsClient;
import software.amazon.awssdk.services.rds.internal.UserAgentUtils;
import software.amazon.awssdk.services.rds.model.DescribePendingMaintenanceActionsRequest;
import software.amazon.awssdk.services.rds.model.DescribePendingMaintenanceActionsResponse;
import software.amazon.awssdk.services.rds.model.ResourcePendingMaintenanceActions;

public class DescribePendingMaintenanceActionsIterable
implements SdkIterable<DescribePendingMaintenanceActionsResponse> {
    private final RdsClient client;
    private final DescribePendingMaintenanceActionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribePendingMaintenanceActionsIterable(RdsClient client, DescribePendingMaintenanceActionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribePendingMaintenanceActionsResponseFetcher();
    }

    public Iterator<DescribePendingMaintenanceActionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ResourcePendingMaintenanceActions> pendingMaintenanceActions() {
        Function<DescribePendingMaintenanceActionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.pendingMaintenanceActions() != null) {
                return response.pendingMaintenanceActions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribePendingMaintenanceActionsResponseFetcher
    implements SyncPageFetcher<DescribePendingMaintenanceActionsResponse> {
        private DescribePendingMaintenanceActionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribePendingMaintenanceActionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribePendingMaintenanceActionsResponse nextPage(DescribePendingMaintenanceActionsResponse previousPage) {
            if (previousPage == null) {
                return DescribePendingMaintenanceActionsIterable.this.client.describePendingMaintenanceActions(DescribePendingMaintenanceActionsIterable.this.firstRequest);
            }
            return DescribePendingMaintenanceActionsIterable.this.client.describePendingMaintenanceActions((DescribePendingMaintenanceActionsRequest)((Object)DescribePendingMaintenanceActionsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

